/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.phase4.model.pmode.AbstractPModeMicroTypeConverter;
import com.helger.phase4.model.pmode.leg.PModeLegBusinessInformation;
import com.helger.phase4.model.pmode.leg.PModePayloadProfile;
import com.helger.phase4.model.pmode.leg.PModeProperty;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.MicroTypeConverter;

public class PModeLegBusinessInformationMicroTypeConverter
extends AbstractPModeMicroTypeConverter<PModeLegBusinessInformation> {
    private static final IMicroQName ATTR_SERVICE = new MicroQName("Service");
    private static final IMicroQName ATTR_SERVICE_TYPE = new MicroQName("ServiceType");
    private static final IMicroQName ATTR_ACTION = new MicroQName("Action");
    private static final String ELEMENT_PROPERTIES = "Properties";
    private static final String ELEMENT_PAYLOAD_PROFILE = "PayloadProfile";
    private static final IMicroQName ATTR_PAYLOAD_PROFILE_MAX_KB = new MicroQName("PayloadProfileMaxKB");
    private static final IMicroQName ATTR_MPCID = new MicroQName("MPCID");

    @Override
    public IMicroElement convertToMicroElement(PModeLegBusinessInformation pModeLegBusinessInformation, String string, String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_SERVICE, pModeLegBusinessInformation.getService());
        microElement.setAttribute(ATTR_SERVICE_TYPE, pModeLegBusinessInformation.getServiceType());
        microElement.setAttribute(ATTR_ACTION, pModeLegBusinessInformation.getAction());
        pModeLegBusinessInformation.properties().forEachValue(pModeProperty -> microElement.appendChild(MicroTypeConverter.convertToMicroElement(pModeProperty, string, ELEMENT_PROPERTIES)));
        pModeLegBusinessInformation.payloadProfiles().forEachValue(pModePayloadProfile -> microElement.appendChild(MicroTypeConverter.convertToMicroElement(pModePayloadProfile, string, ELEMENT_PAYLOAD_PROFILE)));
        if (pModeLegBusinessInformation.hasPayloadProfileMaxKB()) {
            microElement.setAttribute(ATTR_PAYLOAD_PROFILE_MAX_KB, (long)pModeLegBusinessInformation.getPayloadProfileMaxKB());
        }
        microElement.setAttribute(ATTR_MPCID, pModeLegBusinessInformation.getMPCID());
        return microElement;
    }

    @Override
    public PModeLegBusinessInformation convertToNative(IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_SERVICE);
        String string2 = iMicroElement.getAttributeValue(ATTR_SERVICE_TYPE);
        String string3 = iMicroElement.getAttributeValue(ATTR_ACTION);
        CommonsLinkedHashMap<String, PModeProperty> commonsLinkedHashMap = new CommonsLinkedHashMap<String, PModeProperty>();
        for (IMicroElement object22 : iMicroElement.getAllChildElements(ELEMENT_PROPERTIES)) {
            PModeProperty pModeProperty = MicroTypeConverter.convertToNative(object22, PModeProperty.class);
            commonsLinkedHashMap.put(pModeProperty.getName(), pModeProperty);
        }
        CommonsLinkedHashMap commonsLinkedHashMap2 = new CommonsLinkedHashMap();
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_PAYLOAD_PROFILE)) {
            PModePayloadProfile pModePayloadProfile = MicroTypeConverter.convertToNative(iMicroElement2, PModePayloadProfile.class);
            commonsLinkedHashMap2.put(pModePayloadProfile.getName(), pModePayloadProfile);
        }
        Long l = iMicroElement.getAttributeValueWithConversion(ATTR_PAYLOAD_PROFILE_MAX_KB, Long.class);
        String string4 = iMicroElement.getAttributeValue(ATTR_MPCID);
        return new PModeLegBusinessInformation(string, string2, string3, commonsLinkedHashMap, commonsLinkedHashMap2, l, string4);
    }
}

