/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.model.pmode.leg.PModeAddressList;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class PModeLegErrorHandling
implements Serializable {
    public static final boolean DEFAULT_REPORT_AS_RESPONSE = false;
    public static final boolean DEFAULT_REPORT_PROCESS_ERROR_NOTIFY_CONSUMER = false;
    public static final boolean DEFAULT_REPORT_PROCESS_ERROR_NOTIFY_PRDOUCER = false;
    public static final boolean DEFAULT_REPORT_DELIVERY_FAILURES_NOTIFY_PRODUCER = false;
    private PModeAddressList m_aReportSenderErrorsTo;
    private PModeAddressList m_aReportReceiverErrorsTo;
    private ETriState m_eReportAsResponse;
    private ETriState m_eReportProcessErrorNotifyConsumer;
    private ETriState m_eReportProcessErrorNotifyProducer;
    private ETriState m_eReportDeliveryFailuresNotifyProducer;

    public PModeLegErrorHandling(@Nullable PModeAddressList pModeAddressList, @Nullable PModeAddressList pModeAddressList2, @Nonnull ETriState eTriState, @Nonnull ETriState eTriState2, @Nonnull ETriState eTriState3, @Nonnull ETriState eTriState4) {
        this.setReportSenderErrorsTo(pModeAddressList);
        this.setReportReceiverErrorsTo(pModeAddressList2);
        this.setReportAsResponse(eTriState);
        this.setReportProcessErrorNotifyConsumer(eTriState2);
        this.setReportProcessErrorNotifyProducer(eTriState3);
        this.setReportDeliveryFailuresNotifyProducer(eTriState4);
    }

    @Nullable
    public final PModeAddressList getReportSenderErrorsTo() {
        return this.m_aReportSenderErrorsTo;
    }

    @Nonnull
    public final EChange setReportSenderErrorsTo(@Nullable PModeAddressList pModeAddressList) {
        if (EqualsHelper.equals(this.m_aReportSenderErrorsTo, pModeAddressList)) {
            return EChange.UNCHANGED;
        }
        this.m_aReportSenderErrorsTo = pModeAddressList;
        return EChange.CHANGED;
    }

    @Nullable
    public final PModeAddressList getReportReceiverErrorsTo() {
        return this.m_aReportReceiverErrorsTo;
    }

    @Nonnull
    public final EChange setReportReceiverErrorsTo(@Nullable PModeAddressList pModeAddressList) {
        if (EqualsHelper.equals(this.m_aReportReceiverErrorsTo, pModeAddressList)) {
            return EChange.UNCHANGED;
        }
        this.m_aReportReceiverErrorsTo = pModeAddressList;
        return EChange.CHANGED;
    }

    public final boolean isReportAsResponseDefined() {
        return this.m_eReportAsResponse.isDefined();
    }

    public final boolean isReportAsResponse() {
        return this.m_eReportAsResponse.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setReportAsResponse(boolean bl) {
        return this.setReportAsResponse(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setReportAsResponse(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "ReportAsResponse");
        if (eTriState.equals(this.m_eReportAsResponse)) {
            return EChange.UNCHANGED;
        }
        this.m_eReportAsResponse = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isReportProcessErrorNotifyConsumerDefined() {
        return this.m_eReportProcessErrorNotifyConsumer.isDefined();
    }

    public final boolean isReportProcessErrorNotifyConsumer() {
        return this.m_eReportProcessErrorNotifyConsumer.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setReportProcessErrorNotifyConsumer(boolean bl) {
        return this.setReportProcessErrorNotifyConsumer(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setReportProcessErrorNotifyConsumer(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "ReportProcessErrorNotifyConsumer");
        if (eTriState.equals(this.m_eReportProcessErrorNotifyConsumer)) {
            return EChange.UNCHANGED;
        }
        this.m_eReportProcessErrorNotifyConsumer = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isReportProcessErrorNotifyProducerDefined() {
        return this.m_eReportProcessErrorNotifyProducer.isDefined();
    }

    public final boolean isReportProcessErrorNotifyProducer() {
        return this.m_eReportProcessErrorNotifyProducer.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setReportProcessErrorNotifyProducer(boolean bl) {
        return this.setReportProcessErrorNotifyProducer(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setReportProcessErrorNotifyProducer(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "ReportProcessErrorNotifyProducer");
        if (eTriState.equals(this.m_eReportProcessErrorNotifyProducer)) {
            return EChange.UNCHANGED;
        }
        this.m_eReportProcessErrorNotifyProducer = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isReportDeliveryFailuresNotifyProducerDefined() {
        return this.m_eReportDeliveryFailuresNotifyProducer.isDefined();
    }

    public final boolean isReportDeliveryFailuresNotifyProducer() {
        return this.m_eReportDeliveryFailuresNotifyProducer.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setReportDeliveryFailuresNotifyProducer(boolean bl) {
        return this.setReportDeliveryFailuresNotifyProducer(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setReportDeliveryFailuresNotifyProducer(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "ReportDeliveryFailuresNotifyProducer");
        if (eTriState.equals(this.m_eReportDeliveryFailuresNotifyProducer)) {
            return EChange.UNCHANGED;
        }
        this.m_eReportDeliveryFailuresNotifyProducer = eTriState;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeLegErrorHandling pModeLegErrorHandling = (PModeLegErrorHandling)object;
        return EqualsHelper.equals(this.m_aReportSenderErrorsTo, pModeLegErrorHandling.m_aReportSenderErrorsTo) && EqualsHelper.equals(this.m_aReportReceiverErrorsTo, pModeLegErrorHandling.m_aReportReceiverErrorsTo) && this.m_eReportAsResponse.equals(pModeLegErrorHandling.m_eReportAsResponse) && this.m_eReportProcessErrorNotifyConsumer.equals(pModeLegErrorHandling.m_eReportProcessErrorNotifyConsumer) && this.m_eReportProcessErrorNotifyProducer.equals(pModeLegErrorHandling.m_eReportProcessErrorNotifyProducer) && this.m_eReportDeliveryFailuresNotifyProducer.equals(pModeLegErrorHandling.m_eReportDeliveryFailuresNotifyProducer);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aReportSenderErrorsTo).append(this.m_aReportReceiverErrorsTo).append((Enum)this.m_eReportAsResponse)).append((Enum)this.m_eReportProcessErrorNotifyConsumer)).append((Enum)this.m_eReportProcessErrorNotifyProducer)).append((Enum)this.m_eReportDeliveryFailuresNotifyProducer)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ReportSenderErrorsTo", this.m_aReportSenderErrorsTo).append("ReportReceiverErrorsTo", this.m_aReportReceiverErrorsTo).append("ReportAsResponse", this.m_eReportAsResponse).append("ReportProcessErrorNotifyConsumer", this.m_eReportProcessErrorNotifyConsumer).append("ReportProcessErrorNotifyProducer", this.m_eReportProcessErrorNotifyProducer).append("ReportDeliveryFailuresNotifyProducer", this.m_eReportDeliveryFailuresNotifyProducer).getToString();
    }
}

