/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.wss.EWSSVersion;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class PModeLegSecurity
implements Serializable {
    public static final boolean DEFAULT_USERNAME_TOKEN_DIGEST = false;
    public static final boolean DEFAULT_USERNAME_TOKEN_NONCE = false;
    public static final boolean DEFAULT_USERNAME_TOKEN_CREATED = false;
    public static final boolean DEFAULT_PMODE_AUTHORIZE = false;
    public static final boolean DEFAULT_X509_SIGN = false;
    public static final boolean DEFAULT_X509_ENCRYPTION_ENCRYPT = false;
    public static final boolean DEFAULT_SEND_RECEIPT = false;
    public static final boolean DEFAULT_SEND_RECEIPT_NON_REPUDIATION = false;
    private EWSSVersion m_eWSSVersion;
    private final ICommonsList<String> m_aX509SignElement = new CommonsArrayList<String>();
    private final ICommonsList<String> m_aX509SignAttachment = new CommonsArrayList<String>();
    private String m_sX509SignatureCertificate;
    private ECryptoAlgorithmSignDigest m_eX509SignatureHashFunction;
    private ECryptoAlgorithmSign m_eX509SignatureAlgorithm;
    private final ICommonsList<String> m_aX509EncryptionEncryptElement = new CommonsArrayList<String>();
    private final ICommonsList<String> m_aX509EncryptionEncryptAttachment = new CommonsArrayList<String>();
    private String m_sX509EncryptionCertificate;
    private ECryptoAlgorithmCrypt m_eX509EncryptionAlgorithm;
    private Integer m_aX509EncryptionMinimumStrength;
    private String m_sUsernameTokenUsername;
    private String m_sUsernameTokenPassword;
    private ETriState m_eUsernameTokenDigest = ETriState.UNDEFINED;
    private ETriState m_eUsernameTokenNonce = ETriState.UNDEFINED;
    private ETriState m_eUsernameTokenCreated = ETriState.UNDEFINED;
    private ETriState m_ePModeAuthorize = ETriState.UNDEFINED;
    private ETriState m_eSendReceipt = ETriState.UNDEFINED;
    private EPModeSendReceiptReplyPattern m_eSendReceiptReplyPattern;
    private ETriState m_eSendReceiptNonRepudiation = ETriState.UNDEFINED;

    public PModeLegSecurity() {
    }

    public PModeLegSecurity(@Nullable EWSSVersion eWSSVersion, @Nullable ICommonsList<String> iCommonsList, @Nullable ICommonsList<String> iCommonsList2, @Nullable String string, @Nullable ECryptoAlgorithmSignDigest eCryptoAlgorithmSignDigest, @Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign, @Nullable ICommonsList<String> iCommonsList3, @Nullable ICommonsList<String> iCommonsList4, @Nullable String string2, @Nullable ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt, @Nullable Integer n, @Nullable String string3, @Nullable String string4, @Nonnull ETriState eTriState, @Nonnull ETriState eTriState2, @Nonnull ETriState eTriState3, @Nonnull ETriState eTriState4, @Nonnull ETriState eTriState5, @Nullable EPModeSendReceiptReplyPattern ePModeSendReceiptReplyPattern, @Nonnull ETriState eTriState6) {
        this.setWSSVersion(eWSSVersion);
        this.setX509SignElement(iCommonsList);
        this.setX509SignAttachment(iCommonsList2);
        this.setX509SignatureCertificate(string);
        this.setX509SignatureHashFunction(eCryptoAlgorithmSignDigest);
        this.setX509SignatureAlgorithm(eCryptoAlgorithmSign);
        this.setX509EncryptionEncryptElement(iCommonsList3);
        this.setX509EncryptionEncryptAttachment(iCommonsList4);
        this.setX509EncryptionCertificate(string2);
        this.setX509EncryptionAlgorithm(eCryptoAlgorithmCrypt);
        this.setX509EncryptionMinimumStrength(n);
        this.setUsernameTokenUsername(string3);
        this.setUsernameTokenPassword(string4);
        this.setUsernameTokenDigest(eTriState);
        this.setUsernameTokenNonce(eTriState2);
        this.setUsernameTokenCreated(eTriState3);
        this.setPModeAuthorize(eTriState4);
        this.setSendReceipt(eTriState5);
        this.setSendReceiptReplyPattern(ePModeSendReceiptReplyPattern);
        this.setSendReceiptNonRepudiation(eTriState6);
    }

    @Nullable
    public final EWSSVersion getWSSVersion() {
        return this.m_eWSSVersion;
    }

    public final boolean hasWSSVersion() {
        return this.m_eWSSVersion != null;
    }

    @Nullable
    public final String getWSSVersionAsString() {
        return this.m_eWSSVersion == null ? null : this.m_eWSSVersion.getVersion();
    }

    @Nonnull
    public final EChange setWSSVersion(@Nullable EWSSVersion eWSSVersion) {
        if (EqualsHelper.equals((Object)eWSSVersion, (Object)this.m_eWSSVersion)) {
            return EChange.UNCHANGED;
        }
        this.m_eWSSVersion = eWSSVersion;
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getX509SignElement() {
        return (ICommonsList)this.m_aX509SignElement.getClone();
    }

    @Nonnull
    public final EChange setX509SignElement(@Nullable ICommonsList<String> iCommonsList) {
        if (EqualsHelper.equals(iCommonsList, this.m_aX509SignElement)) {
            return EChange.UNCHANGED;
        }
        this.m_aX509SignElement.setAll((Iterable<String>)iCommonsList);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getX509SignAttachment() {
        return (ICommonsList)this.m_aX509SignAttachment.getClone();
    }

    @Nonnull
    public final EChange setX509SignAttachment(@Nullable ICommonsList<String> iCommonsList) {
        if (EqualsHelper.equals(iCommonsList, this.m_aX509SignAttachment)) {
            return EChange.UNCHANGED;
        }
        this.m_aX509SignAttachment.setAll((Iterable<String>)iCommonsList);
        return EChange.CHANGED;
    }

    @Nullable
    public final String getX509SignatureCertificate() {
        return this.m_sX509SignatureCertificate;
    }

    public final boolean hasX509SignatureCertificate() {
        return StringHelper.hasText(this.m_sX509SignatureCertificate);
    }

    @Nonnull
    public final EChange setX509SignatureCertificate(@Nullable String string) {
        if (EqualsHelper.equals(string, this.m_sX509SignatureCertificate)) {
            return EChange.UNCHANGED;
        }
        this.m_sX509SignatureCertificate = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final ECryptoAlgorithmSignDigest getX509SignatureHashFunction() {
        return this.m_eX509SignatureHashFunction;
    }

    public boolean hasX509SignatureHashFunction() {
        return this.m_eX509SignatureHashFunction != null;
    }

    @Nullable
    public final String getX509SignatureHashFunctionID() {
        return this.m_eX509SignatureHashFunction == null ? null : this.m_eX509SignatureHashFunction.getID();
    }

    @Nonnull
    public final EChange setX509SignatureHashFunction(@Nullable ECryptoAlgorithmSignDigest eCryptoAlgorithmSignDigest) {
        if (EqualsHelper.equals(eCryptoAlgorithmSignDigest, this.m_eX509SignatureHashFunction)) {
            return EChange.UNCHANGED;
        }
        this.m_eX509SignatureHashFunction = eCryptoAlgorithmSignDigest;
        return EChange.CHANGED;
    }

    @Nullable
    public final ECryptoAlgorithmSign getX509SignatureAlgorithm() {
        return this.m_eX509SignatureAlgorithm;
    }

    public final boolean hasX509SignatureAlgorithm() {
        return this.m_eX509SignatureAlgorithm != null;
    }

    @Nullable
    public final String getX509SignatureAlgorithmID() {
        return this.m_eX509SignatureAlgorithm == null ? null : this.m_eX509SignatureAlgorithm.getID();
    }

    @Nonnull
    public final EChange setX509SignatureAlgorithm(@Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        if (EqualsHelper.equals(eCryptoAlgorithmSign, this.m_eX509SignatureAlgorithm)) {
            return EChange.UNCHANGED;
        }
        this.m_eX509SignatureAlgorithm = eCryptoAlgorithmSign;
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getX509EncryptionEncryptElement() {
        return (ICommonsList)this.m_aX509EncryptionEncryptElement.getClone();
    }

    @Nonnull
    public final EChange setX509EncryptionEncryptElement(@Nullable ICommonsList<String> iCommonsList) {
        if (EqualsHelper.equals(iCommonsList, this.m_aX509EncryptionEncryptElement)) {
            return EChange.UNCHANGED;
        }
        this.m_aX509EncryptionEncryptElement.setAll((Iterable<String>)iCommonsList);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<String> getX509EncryptionEncryptAttachment() {
        return (ICommonsList)this.m_aX509EncryptionEncryptAttachment.getClone();
    }

    @Nonnull
    public final EChange setX509EncryptionEncryptAttachment(@Nullable ICommonsList<String> iCommonsList) {
        if (EqualsHelper.equals(iCommonsList, this.m_aX509EncryptionEncryptAttachment)) {
            return EChange.UNCHANGED;
        }
        this.m_aX509EncryptionEncryptAttachment.setAll((Iterable<String>)iCommonsList);
        return EChange.CHANGED;
    }

    @Nullable
    public final String getX509EncryptionCertificate() {
        return this.m_sX509EncryptionCertificate;
    }

    public final boolean hasX509EncryptionCertificate() {
        return StringHelper.hasText(this.m_sX509EncryptionCertificate);
    }

    @Nonnull
    public final EChange setX509EncryptionCertificate(@Nullable String string) {
        if (EqualsHelper.equals(string, this.m_sX509EncryptionCertificate)) {
            return EChange.UNCHANGED;
        }
        this.m_sX509EncryptionCertificate = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final ECryptoAlgorithmCrypt getX509EncryptionAlgorithm() {
        return this.m_eX509EncryptionAlgorithm;
    }

    public final boolean hasX509EncryptionAlgorithm() {
        return this.m_eX509EncryptionAlgorithm != null;
    }

    @Nullable
    public final String getX509EncryptionAlgorithmID() {
        return this.m_eX509EncryptionAlgorithm == null ? null : this.m_eX509EncryptionAlgorithm.getID();
    }

    @Nonnull
    public final EChange setX509EncryptionAlgorithm(@Nullable ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt) {
        if (EqualsHelper.equals(eCryptoAlgorithmCrypt, this.m_eX509EncryptionAlgorithm)) {
            return EChange.UNCHANGED;
        }
        this.m_eX509EncryptionAlgorithm = eCryptoAlgorithmCrypt;
        return EChange.CHANGED;
    }

    @Nullable
    public final Integer getX509EncryptionMinimumStrength() {
        return this.m_aX509EncryptionMinimumStrength;
    }

    public final boolean hasX509EncryptionMinimumStrength() {
        return this.m_aX509EncryptionMinimumStrength != null;
    }

    @Nonnull
    public final EChange setX509EncryptionMinimumStrength(@Nullable Integer n) {
        if (EqualsHelper.equals(n, this.m_aX509EncryptionMinimumStrength)) {
            return EChange.UNCHANGED;
        }
        this.m_aX509EncryptionMinimumStrength = n;
        return EChange.CHANGED;
    }

    @Nullable
    public final String getUsernameTokenUsername() {
        return this.m_sUsernameTokenUsername;
    }

    public final boolean hasUsernameTokenUsername() {
        return StringHelper.hasText(this.m_sUsernameTokenUsername);
    }

    @Nonnull
    public final EChange setUsernameTokenUsername(@Nullable String string) {
        if (EqualsHelper.equals(string, this.m_sUsernameTokenUsername)) {
            return EChange.UNCHANGED;
        }
        this.m_sUsernameTokenUsername = string;
        return EChange.CHANGED;
    }

    @Nullable
    public final String getUsernameTokenPassword() {
        return this.m_sUsernameTokenPassword;
    }

    public final boolean hasUsernameTokenPassword() {
        return StringHelper.hasText(this.m_sUsernameTokenPassword);
    }

    @Nonnull
    public final EChange setUsernameTokenPassword(@Nullable String string) {
        if (EqualsHelper.equals(string, this.m_sUsernameTokenPassword)) {
            return EChange.UNCHANGED;
        }
        this.m_sUsernameTokenPassword = string;
        return EChange.CHANGED;
    }

    public final boolean isUsernameTokenDigestDefined() {
        return this.m_eUsernameTokenDigest.isDefined();
    }

    public final boolean isUsernameTokenDigest() {
        return this.m_eUsernameTokenDigest.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setUsernameTokenDigest(boolean bl) {
        return this.setUsernameTokenDigest(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setUsernameTokenDigest(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "UsernameTokenDigest");
        if (eTriState.equals(this.m_eUsernameTokenDigest)) {
            return EChange.UNCHANGED;
        }
        this.m_eUsernameTokenDigest = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isUsernameTokenNonceDefined() {
        return this.m_eUsernameTokenNonce.isDefined();
    }

    public final boolean isUsernameTokenNonce() {
        return this.m_eUsernameTokenNonce.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setUsernameTokenNonce(boolean bl) {
        return this.setUsernameTokenNonce(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setUsernameTokenNonce(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "UsernameTokenNonce");
        if (eTriState.equals(this.m_eUsernameTokenNonce)) {
            return EChange.UNCHANGED;
        }
        this.m_eUsernameTokenNonce = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isUsernameTokenCreatedDefined() {
        return this.m_eUsernameTokenCreated.isDefined();
    }

    public final boolean isUsernameTokenCreated() {
        return this.m_eUsernameTokenCreated.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setUsernameTokenCreated(boolean bl) {
        return this.setUsernameTokenCreated(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setUsernameTokenCreated(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "UsernameTokenCreated");
        if (eTriState.equals(this.m_eUsernameTokenCreated)) {
            return EChange.UNCHANGED;
        }
        this.m_eUsernameTokenCreated = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isPModeAuthorizeDefined() {
        return this.m_ePModeAuthorize.isDefined();
    }

    public final boolean isPModeAuthorize() {
        return this.m_ePModeAuthorize.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setPModeAuthorize(boolean bl) {
        return this.setPModeAuthorize(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setPModeAuthorize(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "PModeAuthorize");
        if (eTriState.equals(this.m_ePModeAuthorize)) {
            return EChange.UNCHANGED;
        }
        this.m_ePModeAuthorize = eTriState;
        return EChange.CHANGED;
    }

    public final boolean isSendReceiptDefined() {
        return this.m_eSendReceipt.isDefined();
    }

    public final boolean isSendReceipt() {
        return this.m_eSendReceipt.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setSendReceipt(boolean bl) {
        return this.setSendReceipt(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setSendReceipt(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "SendReceipt");
        if (eTriState.equals(this.m_eSendReceipt)) {
            return EChange.UNCHANGED;
        }
        this.m_eSendReceipt = eTriState;
        return EChange.CHANGED;
    }

    @Nullable
    public final EPModeSendReceiptReplyPattern getSendReceiptReplyPattern() {
        return this.m_eSendReceiptReplyPattern;
    }

    public final String getSendReceiptReplyPatternID() {
        return this.m_eSendReceiptReplyPattern == null ? null : this.m_eSendReceiptReplyPattern.getID();
    }

    @Nonnull
    public final EChange setSendReceiptReplyPattern(@Nullable EPModeSendReceiptReplyPattern ePModeSendReceiptReplyPattern) {
        if (EqualsHelper.equals(ePModeSendReceiptReplyPattern, this.m_eSendReceiptReplyPattern)) {
            return EChange.UNCHANGED;
        }
        this.m_eSendReceiptReplyPattern = ePModeSendReceiptReplyPattern;
        return EChange.CHANGED;
    }

    public final boolean isSendReceiptNonRepudiationDefined() {
        return this.m_eSendReceiptNonRepudiation.isDefined();
    }

    public final boolean isSendReceiptNonRepudiation() {
        return this.m_eSendReceiptNonRepudiation.getAsBooleanValue(false);
    }

    @Nonnull
    public final EChange setSendReceiptNonRepudiation(boolean bl) {
        return this.setSendReceiptNonRepudiation(ETriState.valueOf(bl));
    }

    @Nonnull
    public final EChange setSendReceiptNonRepudiation(@Nonnull ETriState eTriState) {
        ValueEnforcer.notNull(eTriState, "SendReceiptNonRepudiation");
        if (eTriState.equals(this.m_eSendReceiptNonRepudiation)) {
            return EChange.UNCHANGED;
        }
        this.m_eSendReceiptNonRepudiation = eTriState;
        return EChange.CHANGED;
    }

    public final void disableSigning() {
        this.setX509SignElement(null);
        this.setX509SignAttachment(null);
        this.setX509SignatureCertificate(null);
        this.setX509SignatureHashFunction(null);
        this.setX509SignatureAlgorithm(null);
    }

    public final void disableEncryption() {
        this.setX509EncryptionEncryptElement(null);
        this.setX509EncryptionEncryptAttachment(null);
        this.setX509EncryptionCertificate(null);
        this.setX509EncryptionAlgorithm(null);
        this.setX509EncryptionMinimumStrength(null);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeLegSecurity pModeLegSecurity = (PModeLegSecurity)object;
        return EqualsHelper.equals((Object)this.m_eWSSVersion, (Object)pModeLegSecurity.m_eWSSVersion) && EqualsHelper.equals(this.m_aX509SignElement, pModeLegSecurity.m_aX509SignElement) && EqualsHelper.equals(this.m_aX509SignAttachment, pModeLegSecurity.m_aX509SignAttachment) && EqualsHelper.equals(this.m_sX509SignatureCertificate, pModeLegSecurity.m_sX509SignatureCertificate) && EqualsHelper.equals(this.m_eX509SignatureHashFunction, pModeLegSecurity.m_eX509SignatureHashFunction) && EqualsHelper.equals(this.m_eX509SignatureAlgorithm, pModeLegSecurity.m_eX509SignatureAlgorithm) && EqualsHelper.equals(this.m_aX509EncryptionEncryptElement, pModeLegSecurity.m_aX509EncryptionEncryptElement) && EqualsHelper.equals(this.m_aX509EncryptionEncryptAttachment, pModeLegSecurity.m_aX509EncryptionEncryptAttachment) && EqualsHelper.equals(this.m_sX509EncryptionCertificate, pModeLegSecurity.m_sX509EncryptionCertificate) && EqualsHelper.equals(this.m_eX509EncryptionAlgorithm, pModeLegSecurity.m_eX509EncryptionAlgorithm) && EqualsHelper.equals(this.m_aX509EncryptionMinimumStrength, pModeLegSecurity.m_aX509EncryptionMinimumStrength) && EqualsHelper.equals(this.m_sUsernameTokenUsername, pModeLegSecurity.m_sUsernameTokenUsername) && EqualsHelper.equals(this.m_sUsernameTokenPassword, pModeLegSecurity.m_sUsernameTokenPassword) && EqualsHelper.equals(this.m_eUsernameTokenDigest, pModeLegSecurity.m_eUsernameTokenDigest) && EqualsHelper.equals(this.m_eUsernameTokenNonce, pModeLegSecurity.m_eUsernameTokenNonce) && EqualsHelper.equals(this.m_eUsernameTokenCreated, pModeLegSecurity.m_eUsernameTokenCreated) && EqualsHelper.equals(this.m_ePModeAuthorize, pModeLegSecurity.m_ePModeAuthorize) && EqualsHelper.equals(this.m_eSendReceipt, pModeLegSecurity.m_eSendReceipt) && EqualsHelper.equals(this.m_eSendReceiptReplyPattern, pModeLegSecurity.m_eSendReceiptReplyPattern) && EqualsHelper.equals(this.m_eSendReceiptNonRepudiation, pModeLegSecurity.m_eSendReceiptNonRepudiation);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eWSSVersion)).append(this.m_aX509SignElement)).append(this.m_aX509SignAttachment)).append(this.m_sX509SignatureCertificate).append((Enum)this.m_eX509SignatureHashFunction)).append((Enum)this.m_eX509SignatureAlgorithm)).append(this.m_aX509EncryptionEncryptElement)).append(this.m_aX509EncryptionEncryptAttachment)).append(this.m_sX509EncryptionCertificate).append((Enum)this.m_eX509EncryptionAlgorithm)).append(this.m_aX509EncryptionMinimumStrength).append(this.m_sUsernameTokenUsername).append(this.m_sUsernameTokenPassword).append((Enum)this.m_eUsernameTokenDigest)).append((Enum)this.m_eUsernameTokenNonce)).append((Enum)this.m_eUsernameTokenCreated)).append((Enum)this.m_ePModeAuthorize)).append((Enum)this.m_eSendReceipt)).append((Enum)this.m_eSendReceiptReplyPattern)).append((Enum)this.m_eSendReceiptNonRepudiation)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("WSSVersion", this.m_eWSSVersion).append("X509SignElement", this.m_aX509SignElement).append("X509SignAttachment", this.m_aX509SignAttachment).append("X509SignatureCertificate", this.m_sX509SignatureCertificate).append("X509SignatureHashFunction", this.m_eX509SignatureHashFunction).append("X509SignatureAlgorithm", this.m_eX509SignatureAlgorithm).append("X509EncryptionEncryptElement", this.m_aX509EncryptionEncryptElement).append("X509EncryptionEncryptAttachment", this.m_aX509EncryptionEncryptAttachment).append("X509EncryptionCertificate", this.m_sX509EncryptionCertificate).append("X509EncryptionAlgorithm", this.m_eX509EncryptionAlgorithm).append("X509EncryptionMinimumStrength", this.m_aX509EncryptionMinimumStrength).append("UsernameTokenUsername", this.m_sUsernameTokenUsername).append("UsernameTokenPassword", this.m_sUsernameTokenPassword).append("UsernameTokenDigest", this.m_eUsernameTokenDigest).append("UsernameTokenNonce", this.m_eUsernameTokenNonce).append("UsernameTokenCreated", this.m_eUsernameTokenCreated).append("PModeAuthorize", this.m_ePModeAuthorize).append("SendReceipt", this.m_eSendReceipt).append("SendReceiptReplyPattern", this.m_eSendReceiptReplyPattern).append("SendReceiptNonRepudiation", this.m_eSendReceiptNonRepudiation).getToString();
    }
}

