/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.model.pmode.AbstractPModeMicroTypeConverter;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import com.helger.phase4.wss.EWSSVersion;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.util.MicroHelper;

public class PModeLegSecurityMicroTypeConverter
extends AbstractPModeMicroTypeConverter<PModeLegSecurity> {
    private static final IMicroQName ATTR_WSS_VERSION = new MicroQName("WSSVersion");
    private static final String ELEMENT_X509_SIGN_ELEMENT = "X509SignElement";
    private static final String ELEMENT_X509_SIGN_ATTACHMENT = "X509SignAttachment";
    private static final String ELEMENT_X509_SIGNATURE_CERTIFICATE = "X509SignatureCertificate";
    private static final IMicroQName ATTR_X509_SIGNATURE_HASH_FUNCTION = new MicroQName("X509SignatureHashFunction");
    private static final IMicroQName ATTR_X509_SIGNATURE_ALGORITHM = new MicroQName("X509SignatureAlgorithm");
    private static final String ELEMENT_X509_ENCRYPTION_ENCRYPT_ELEMENT = "X509EncryptionEncryptElement";
    private static final String ELEMENT_X509_ENCRYPTION_ENCRYPT_ATTACHMENT = "X509EncryptionEncryptAttachment";
    private static final String ELEMENT_X509_ENCRYPTION_CERTIFICATE = "X509EncryptionCertificate";
    private static final IMicroQName ATTR_X509_ENCRYPTION_ALGORITHM = new MicroQName("X509EncryptionAlgorithm");
    private static final IMicroQName ATTR_X509_ENCRYPTION_MINIMUM_STRENGTH = new MicroQName("X509EncryptionMinimumStrength");
    private static final IMicroQName ATTR_USERNAME_TOKEN_USERNAME = new MicroQName("UsernameTokenUsername");
    private static final IMicroQName ATTR_USERNAME_TOKEN_PASSWORD = new MicroQName("UsernameTokenPassword");
    private static final IMicroQName ATTR_USERNAME_TOKEN_DIGEST = new MicroQName("UsernameTokenDigest");
    private static final IMicroQName ATTR_USERNAME_TOKEN_NONCE = new MicroQName("UsernameTokenNonce");
    private static final IMicroQName ATTR_USERNAME_TOKEN_CREATED = new MicroQName("UsernameTokenCreated");
    private static final IMicroQName ATTR_PMODE_AUTHORIZE = new MicroQName("PModeAuthorize");
    private static final IMicroQName ATTR_SEND_RECEIPT = new MicroQName("SendReceipt");
    private static final IMicroQName ATTR_SEND_RECEIPT_REPLY_PATTERN = new MicroQName("SendReceiptReplyPattern");
    private static final IMicroQName ATTR_SEND_RECEIPT_NON_REPUDIATION = new MicroQName("SendReceiptNonRepudiation");

    @Override
    public IMicroElement convertToMicroElement(PModeLegSecurity pModeLegSecurity, String string, String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_WSS_VERSION, pModeLegSecurity.getWSSVersionAsString());
        for (String string3 : pModeLegSecurity.getX509SignElement()) {
            microElement.appendElement(string, ELEMENT_X509_SIGN_ELEMENT).appendText(string3);
        }
        for (String string3 : pModeLegSecurity.getX509SignAttachment()) {
            microElement.appendElement(string, ELEMENT_X509_SIGN_ATTACHMENT).appendText(string3);
        }
        if (StringHelper.hasText(pModeLegSecurity.getX509SignatureCertificate())) {
            microElement.appendElement(string, ELEMENT_X509_SIGNATURE_CERTIFICATE).appendText(pModeLegSecurity.getX509SignatureCertificate());
        }
        microElement.setAttribute(ATTR_X509_SIGNATURE_HASH_FUNCTION, pModeLegSecurity.getX509SignatureHashFunctionID());
        microElement.setAttribute(ATTR_X509_SIGNATURE_ALGORITHM, pModeLegSecurity.getX509SignatureAlgorithmID());
        for (String string3 : pModeLegSecurity.getX509EncryptionEncryptElement()) {
            microElement.appendElement(string, ELEMENT_X509_ENCRYPTION_ENCRYPT_ELEMENT).appendText(string3);
        }
        for (String string3 : pModeLegSecurity.getX509EncryptionEncryptAttachment()) {
            microElement.appendElement(string, ELEMENT_X509_ENCRYPTION_ENCRYPT_ATTACHMENT).appendText(string3);
        }
        if (StringHelper.hasText(pModeLegSecurity.getX509EncryptionCertificate())) {
            microElement.appendElement(string, ELEMENT_X509_ENCRYPTION_CERTIFICATE).appendText(pModeLegSecurity.getX509EncryptionCertificate());
        }
        microElement.setAttribute(ATTR_X509_ENCRYPTION_ALGORITHM, pModeLegSecurity.getX509EncryptionAlgorithmID());
        if (pModeLegSecurity.hasX509EncryptionMinimumStrength()) {
            microElement.setAttribute(ATTR_X509_ENCRYPTION_MINIMUM_STRENGTH, (int)pModeLegSecurity.getX509EncryptionMinimumStrength());
        }
        microElement.setAttribute(ATTR_USERNAME_TOKEN_USERNAME, pModeLegSecurity.getUsernameTokenUsername());
        microElement.setAttribute(ATTR_USERNAME_TOKEN_PASSWORD, pModeLegSecurity.getUsernameTokenPassword());
        if (pModeLegSecurity.isUsernameTokenDigestDefined()) {
            microElement.setAttribute(ATTR_USERNAME_TOKEN_DIGEST, pModeLegSecurity.isUsernameTokenDigest());
        }
        if (pModeLegSecurity.isUsernameTokenNonceDefined()) {
            microElement.setAttribute(ATTR_USERNAME_TOKEN_NONCE, pModeLegSecurity.isUsernameTokenNonce());
        }
        if (pModeLegSecurity.isUsernameTokenCreatedDefined()) {
            microElement.setAttribute(ATTR_USERNAME_TOKEN_CREATED, pModeLegSecurity.isUsernameTokenCreated());
        }
        if (pModeLegSecurity.isPModeAuthorizeDefined()) {
            microElement.setAttribute(ATTR_PMODE_AUTHORIZE, pModeLegSecurity.isPModeAuthorize());
        }
        if (pModeLegSecurity.isSendReceiptDefined()) {
            microElement.setAttribute(ATTR_SEND_RECEIPT, pModeLegSecurity.isSendReceipt());
        }
        microElement.setAttribute(ATTR_SEND_RECEIPT_REPLY_PATTERN, pModeLegSecurity.getSendReceiptReplyPatternID());
        if (pModeLegSecurity.isSendReceiptNonRepudiationDefined()) {
            microElement.setAttribute(ATTR_SEND_RECEIPT_NON_REPUDIATION, pModeLegSecurity.isSendReceiptNonRepudiation());
        }
        return microElement;
    }

    @Override
    public PModeLegSecurity convertToNative(IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_WSS_VERSION);
        EWSSVersion eWSSVersion = EWSSVersion.getFromVersionOrNull(string);
        if (eWSSVersion == null && string != null) {
            throw new IllegalStateException("Invalid WSS version '" + string + "'");
        }
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        for (IMicroElement object42 : iMicroElement.getAllChildElements(ELEMENT_X509_SIGN_ELEMENT)) {
            commonsArrayList.add(object42.getTextContentTrimmed());
        }
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_X509_SIGN_ATTACHMENT)) {
            commonsArrayList2.add(iMicroElement2.getTextContentTrimmed());
        }
        String string2 = MicroHelper.getChildTextContentTrimmed(iMicroElement, ELEMENT_X509_SIGNATURE_CERTIFICATE);
        String string3 = iMicroElement.getAttributeValue(ATTR_X509_SIGNATURE_HASH_FUNCTION);
        ECryptoAlgorithmSignDigest eCryptoAlgorithmSignDigest = ECryptoAlgorithmSignDigest.getFromIDOrNull(string3);
        if (eCryptoAlgorithmSignDigest == null && string3 != null) {
            throw new IllegalStateException("Invalid signature hash function '" + string3 + "'");
        }
        String string4 = iMicroElement.getAttributeValue(ATTR_X509_SIGNATURE_ALGORITHM);
        ECryptoAlgorithmSign eCryptoAlgorithmSign = ECryptoAlgorithmSign.getFromIDOrNull(string4);
        if (eCryptoAlgorithmSign == null && string4 != null) {
            throw new IllegalStateException("Invalid signature algorithm '" + string4 + "'");
        }
        CommonsArrayList<String> commonsArrayList3 = new CommonsArrayList<String>();
        for (IMicroElement iMicroElement3 : iMicroElement.getAllChildElements(ELEMENT_X509_ENCRYPTION_ENCRYPT_ELEMENT)) {
            commonsArrayList3.add(iMicroElement3.getTextContentTrimmed());
        }
        CommonsArrayList commonsArrayList4 = new CommonsArrayList();
        for (IMicroElement iMicroElement4 : iMicroElement.getAllChildElements(ELEMENT_X509_ENCRYPTION_ENCRYPT_ATTACHMENT)) {
            commonsArrayList4.add(iMicroElement4.getTextContentTrimmed());
        }
        String string5 = MicroHelper.getChildTextContentTrimmed(iMicroElement, ELEMENT_X509_ENCRYPTION_CERTIFICATE);
        String string6 = iMicroElement.getAttributeValue(ATTR_X509_ENCRYPTION_ALGORITHM);
        ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt = ECryptoAlgorithmCrypt.getFromIDOrNull(string6);
        if (eCryptoAlgorithmCrypt == null && string6 != null) {
            throw new IllegalStateException("Invalid encrypt algorithm '" + string6 + "'");
        }
        Integer n = iMicroElement.getAttributeValueWithConversion(ATTR_X509_ENCRYPTION_MINIMUM_STRENGTH, Integer.class);
        String string7 = iMicroElement.getAttributeValue(ATTR_USERNAME_TOKEN_USERNAME);
        String string8 = iMicroElement.getAttributeValue(ATTR_USERNAME_TOKEN_PASSWORD);
        ETriState eTriState = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_USERNAME_TOKEN_DIGEST), false);
        ETriState eTriState2 = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_USERNAME_TOKEN_NONCE), false);
        ETriState eTriState3 = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_USERNAME_TOKEN_CREATED), false);
        ETriState eTriState4 = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_PMODE_AUTHORIZE), false);
        ETriState eTriState5 = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_SEND_RECEIPT), false);
        String string9 = iMicroElement.getAttributeValue(ATTR_SEND_RECEIPT_REPLY_PATTERN);
        EPModeSendReceiptReplyPattern ePModeSendReceiptReplyPattern = EPModeSendReceiptReplyPattern.getFromIDOrNull(string9);
        if (ePModeSendReceiptReplyPattern == null && string9 != null) {
            throw new IllegalStateException("Invalid SendReceipt ReplyPattern version '" + string9 + "'");
        }
        ETriState eTriState6 = PModeLegSecurityMicroTypeConverter.getTriState(iMicroElement.getAttributeValue(ATTR_SEND_RECEIPT_NON_REPUDIATION), false);
        return new PModeLegSecurity(eWSSVersion, commonsArrayList, commonsArrayList2, string2, eCryptoAlgorithmSignDigest, eCryptoAlgorithmSign, commonsArrayList3, commonsArrayList4, string5, eCryptoAlgorithmCrypt, n, string7, string8, eTriState, eTriState2, eTriState3, eTriState4, eTriState5, ePModeSendReceiptReplyPattern, eTriState6);
    }
}

