/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.name.IHasName;
import com.helger.commons.state.EMandatory;
import com.helger.commons.state.IMandatoryIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class PModePayloadProfile
implements IHasName,
IMandatoryIndicator,
Serializable {
    public static final boolean DEFAULT_MANDATORY = false;
    private final String m_sName;
    private final IMimeType m_aMimeType;
    private final String m_sXSDFilename;
    private final Integer m_aMaxSizeKB;
    private final EMandatory m_eMandatory;

    public PModePayloadProfile(@Nonnull @Nonempty String string, @Nonnull IMimeType iMimeType, @Nullable String string2, @Nullable Integer n, @Nonnull EMandatory eMandatory) {
        this.m_sName = ValueEnforcer.notEmpty(string, "Name");
        this.m_aMimeType = ValueEnforcer.notNull(iMimeType, "MimeType");
        this.m_sXSDFilename = string2;
        this.m_aMaxSizeKB = n;
        this.m_eMandatory = ValueEnforcer.notNull(eMandatory, "Mandatory");
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    @Nonnull
    public final IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nullable
    public final String getXSDFilename() {
        return this.m_sXSDFilename;
    }

    public final boolean hasXSDFilename() {
        return StringHelper.hasText(this.m_sXSDFilename);
    }

    @Nullable
    public final Integer getMaxSizeKB() {
        return this.m_aMaxSizeKB;
    }

    public final boolean hasMaxSizeKB() {
        return this.m_aMaxSizeKB != null;
    }

    @Override
    public final boolean isMandatory() {
        return this.m_eMandatory.isMandatory();
    }

    @Override
    public final boolean isOptional() {
        return this.m_eMandatory.isOptional();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModePayloadProfile pModePayloadProfile = (PModePayloadProfile)object;
        return this.m_sName.equals(pModePayloadProfile.m_sName) && this.m_aMimeType.equals(pModePayloadProfile.m_aMimeType) && EqualsHelper.equals(this.m_sXSDFilename, pModePayloadProfile.m_sXSDFilename) && EqualsHelper.equals(this.m_aMaxSizeKB, pModePayloadProfile.m_aMaxSizeKB) && this.m_eMandatory.equals(pModePayloadProfile.m_eMandatory);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sName).append(this.m_aMimeType).append(this.m_sXSDFilename).append(this.m_aMaxSizeKB).append((Enum)this.m_eMandatory)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Name", this.m_sName).append("MimeType", this.m_aMimeType).append("XSDFilename", this.m_sXSDFilename).append("MaxSizeKB", this.m_aMaxSizeKB).append("Mandatory", this.m_eMandatory).getToString();
    }
}

