/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.pmode.leg;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.name.IHasName;
import com.helger.commons.state.EMandatory;
import com.helger.commons.state.IMandatoryIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.IHasDescription;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@MustImplementEqualsAndHashcode
public class PModeProperty
implements IHasName,
IHasDescription,
IMandatoryIndicator,
Serializable {
    public static final String DATA_TYPE_STRING = "string";
    public static final boolean DEFAULT_MANDATORY = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(PModeProperty.class);
    private final String m_sName;
    private final String m_sDescription;
    private final String m_sDataType;
    private final EMandatory m_eMandatory;

    private static void _checkDataType(@Nonnull String string) {
        if (!DATA_TYPE_STRING.equals(string) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("A non-standard data type (everything besides 'string') is used: " + string);
        }
    }

    public PModeProperty(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull @Nonempty String string3, @Nonnull EMandatory eMandatory) {
        this.m_sName = ValueEnforcer.notEmpty(string, "Name");
        this.m_sDescription = string2;
        this.m_sDataType = ValueEnforcer.notEmpty(string3, "DataType");
        this.m_eMandatory = ValueEnforcer.notNull(eMandatory, "Mandatory");
        PModeProperty._checkDataType(string3);
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sName;
    }

    @Override
    @Nullable
    public final String getDescription() {
        return this.m_sDescription;
    }

    @Nonnull
    @Nonempty
    public final String getDataType() {
        return this.m_sDataType;
    }

    @Override
    public final boolean isMandatory() {
        return this.m_eMandatory.isMandatory();
    }

    @Override
    public final boolean isOptional() {
        return this.m_eMandatory.isOptional();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PModeProperty pModeProperty = (PModeProperty)object;
        return this.m_sName.equals(pModeProperty.m_sName) && EqualsHelper.equals(this.m_sDescription, pModeProperty.m_sDescription) && this.m_sDataType.equals(pModeProperty.m_sDataType) && this.m_eMandatory.equals(pModeProperty.m_eMandatory);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sName).append(this.m_sDescription).append(this.m_sDataType).append((Enum)this.m_eMandatory)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Name", this.m_sName).append("Description", this.m_sDescription).append("DataType", this.m_sDataType).append("Mandatory", this.m_eMandatory).getToString();
    }
}

