/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.profile;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.model.pmode.IPModeIDProvider;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.profile.IAS4Profile;
import com.helger.phase4.profile.IAS4ProfilePModeProvider;
import com.helger.phase4.profile.IAS4ProfileValidator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AS4Profile
implements IAS4Profile {
    private final String m_sID;
    private final String m_sDisplayName;
    private final ISupplier<? extends IAS4ProfileValidator> m_aProfileValidatorProvider;
    private final IAS4ProfilePModeProvider m_aDefaultPModeProvider;
    private final IPModeIDProvider m_aPModeIDProvider;
    private final boolean m_bDeprecated;

    public AS4Profile(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ISupplier<? extends IAS4ProfileValidator> iSupplier, @Nonnull IAS4ProfilePModeProvider iAS4ProfilePModeProvider, @Nonnull IPModeIDProvider iPModeIDProvider, boolean bl) {
        this.m_sID = ValueEnforcer.notEmpty(string, "ID");
        this.m_sDisplayName = ValueEnforcer.notEmpty(string2, "DisplayName");
        this.m_aProfileValidatorProvider = ValueEnforcer.notNull(iSupplier, "ProfileValidatorProvider");
        this.m_aDefaultPModeProvider = ValueEnforcer.notNull(iAS4ProfilePModeProvider, "aDefaultPModeProvider");
        this.m_aPModeIDProvider = ValueEnforcer.notNull(iPModeIDProvider, "PModeIDProvider");
        this.m_bDeprecated = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Override
    @Nullable
    public IAS4ProfileValidator getValidator() {
        return (IAS4ProfileValidator)this.m_aProfileValidatorProvider.get();
    }

    @Override
    @Nonnull
    public PMode createPModeTemplate(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3) {
        return this.m_aDefaultPModeProvider.getOrCreatePMode(string, string2, string3);
    }

    @Override
    @Nonnull
    public IPModeIDProvider getPModeIDProvider() {
        return this.m_aPModeIDProvider;
    }

    @Override
    public boolean isDeprecated() {
        return this.m_bDeprecated;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AS4Profile aS4Profile = (AS4Profile)object;
        return this.m_sID.equals(aS4Profile.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).append("DisplayName", this.m_sDisplayName).append("ProfileValidatorProvider", this.m_aProfileValidatorProvider).append("DefaultPModeProvider", this.m_aDefaultPModeProvider).append("PModeIDProvider", this.m_aPModeIDProvider).append("Deprecated", this.m_bDeprecated).getToString();
    }
}

