/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.profile.cef;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.ebms3header.Ebms3From;
import com.helger.phase4.ebms3header.Ebms3MessageProperties;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3To;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.EMEP;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.PModePayloadService;
import com.helger.phase4.model.pmode.PModeValidationException;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.leg.PModeLegErrorHandling;
import com.helger.phase4.model.pmode.leg.PModeLegProtocol;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import com.helger.phase4.profile.IAS4ProfileValidator;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.wss.EWSSVersion;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CEFCompatibilityValidator
implements IAS4ProfileValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CEFCompatibilityValidator.class);

    @Nonnull
    private static IError _createError(@Nonnull String string) {
        return ((SingleError.SingleErrorBuilder)SingleError.builderError().setErrorText(string)).build();
    }

    private void _checkIfLegIsValid(@Nonnull IPMode iPMode, @Nonnull ErrorList errorList, @Nonnull PModeLeg pModeLeg) {
        EAS4CompressionMode eAS4CompressionMode;
        PModePayloadService pModePayloadService;
        Object object;
        Object object2;
        PModeLegProtocol pModeLegProtocol = pModeLeg.getProtocol();
        if (pModeLegProtocol == null) {
            errorList.add(CEFCompatibilityValidator._createError("PMode Leg 1 is missing Protocol"));
        } else {
            object2 = pModeLegProtocol.getAddressProtocol();
            if (!(object2 == null || ((String)object2).equalsIgnoreCase("https") || ((String)object2).equalsIgnoreCase("http") && GlobalDebug.isDebugMode())) {
                errorList.add(CEFCompatibilityValidator._createError("PMode Leg1 uses a non-standard AddressProtocol: " + (String)object2));
            }
            if (!((ESoapVersion)((Object)(object = pModeLegProtocol.getSoapVersion()))).isAS4Default()) {
                errorList.add(CEFCompatibilityValidator._createError("PMode Leg1 uses a non-standard SOAP version: " + ((ESoapVersion)((Object)object)).getVersion()));
            }
        }
        object2 = pModeLeg.getSecurity();
        if (object2 != null) {
            if (((PModeLegSecurity)object2).getX509SignatureAlgorithm() == null) {
                errorList.add(CEFCompatibilityValidator._createError("No signature algorithm is specified but is required"));
            } else if (!((PModeLegSecurity)object2).getX509SignatureAlgorithm().equals(ECryptoAlgorithmSign.RSA_SHA_256)) {
                errorList.add(CEFCompatibilityValidator._createError("AS4 Profile only allows " + ECryptoAlgorithmSign.RSA_SHA_256.getID() + " as signing algorithm"));
            }
            if (((PModeLegSecurity)object2).getX509SignatureHashFunction() == null) {
                errorList.add(CEFCompatibilityValidator._createError("No hash function (Digest Algorithm) is specified but is required"));
            } else if (!((PModeLegSecurity)object2).getX509SignatureHashFunction().equals(ECryptoAlgorithmSignDigest.DIGEST_SHA_256)) {
                errorList.add(CEFCompatibilityValidator._createError("AS4 Profile only allows " + ECryptoAlgorithmSignDigest.DIGEST_SHA_256.getID() + " as hash function"));
            }
            if (((PModeLegSecurity)object2).getX509EncryptionAlgorithm() == null) {
                errorList.add(CEFCompatibilityValidator._createError("No encryption algorithm is specified but is required"));
            } else if (!((PModeLegSecurity)object2).getX509EncryptionAlgorithm().equals(ECryptoAlgorithmCrypt.AES_128_GCM)) {
                errorList.add(CEFCompatibilityValidator._createError("AS4 Profile only allows " + ECryptoAlgorithmCrypt.AES_128_GCM.getID() + " as encryption algorithm"));
            }
            if (((PModeLegSecurity)object2).getWSSVersion() != null && !((PModeLegSecurity)object2).getWSSVersion().equals((Object)EWSSVersion.WSS_111)) {
                errorList.add(CEFCompatibilityValidator._createError("Wrong WSS Version " + (Object)((Object)((PModeLegSecurity)object2).getWSSVersion()) + " only " + (Object)((Object)EWSSVersion.WSS_111) + " is allowed."));
            }
            if (((PModeLegSecurity)object2).isPModeAuthorizeDefined()) {
                if (((PModeLegSecurity)object2).isPModeAuthorize()) {
                    errorList.add(CEFCompatibilityValidator._createError("PMode Authorize has to be set to false"));
                }
            } else {
                errorList.add(CEFCompatibilityValidator._createError("PMode Authorize is a mandatory parameter"));
            }
            if (((PModeLegSecurity)object2).isSendReceiptDefined() && ((PModeLegSecurity)object2).isSendReceipt() && ((PModeLegSecurity)object2).getSendReceiptReplyPattern() != EPModeSendReceiptReplyPattern.RESPONSE) {
                errorList.add(CEFCompatibilityValidator._createError("Only response is allowed as pattern"));
            }
        }
        if ((object = pModeLeg.getErrorHandling()) != null) {
            if (((PModeLegErrorHandling)object).isReportAsResponseDefined()) {
                if (!((PModeLegErrorHandling)object).isReportAsResponse()) {
                    errorList.add(CEFCompatibilityValidator._createError("PMode ReportAsResponse has to be True"));
                }
            } else {
                errorList.add(CEFCompatibilityValidator._createError("ReportAsResponse is a mandatory PMode parameter"));
            }
            if (((PModeLegErrorHandling)object).isReportProcessErrorNotifyConsumerDefined()) {
                if (!((PModeLegErrorHandling)object).isReportProcessErrorNotifyConsumer()) {
                    errorList.add(CEFCompatibilityValidator._createError("PMode ReportProcessErrorNotifyConsumer has to be True"));
                }
            } else {
                errorList.add(CEFCompatibilityValidator._createError("ReportProcessErrorNotifyConsumer is a mandatory PMode parameter"));
            }
            if (((PModeLegErrorHandling)object).isReportDeliveryFailuresNotifyProducerDefined()) {
                if (!((PModeLegErrorHandling)object).isReportDeliveryFailuresNotifyProducer()) {
                    errorList.add(CEFCompatibilityValidator._createError("PMode ReportDeliveryFailuresNotifyProducer has to be True"));
                }
            } else {
                errorList.add(CEFCompatibilityValidator._createError("ReportDeliveryFailuresNotifyProducer is a mandatory PMode parameter"));
            }
        } else {
            errorList.add(CEFCompatibilityValidator._createError("No ErrorHandling Parameter present but they are mandatory"));
        }
        if ((pModePayloadService = iPMode.getPayloadService()) != null && (eAS4CompressionMode = pModePayloadService.getCompressionMode()) != null && !eAS4CompressionMode.equals(EAS4CompressionMode.GZIP)) {
            errorList.add(CEFCompatibilityValidator._createError("Only GZIP Compression is allowed"));
        }
    }

    @Override
    public void validatePMode(@Nonnull IPMode iPMode, @Nonnull ErrorList errorList) {
        PModeLeg pModeLeg;
        assert (errorList.isEmpty()) : "Errors in global PMode validation: " + errorList.toString();
        try {
            MetaAS4Manager.getPModeMgr().validatePMode(iPMode);
        }
        catch (PModeValidationException pModeValidationException) {
            errorList.add(CEFCompatibilityValidator._createError(pModeValidationException.getMessage()));
        }
        EMEP eMEP = iPMode.getMEP();
        EMEPBinding eMEPBinding = iPMode.getMEPBinding();
        if (!(eMEP == EMEP.ONE_WAY && eMEPBinding == EMEPBinding.PUSH || eMEP == EMEP.TWO_WAY && eMEPBinding == EMEPBinding.PUSH_PUSH)) {
            errorList.add(CEFCompatibilityValidator._createError("An invalid combination of PMode MEP (" + eMEP + ") and MEP binding (" + eMEPBinding + ") was specified, valid are only one-way/push and two-way/push-push."));
        }
        if ((pModeLeg = iPMode.getLeg1()) == null) {
            errorList.add(CEFCompatibilityValidator._createError("PMode is missing Leg 1"));
        } else {
            this._checkIfLegIsValid(iPMode, errorList, pModeLeg);
            if (eMEP.isTwoWay()) {
                PModeLeg pModeLeg2 = iPMode.getLeg2();
                if (pModeLeg2 == null) {
                    errorList.add(CEFCompatibilityValidator._createError("PMode is missing Leg 2 and is specified as TWO-WAY"));
                } else {
                    this._checkIfLegIsValid(iPMode, errorList, pModeLeg2);
                }
            }
        }
    }

    @Override
    public void validateUserMessage(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull ErrorList errorList) {
        List<Ebms3Property> list;
        IExplicitlyCloneable iExplicitlyCloneable;
        ValueEnforcer.notNull(ebms3UserMessage, "UserMsg");
        if (ebms3UserMessage.getMessageInfo() != null) {
            if (StringHelper.hasNoText(ebms3UserMessage.getMessageInfo().getMessageId())) {
                errorList.add(CEFCompatibilityValidator._createError("MessageID is missing but is mandatory!"));
            }
            if ((iExplicitlyCloneable = ebms3UserMessage.getMessageProperties()) == null) {
                errorList.add(CEFCompatibilityValidator._createError("No Message Properties present but originalSender and finalRecipient have to be present"));
            } else {
                list = ((Ebms3MessageProperties)iExplicitlyCloneable).getProperty();
                if (list.isEmpty()) {
                    errorList.add(CEFCompatibilityValidator._createError("Message Property element present but no properties"));
                } else {
                    String string = null;
                    String string2 = null;
                    for (Ebms3Property ebms3Property : list) {
                        if (ebms3Property.getName().equals("originalSender")) {
                            string = ebms3Property.getValue();
                            continue;
                        }
                        if (!ebms3Property.getName().equals("finalRecipient")) continue;
                        string2 = ebms3Property.getValue();
                    }
                    if (StringHelper.hasNoText(string)) {
                        errorList.add(CEFCompatibilityValidator._createError("'originalSender' property is empty or not existant but mandatory"));
                    }
                    if (StringHelper.hasNoText(string2)) {
                        errorList.add(CEFCompatibilityValidator._createError("'finalRecipient' property is empty or not existant but mandatory"));
                    }
                }
            }
        } else {
            errorList.add(CEFCompatibilityValidator._createError("MessageInfo is missing but is mandatory!"));
        }
        if (ebms3UserMessage.getPartyInfo() == null) {
            errorList.add(CEFCompatibilityValidator._createError("At least one PartyInfo element has to be present"));
        } else {
            iExplicitlyCloneable = ebms3UserMessage.getPartyInfo().getTo();
            if (iExplicitlyCloneable != null && ((Ebms3To)iExplicitlyCloneable).getPartyIdCount() > 1) {
                errorList.add(CEFCompatibilityValidator._createError("Only 1 PartyID is allowed in PartyInfo/To - part"));
            }
            if ((list = ebms3UserMessage.getPartyInfo().getFrom()) != null && ((Ebms3From)((Object)list)).getPartyIdCount() > 1) {
                errorList.add(CEFCompatibilityValidator._createError("Only 1 PartyID is allowed in PartyInfo/From - part"));
            }
        }
    }

    @Override
    public void validateSignalMessage(@Nonnull Ebms3SignalMessage ebms3SignalMessage, @Nonnull ErrorList errorList) {
        ValueEnforcer.notNull(ebms3SignalMessage, "SignalMsg");
        if (ebms3SignalMessage.getMessageInfo() != null && StringHelper.hasNoText(ebms3SignalMessage.getMessageInfo().getMessageId())) {
            errorList.add(CEFCompatibilityValidator._createError("MessageID is missing but is mandatory!"));
        }
    }
}

