/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.profile.cef;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.state.ETriState;
import com.helger.phase4.crypto.ECryptoAlgorithmCrypt;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.EMEP;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.pmode.IPModeIDProvider;
import com.helger.phase4.model.pmode.PMode;
import com.helger.phase4.model.pmode.PModeParty;
import com.helger.phase4.model.pmode.PModePayloadService;
import com.helger.phase4.model.pmode.PModeReceptionAwareness;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeAddressList;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.leg.PModeLegBusinessInformation;
import com.helger.phase4.model.pmode.leg.PModeLegErrorHandling;
import com.helger.phase4.model.pmode.leg.PModeLegProtocol;
import com.helger.phase4.model.pmode.leg.PModeLegSecurity;
import com.helger.phase4.wss.EWSSVersion;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CEFPMode {
    public static final String DEFAULT_AGREEMENT_ID = "urn:as4:agreement";

    private CEFPMode() {
    }

    @Nonnull
    public static PModeLegProtocol generatePModeLegProtocol(@Nullable String string) {
        return PModeLegProtocol.createForDefaultSoapVersion(string);
    }

    @Nonnull
    public static PModeLegBusinessInformation generatePModeLegBusinessInformation() {
        String string = null;
        Long l = null;
        return new PModeLegBusinessInformation(string, "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/test", l, "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/defaultMPC");
    }

    @Nonnull
    public static PModeLegErrorHandling generatePModeLegErrorHandling() {
        PModeAddressList pModeAddressList = null;
        PModeAddressList pModeAddressList2 = null;
        ETriState eTriState = ETriState.TRUE;
        ETriState eTriState2 = ETriState.TRUE;
        ETriState eTriState3 = ETriState.TRUE;
        ETriState eTriState4 = ETriState.TRUE;
        return new PModeLegErrorHandling(pModeAddressList, pModeAddressList2, eTriState, eTriState2, eTriState3, eTriState4);
    }

    @Nonnull
    public static PModeLegSecurity generatePModeLegSecurity() {
        PModeLegSecurity pModeLegSecurity = new PModeLegSecurity();
        pModeLegSecurity.setWSSVersion(EWSSVersion.WSS_111);
        pModeLegSecurity.setX509SignatureAlgorithm(ECryptoAlgorithmSign.RSA_SHA_256);
        pModeLegSecurity.setX509SignatureHashFunction(ECryptoAlgorithmSignDigest.DIGEST_SHA_256);
        pModeLegSecurity.setX509EncryptionAlgorithm(ECryptoAlgorithmCrypt.AES_128_GCM);
        pModeLegSecurity.setX509EncryptionMinimumStrength(128);
        pModeLegSecurity.setPModeAuthorize(false);
        pModeLegSecurity.setSendReceipt(true);
        pModeLegSecurity.setSendReceiptNonRepudiation(true);
        pModeLegSecurity.setSendReceiptReplyPattern(EPModeSendReceiptReplyPattern.RESPONSE);
        return pModeLegSecurity;
    }

    @Nonnull
    public static PModeLeg generatePModeLeg(@Nullable String string) {
        return new PModeLeg(CEFPMode.generatePModeLegProtocol(string), CEFPMode.generatePModeLegBusinessInformation(), CEFPMode.generatePModeLegErrorHandling(), null, CEFPMode.generatePModeLegSecurity());
    }

    @Nonnull
    public static PModeReceptionAwareness generatePModeReceptionAwareness() {
        ETriState eTriState = ETriState.TRUE;
        ETriState eTriState2 = ETriState.TRUE;
        ETriState eTriState3 = ETriState.TRUE;
        return new PModeReceptionAwareness(eTriState, eTriState2, 1, 10000, eTriState3);
    }

    @Nonnull
    public static PMode createCEFPMode(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nonnull IPModeIDProvider iPModeIDProvider, boolean bl) {
        PModeParty pModeParty = PModeParty.createSimple(string, "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/initiator");
        PModeParty pModeParty2 = PModeParty.createSimple(string2, "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/responder");
        PMode pMode = new PMode(iPModeIDProvider, pModeParty, pModeParty2, DEFAULT_AGREEMENT_ID, EMEP.ONE_WAY, EMEPBinding.PUSH, CEFPMode.generatePModeLeg(string3), (PModeLeg)null, (PModePayloadService)null, CEFPMode.generatePModeReceptionAwareness());
        if (bl) {
            MetaAS4Manager.getPModeMgr().createOrUpdatePMode(pMode);
        }
        return pMode;
    }

    @Nonnull
    public static PMode createCEFPModeTwoWay(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nonnull IPModeIDProvider iPModeIDProvider, boolean bl) {
        PModeParty pModeParty = PModeParty.createSimple(string, "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/initiator");
        PModeParty pModeParty2 = PModeParty.createSimple(string2, "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/responder");
        PMode pMode = new PMode(iPModeIDProvider, pModeParty, pModeParty2, DEFAULT_AGREEMENT_ID, EMEP.TWO_WAY, EMEPBinding.PUSH_PUSH, CEFPMode.generatePModeLeg(string3), CEFPMode.generatePModeLeg(string3), (PModePayloadService)null, PModeReceptionAwareness.createDefault());
        if (bl) {
            MetaAS4Manager.getPModeMgr().createOrUpdatePMode(pMode);
        }
        return pMode;
    }
}

