/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.commons.wrapper.Wrapper;
import com.helger.httpclient.response.ResponseHandlerHttpEntity;
import com.helger.phase4.attachment.IIncomingAttachmentFactory;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.client.AS4ClientSentMessage;
import com.helger.phase4.client.AS4ClientUserMessage;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.client.IAS4RawResponseConsumer;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.client.IAS4SignalMessageConsumer;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.messaging.EAS4IncomingMessageMode;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.servlet.AS4IncomingHandler;
import com.helger.phase4.servlet.AS4IncomingMessageMetadata;
import com.helger.phase4.util.Phase4Exception;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AS4BidirectionalClientHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4BidirectionalClientHelper.class);

    private AS4BidirectionalClientHelper() {
    }

    public static void sendAS4AndReceiveAS4(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IPModeResolver iPModeResolver, @Nonnull IIncomingAttachmentFactory iIncomingAttachmentFactory, @Nonnull AS4ClientUserMessage aS4ClientUserMessage, @Nonnull Locale locale, @Nonnull String string, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper, @Nullable IAS4IncomingDumper iAS4IncomingDumper, @Nullable IAS4RetryCallback iAS4RetryCallback, @Nullable IAS4RawResponseConsumer iAS4RawResponseConsumer, @Nullable IAS4SignalMessageConsumer iAS4SignalMessageConsumer) throws IOException, Phase4Exception, WSSecurityException, MessagingException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Sending AS4 message to '" + string + "' with max. " + aS4ClientUserMessage.getMaxRetries() + " retries");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  ServiceType = '" + aS4ClientUserMessage.getServiceType() + "'");
            LOGGER.debug("  Service = '" + aS4ClientUserMessage.getServiceValue() + "'");
            LOGGER.debug("  Action = '" + aS4ClientUserMessage.getAction() + "'");
            LOGGER.debug("  ConversationId = '" + aS4ClientUserMessage.getConversationID() + "'");
            LOGGER.debug("  MessageProperties:");
            for (Ebms3Property object2 : aS4ClientUserMessage.ebms3Properties()) {
                LOGGER.debug("    [" + object2.getName() + "] = [" + object2.getValue() + "]");
            }
            LOGGER.debug("  Attachments (" + aS4ClientUserMessage.attachments().size() + "):");
            for (WSS4JAttachment wSS4JAttachment : aS4ClientUserMessage.attachments()) {
                LOGGER.debug("    [" + wSS4JAttachment.getId() + "] with [" + wSS4JAttachment.getMimeType() + "] and [" + wSS4JAttachment.getCharsetOrDefault(null) + "] and [" + wSS4JAttachment.getCompressionMode() + "] and [" + wSS4JAttachment.getContentTransferEncoding() + "]");
            }
        }
        Iterator iterator = new Wrapper();
        ResponseHandler<byte[]> responseHandler = httpResponse -> {
            HttpEntity httpEntity = ResponseHandlerHttpEntity.INSTANCE.handleResponse(httpResponse);
            if (httpEntity == null) {
                return null;
            }
            iterator.set(httpResponse);
            return EntityUtils.toByteArray(httpEntity);
        };
        AS4ClientSentMessage<byte[]> aS4ClientSentMessage = aS4ClientUserMessage.sendMessageWithRetries(string, responseHandler, iAS4ClientBuildMessageCallback, iAS4OutgoingDumper, iAS4RetryCallback);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Successfully transmitted AS4 document with message ID '" + aS4ClientSentMessage.getMessageID() + "' to '" + string + "'");
        }
        if (iAS4RawResponseConsumer != null) {
            iAS4RawResponseConsumer.handleResponse(aS4ClientSentMessage);
        }
        if (aS4ClientSentMessage.hasResponse() && aS4ClientSentMessage.getResponse().length > 0) {
            AS4IncomingMessageMetadata aS4IncomingMessageMetadata = new AS4IncomingMessageMetadata(EAS4IncomingMessageMode.RESPONSE);
            Ebms3SignalMessage ebms3SignalMessage = AS4IncomingHandler.parseSignalMessage(iAS4CryptoFactory, iPModeResolver, iIncomingAttachmentFactory, aS4ClientUserMessage.getAS4ResourceHelper(), aS4ClientUserMessage.getPMode(), locale, aS4IncomingMessageMetadata, (HttpResponse)((Wrapper)((Object)iterator)).get(), aS4ClientSentMessage.getResponse(), iAS4IncomingDumper);
            if (ebms3SignalMessage != null && iAS4SignalMessageConsumer != null) {
                iAS4SignalMessageConsumer.handleSignalMessage(ebms3SignalMessage);
            }
        } else {
            LOGGER.info("AS4 ResponseEntity is empty");
        }
    }
}

