/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.commons.lang.TimeValue;
import com.helger.commons.state.ESuccess;
import com.helger.commons.traits.IGenericImplTrait;
import com.helger.httpclient.HttpClientFactory;
import com.helger.httpclient.HttpClientSettings;
import com.helger.phase4.crypto.AS4CryptoFactoryPropertiesFile;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.Phase4Exception;
import java.time.Duration;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractAS4MessageBuilder<IMPLTYPE extends AbstractAS4MessageBuilder<IMPLTYPE>>
implements IGenericImplTrait<IMPLTYPE> {
    protected HttpClientFactory m_aHttpClientFactory;
    protected IAS4CryptoFactory m_aCryptoFactory;
    protected String m_sMessageID;
    protected ESoapVersion m_eSoapVersion;
    protected int m_nMaxRetries = -1;
    protected long m_nRetryIntervalMS = -1L;
    protected Locale m_aLocale = Locale.US;

    public AbstractAS4MessageBuilder() {
        try {
            this.httpClientFactory(new HttpClientFactory());
            this.cryptoFactory(AS4CryptoFactoryPropertiesFile.getDefaultInstance());
            this.soapVersion(ESoapVersion.SOAP_12);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to init AbstractAS4MessageBuilder", exception);
        }
    }

    @Nullable
    public final HttpClientFactory httpClientFactory() {
        return this.m_aHttpClientFactory;
    }

    @Nonnull
    public final IMPLTYPE httpClientFactory(@Nullable HttpClientSettings httpClientSettings) {
        return this.httpClientFactory(httpClientSettings == null ? null : new HttpClientFactory(httpClientSettings));
    }

    @Nonnull
    public final IMPLTYPE httpClientFactory(@Nullable HttpClientFactory httpClientFactory) {
        this.m_aHttpClientFactory = httpClientFactory;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IAS4CryptoFactory cryptoFactory() {
        return this.m_aCryptoFactory;
    }

    @Nonnull
    public final IMPLTYPE cryptoFactory(@Nullable IAS4CryptoFactory iAS4CryptoFactory) {
        this.m_aCryptoFactory = iAS4CryptoFactory;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE messageID(@Nullable String string) {
        this.m_sMessageID = string;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nullable
    public final ESoapVersion soapVersion() {
        return this.m_eSoapVersion;
    }

    @Nonnull
    public final IMPLTYPE soapVersion(@Nullable ESoapVersion eSoapVersion) {
        this.m_eSoapVersion = eSoapVersion;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE maxRetries(int n) {
        this.m_nMaxRetries = n;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE retryInterval(@Nullable TimeValue timeValue) {
        return this.retryIntervalMilliseconds(timeValue == null ? null : Long.valueOf(timeValue.getAsMillis()));
    }

    @Nonnull
    public final IMPLTYPE retryInterval(@Nullable Duration duration) {
        return this.retryIntervalMilliseconds(duration == null ? null : Long.valueOf(duration.toMillis()));
    }

    @Nonnull
    public final IMPLTYPE retryIntervalMilliseconds(long l) {
        this.m_nRetryIntervalMS = l;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE locale(@Nullable Locale locale) {
        this.m_aLocale = locale;
        return (IMPLTYPE)((AbstractAS4MessageBuilder)this.thisAsT());
    }

    @OverridingMethodsMustInvokeSuper
    public boolean isEveryRequiredFieldSet() {
        if (this.m_aHttpClientFactory == null) {
            return false;
        }
        if (this.m_eSoapVersion == null) {
            return false;
        }
        return this.m_aLocale != null;
    }

    @Nonnull
    public abstract ESuccess sendMessage() throws Phase4Exception;
}

