/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.sender;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.attachment.IIncomingAttachmentFactory;
import com.helger.phase4.attachment.Phase4OutgoingAttachment;
import com.helger.phase4.client.AS4ClientUserMessage;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.client.IAS4RawResponseConsumer;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.client.IAS4SignalMessageConsumer;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.model.MessageProperty;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.resolve.DefaultPModeResolver;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.sender.AbstractAS4MessageBuilder;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractAS4UserMessageBuilder<IMPLTYPE extends AbstractAS4UserMessageBuilder<IMPLTYPE>>
extends AbstractAS4MessageBuilder<IMPLTYPE> {
    protected IPModeResolver m_aPModeResolver;
    protected IIncomingAttachmentFactory m_aIAF;
    private IPMode m_aPMode;
    private String m_sServiceType;
    private String m_sService;
    private String m_sAction;
    private String m_sAgreementRef;
    private String m_sPModeID;
    private String m_sFromPartyIDType;
    private String m_sFromPartyID;
    private String m_sFromRole;
    private String m_sToPartyIDType;
    private String m_sToPartyID;
    private String m_sToRole;
    private String m_sConversationID;
    private final ICommonsList<MessageProperty> m_aMessageProperties = new CommonsArrayList<MessageProperty>();
    private X509Certificate m_aReceiverCertificate;
    protected String m_sEndointURL;
    protected final ICommonsList<Phase4OutgoingAttachment> m_aAttachments = new CommonsArrayList<Phase4OutgoingAttachment>();
    protected IAS4ClientBuildMessageCallback m_aBuildMessageCallback;
    protected IAS4OutgoingDumper m_aOutgoingDumper;
    protected IAS4IncomingDumper m_aIncomingDumper;
    protected IAS4RetryCallback m_aRetryCallback;
    protected IAS4RawResponseConsumer m_aResponseConsumer;
    protected IAS4SignalMessageConsumer m_aSignalMsgConsumer;

    public AbstractAS4UserMessageBuilder() {
        try {
            IPModeResolver iPModeResolver = DefaultPModeResolver.DEFAULT_PMODE_RESOLVER;
            this.pmodeResolver(iPModeResolver);
            this.incomingAttachmentFactory(IIncomingAttachmentFactory.DEFAULT_INSTANCE);
            this.pmode(iPModeResolver.getPModeOfID(null, "s", "a", "i", "r", null));
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to init AbstractAS4UserMessageBuilder", exception);
        }
    }

    @Nullable
    public final IPModeResolver pmodeResolver() {
        return this.m_aPModeResolver;
    }

    @Nonnull
    public final IMPLTYPE pmodeResolver(@Nullable IPModeResolver iPModeResolver) {
        this.m_aPModeResolver = iPModeResolver;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IIncomingAttachmentFactory incomingAttachmentFactory() {
        return this.m_aIAF;
    }

    @Nonnull
    public final IMPLTYPE incomingAttachmentFactory(@Nullable IIncomingAttachmentFactory iIncomingAttachmentFactory) {
        this.m_aIAF = iIncomingAttachmentFactory;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nullable
    public final IPMode pmode() {
        return this.m_aPMode;
    }

    @Nonnull
    public final IMPLTYPE pmode(@Nullable IPMode iPMode) {
        this.m_aPMode = iPMode;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE service(@Nullable String string) {
        return this.service(null, string);
    }

    @Nonnull
    public final IMPLTYPE service(@Nullable String string, @Nullable String string2) {
        this.m_sServiceType = string;
        this.m_sService = string2;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE action(@Nullable String string) {
        this.m_sAction = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE agreementRef(@Nullable String string) {
        this.m_sAgreementRef = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE pmodeID(@Nullable String string) {
        this.m_sPModeID = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE fromPartyIDType(@Nullable String string) {
        this.m_sFromPartyIDType = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE fromPartyID(@Nullable String string) {
        this.m_sFromPartyID = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE fromRole(@Nullable String string) {
        this.m_sFromRole = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE toPartyIDType(@Nullable String string) {
        this.m_sToPartyIDType = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE toPartyID(@Nullable String string) {
        this.m_sToPartyID = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE toRole(@Nullable String string) {
        this.m_sToRole = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE conversationID(@Nullable String string) {
        this.m_sConversationID = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE addMessageProperty(@Nullable Ebms3Property ebms3Property) {
        return this.addMessageProperty(ebms3Property == null ? null : MessageProperty.builder(ebms3Property));
    }

    @Nonnull
    public final IMPLTYPE addMessageProperty(@Nullable MessageProperty.Builder builder) {
        return this.addMessageProperty(builder == null ? null : builder.build());
    }

    @Nonnull
    public final IMPLTYPE addMessageProperty(@Nullable MessageProperty messageProperty) {
        if (messageProperty != null) {
            this.m_aMessageProperties.add(messageProperty);
        }
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE messageProperty(@Nullable Ebms3Property ebms3Property) {
        return this.messageProperty(ebms3Property == null ? null : MessageProperty.builder(ebms3Property));
    }

    @Nonnull
    public final IMPLTYPE messageProperty(@Nullable MessageProperty.Builder builder) {
        return this.messageProperty(builder == null ? null : builder.build());
    }

    @Nonnull
    public final IMPLTYPE messageProperty(@Nullable MessageProperty messageProperty) {
        if (messageProperty == null) {
            this.m_aMessageProperties.clear();
        } else {
            this.m_aMessageProperties.set(messageProperty);
        }
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE messageProperties(MessageProperty ... messagePropertyArray) {
        this.m_aMessageProperties.setAll((MessageProperty[])messagePropertyArray);
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE messageProperties(@Nullable Iterable<? extends MessageProperty> iterable) {
        this.m_aMessageProperties.setAll(iterable);
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE receiverCertificate(@Nullable X509Certificate x509Certificate) {
        this.m_aReceiverCertificate = x509Certificate;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE endpointURL(@Nullable String string) {
        this.m_sEndointURL = string;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE addAttachment(@Nullable Phase4OutgoingAttachment.Builder builder) {
        return this.addAttachment(builder == null ? null : builder.build());
    }

    @Nonnull
    public final IMPLTYPE addAttachment(@Nullable Phase4OutgoingAttachment phase4OutgoingAttachment) {
        if (phase4OutgoingAttachment != null) {
            this.m_aAttachments.add(phase4OutgoingAttachment);
        }
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE attachment(@Nullable Phase4OutgoingAttachment.Builder builder) {
        return this.attachment(builder == null ? null : builder.build());
    }

    @Nonnull
    public final IMPLTYPE attachment(@Nullable Phase4OutgoingAttachment phase4OutgoingAttachment) {
        if (phase4OutgoingAttachment == null) {
            this.m_aAttachments.clear();
        } else {
            this.m_aAttachments.set(phase4OutgoingAttachment);
        }
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE attachments(Phase4OutgoingAttachment ... phase4OutgoingAttachmentArray) {
        this.m_aAttachments.setAll((Phase4OutgoingAttachment[])phase4OutgoingAttachmentArray);
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE attachments(@Nullable Iterable<? extends Phase4OutgoingAttachment> iterable) {
        this.m_aAttachments.setAll(iterable);
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE buildMessageCallback(@Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback) {
        this.m_aBuildMessageCallback = iAS4ClientBuildMessageCallback;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE outgoingDumper(@Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
        this.m_aOutgoingDumper = iAS4OutgoingDumper;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE incomingDumper(@Nullable IAS4IncomingDumper iAS4IncomingDumper) {
        this.m_aIncomingDumper = iAS4IncomingDumper;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE retryCallback(@Nullable IAS4RetryCallback iAS4RetryCallback) {
        this.m_aRetryCallback = iAS4RetryCallback;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE rawResponseConsumer(@Nullable IAS4RawResponseConsumer iAS4RawResponseConsumer) {
        this.m_aResponseConsumer = iAS4RawResponseConsumer;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Nonnull
    public final IMPLTYPE signalMsgConsumer(@Nullable IAS4SignalMessageConsumer iAS4SignalMessageConsumer) {
        this.m_aSignalMsgConsumer = iAS4SignalMessageConsumer;
        return (IMPLTYPE)((AbstractAS4UserMessageBuilder)this.thisAsT());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isEveryRequiredFieldSet() {
        if (!super.isEveryRequiredFieldSet()) {
            return false;
        }
        if (this.m_aPMode == null) {
            return false;
        }
        if (StringHelper.hasNoText(this.m_sFromPartyID)) {
            return false;
        }
        if (StringHelper.hasNoText(this.m_sFromRole)) {
            return false;
        }
        if (StringHelper.hasNoText(this.m_sToPartyID)) {
            return false;
        }
        if (StringHelper.hasNoText(this.m_sToRole)) {
            return false;
        }
        return !StringHelper.hasNoText(this.m_sEndointURL);
    }

    protected final void applyToUserMessage(@Nonnull AS4ClientUserMessage aS4ClientUserMessage2) {
        if (this.m_nMaxRetries >= 0) {
            aS4ClientUserMessage2.setMaxRetries(this.m_nMaxRetries);
        }
        if (this.m_nRetryIntervalMS >= 0L) {
            aS4ClientUserMessage2.setRetryIntervalMS(this.m_nRetryIntervalMS);
        }
        aS4ClientUserMessage2.setHttpClientFactory(this.m_aHttpClientFactory);
        aS4ClientUserMessage2.setQuoteHttpHeaders(false);
        aS4ClientUserMessage2.setSoapVersion(this.m_eSoapVersion);
        aS4ClientUserMessage2.setAS4CryptoFactory(this.m_aCryptoFactory);
        aS4ClientUserMessage2.setPMode(this.m_aPMode, true);
        if (this.m_aReceiverCertificate != null) {
            aS4ClientUserMessage2.cryptParams().setCertificate(this.m_aReceiverCertificate);
        }
        aS4ClientUserMessage2.setAgreementRefValue(this.m_sAgreementRef);
        if (StringHelper.hasText(this.m_sPModeID)) {
            aS4ClientUserMessage2.setPModeID(this.m_sPModeID);
        } else {
            aS4ClientUserMessage2.setPModeIDFactory(aS4ClientUserMessage -> null);
        }
        aS4ClientUserMessage2.setServiceType(this.m_sServiceType);
        aS4ClientUserMessage2.setServiceValue(this.m_sService);
        aS4ClientUserMessage2.setAction(this.m_sAction);
        if (StringHelper.hasText(this.m_sMessageID)) {
            aS4ClientUserMessage2.setMessageID(this.m_sMessageID);
        }
        aS4ClientUserMessage2.setConversationID(StringHelper.hasText(this.m_sConversationID) ? this.m_sConversationID : MessageHelperMethods.createRandomConversationID());
        aS4ClientUserMessage2.setFromPartyIDType(this.m_sFromPartyIDType);
        aS4ClientUserMessage2.setFromPartyID(this.m_sFromPartyID);
        aS4ClientUserMessage2.setFromRole(this.m_sFromRole);
        aS4ClientUserMessage2.setToPartyIDType(this.m_sToPartyIDType);
        aS4ClientUserMessage2.setToPartyID(this.m_sToPartyID);
        aS4ClientUserMessage2.setToRole(this.m_sToRole);
        for (MessageProperty messageProperty : this.m_aMessageProperties) {
            aS4ClientUserMessage2.ebms3Properties().add(messageProperty.getAsEbms3Property());
        }
    }
}

