/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.error.IError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.string.StringHelper;
import com.helger.commons.wrapper.Wrapper;
import com.helger.http.AcceptMimeTypeHandler;
import com.helger.phase4.attachment.AS4DecompressException;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.IIncomingAttachmentFactory;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3PartInfo;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3PullRequest;
import com.helger.phase4.ebms3header.Ebms3Receipt;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.error.EEbmsError;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.AS4Helper;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.servlet.AS4MessageState;
import com.helger.phase4.servlet.AS4RequestHandler;
import com.helger.phase4.servlet.IAS4MessageState;
import com.helger.phase4.servlet.soap.AS4SingleSOAPHeader;
import com.helger.phase4.servlet.soap.ISOAPHeaderElementProcessor;
import com.helger.phase4.servlet.soap.SOAPHeaderElementProcessorRegistry;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.util.AS4XMLHelper;
import com.helger.phase4.util.Phase4Exception;
import com.helger.web.multipart.MultipartStream;
import com.helger.xml.ChildElementIterator;
import com.helger.xml.XMLHelper;
import com.helger.xml.serialize.read.DOMReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.xml.namespace.QName;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AS4IncomingHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4IncomingHandler.class);

    private AS4IncomingHandler() {
    }

    public static void parseAS4Message(@Nonnull IIncomingAttachmentFactory iIncomingAttachmentFactory, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull @WillClose InputStream inputStream, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull IAS4ParsedMessageCallback iAS4ParsedMessageCallback, @Nullable IAS4IncomingDumper iAS4IncomingDumper) throws Phase4Exception, IOException, MessagingException, WSSecurityException, Phase4Exception {
        String string = httpHeaderMap.getFirstHeaderValue("Content-Type");
        if (StringHelper.hasNoText(string)) {
            throw new Phase4Exception("Content-Type header is missing");
        }
        IMimeType iMimeType = AcceptMimeTypeHandler.safeParseMimeType(string);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received Content-Type: " + iMimeType);
        }
        if (iMimeType == null) {
            throw new Phase4Exception("Failed to parse Content-Type '" + string + "'");
        }
        IMimeType iMimeType2 = iMimeType.getCopyWithoutParameters();
        IAS4IncomingDumper iAS4IncomingDumper2 = iAS4IncomingDumper != null ? iAS4IncomingDumper : AS4DumpManager.getIncomingDumper();
        Document document = null;
        ESoapVersion eSoapVersion = null;
        CommonsArrayList<WSS4JAttachment> commonsArrayList = new CommonsArrayList<WSS4JAttachment>();
        if (iMimeType2.equals(AS4RequestHandler.MT_MULTIPART_RELATED)) {
            String string2;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Received MIME message");
            }
            if (StringHelper.hasNoText(string2 = iMimeType.getParameterValueWithName("boundary"))) {
                throw new Phase4Exception("Content-Type '" + string + "' misses 'boundary' parameter");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("MIME Boundary: '" + string2 + "'");
            }
            try (InputStream inputStream2 = AS4DumpManager.getIncomingDumpAwareInputStream(iAS4IncomingDumper2, inputStream, iAS4IncomingMessageMetadata, httpHeaderMap);){
                MultipartStream multipartStream = new MultipartStream(inputStream2, string2.getBytes(StandardCharsets.ISO_8859_1), null);
                int n = 0;
                while (true) {
                    boolean bl;
                    boolean bl2 = bl = n == 0 ? multipartStream.skipPreamble() : multipartStream.readBoundary();
                    if (!bl) {
                        break;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Found MIME part #" + n);
                    }
                    try (MultipartStream.MultipartItemInputStream multipartItemInputStream = multipartStream.createInputStream();){
                        Object object;
                        MimeBodyPart mimeBodyPart = new MimeBodyPart(multipartItemInputStream);
                        if (n == 0) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Parsing first MIME part as SOAP document");
                            }
                            document = DOMReader.readXMLDOM(mimeBodyPart.getInputStream());
                            object = MimeTypeParser.parseMimeType(mimeBodyPart.getContentType()).getCopyWithoutParameters();
                            eSoapVersion = ESoapVersion.getFromMimeTypeOrNull((IMimeType)object);
                            if (eSoapVersion != null && LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Determined SOAP version " + (Object)((Object)eSoapVersion) + " from Content-Type");
                            }
                            if (eSoapVersion == null && document != null && (eSoapVersion = ESoapVersion.getFromNamespaceURIOrNull(XMLHelper.getNamespaceURI(document))) != null && LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Determined SOAP version " + (Object)((Object)eSoapVersion) + " from XML root element namespace URI");
                            }
                        } else {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Parsing MIME part #" + n + " as attachment");
                            }
                            object = iIncomingAttachmentFactory.createAttachment(mimeBodyPart, aS4ResourceHelper);
                            commonsArrayList.add(object);
                        }
                    }
                    ++n;
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Read MIME message with " + commonsArrayList.size() + " attachment(s)");
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Received plain message");
            }
            document = DOMReader.readXMLDOM(AS4DumpManager.getIncomingDumpAwareInputStream(iAS4IncomingDumper2, inputStream, iAS4IncomingMessageMetadata, httpHeaderMap));
            if (LOGGER.isDebugEnabled()) {
                if (document != null) {
                    LOGGER.debug("Successfully parsed payload as XML");
                } else {
                    LOGGER.debug("Failed to parse payload as XML");
                }
            }
            if (document != null && (eSoapVersion = ESoapVersion.getFromNamespaceURIOrNull(XMLHelper.getNamespaceURI(document))) != null && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Determined SOAP version " + (Object)((Object)eSoapVersion) + " from XML root element namespace URI");
            }
            if (eSoapVersion == null && (eSoapVersion = ESoapVersion.getFromMimeTypeOrNull(iMimeType2)) != null && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Determined SOAP version " + (Object)((Object)eSoapVersion) + " from Content-Type");
            }
        }
        if (iAS4IncomingDumper2 != null) {
            try {
                iAS4IncomingDumper2.onEndRequest(iAS4IncomingMessageMetadata);
            }
            catch (Exception exception) {
                LOGGER.error("IncomingDumper.onEndRequest failed. Dumper=" + iAS4IncomingDumper2 + "; MessageMetadata=" + iAS4IncomingMessageMetadata, exception);
            }
        }
        if (document == null) {
            throw new Phase4Exception(eSoapVersion == null ? "Failed to parse incoming message!" : "Failed to parse incoming SOAP " + eSoapVersion.getVersion() + " document!");
        }
        if (eSoapVersion == null) {
            throw new Phase4Exception("Failed to determine SOAP version of XML document!");
        }
        iAS4ParsedMessageCallback.handle(httpHeaderMap, document, eSoapVersion, commonsArrayList);
    }

    private static void _processSoapHeaderElements(@Nonnull SOAPHeaderElementProcessorRegistry sOAPHeaderElementProcessorRegistry, @Nonnull Document document, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4MessageState aS4MessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) throws Phase4Exception {
        Object object;
        QName qName;
        ESoapVersion eSoapVersion = aS4MessageState.getSoapVersion();
        CommonsArrayList<AS4SingleSOAPHeader> commonsArrayList = new CommonsArrayList<AS4SingleSOAPHeader>();
        ICommonsOrderedMap<QName, ISOAPHeaderElementProcessor> iCommonsOrderedMap = XMLHelper.getFirstChildElementOfName(document.getDocumentElement(), eSoapVersion.getNamespaceURI(), eSoapVersion.getHeaderElementName());
        if (iCommonsOrderedMap == null) {
            throw new Phase4Exception("SOAP document is missing a Header element {" + eSoapVersion.getNamespaceURI() + "}" + eSoapVersion.getHeaderElementName());
        }
        for (Element object2 : new ChildElementIterator((Node)((Object)iCommonsOrderedMap))) {
            qName = XMLHelper.getQName(object2);
            object = object2.getAttributeNS(eSoapVersion.getNamespaceURI(), "mustUnderstand");
            boolean bl = eSoapVersion.getMustUnderstandValue(true).equals(object);
            commonsArrayList.add(new AS4SingleSOAPHeader(object2, qName, bl));
        }
        iCommonsOrderedMap = sOAPHeaderElementProcessorRegistry.getAllElementProcessors();
        if (iCommonsOrderedMap.isEmpty()) {
            LOGGER.warn("No SOAP Header element processor is registered");
        }
        for (Map.Entry entry : iCommonsOrderedMap.entrySet()) {
            qName = (QName)entry.getKey();
            object = commonsArrayList.findFirst(aS4SingleSOAPHeader -> qName.equals(aS4SingleSOAPHeader.getQName()));
            if (object == null) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Message contains no SOAP header element with QName " + qName.toString());
                continue;
            }
            ISOAPHeaderElementProcessor iSOAPHeaderElementProcessor = (ISOAPHeaderElementProcessor)entry.getValue();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing SOAP header element " + qName.toString() + " with processor " + iSOAPHeaderElementProcessor);
            }
            ErrorList errorList = new ErrorList();
            if (iSOAPHeaderElementProcessor.processHeaderElement(document, ((AS4SingleSOAPHeader)object).getNode(), iCommonsList, aS4MessageState, errorList).isSuccess()) {
                ((AS4SingleSOAPHeader)object).setProcessed(true);
                continue;
            }
            LOGGER.warn("Failed to process SOAP header element " + qName.toString() + " with processor " + iSOAPHeaderElementProcessor + "; error details: " + errorList);
            String string = aS4MessageState.getMessageID();
            Locale locale = aS4MessageState.getLocale();
            for (IError iError : errorList) {
                EEbmsError eEbmsError = EEbmsError.getFromErrorCodeOrNull(iError.getErrorID());
                if (eEbmsError != null) {
                    iCommonsList2.add(eEbmsError.getAsEbms3Error(locale, string));
                    continue;
                }
                Ebms3Error ebms3Error = new Ebms3Error();
                ebms3Error.setErrorDetail(iError.getErrorText(locale));
                ebms3Error.setErrorCode(iError.getErrorID());
                ebms3Error.setSeverity((String)iError.getErrorLevel().getID());
                ebms3Error.setOrigin(iError.getErrorFieldName());
                ebms3Error.setRefToMessageInError(string);
                iCommonsList2.add(ebms3Error);
            }
        }
        if (iCommonsList2.isEmpty()) {
            for (AS4SingleSOAPHeader aS4SingleSOAPHeader2 : commonsArrayList) {
                if (!aS4SingleSOAPHeader2.isMustUnderstand() || aS4SingleSOAPHeader2.isProcessed()) continue;
                throw new Phase4Exception("Error processing required SOAP header element " + aS4SingleSOAPHeader2.getQName().toString());
            }
        }
    }

    private static void _decompressAttachments(@Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull IAS4MessageState iAS4MessageState) {
        for (WSS4JAttachment wSS4JAttachment : (ICommonsList)iCommonsList.getClone()) {
            Ebms3Property ebms3Property2;
            EAS4CompressionMode eAS4CompressionMode = iAS4MessageState.getAttachmentCompressionMode(wSS4JAttachment.getId());
            if (eAS4CompressionMode == null) continue;
            IHasInputStream iHasInputStream = wSS4JAttachment.getInputStreamProvider();
            wSS4JAttachment.setSourceStreamProvider(new HasInputStream(() -> {
                try {
                    InputStream inputStream = iHasInputStream.getInputStream();
                    if (inputStream == null) {
                        throw new IllegalStateException("Failed to create InputStream from " + iHasInputStream);
                    }
                    return eAS4CompressionMode.getDecompressStream(inputStream);
                }
                catch (IOException iOException) {
                    throw new AS4DecompressException(iOException);
                }
            }, iHasInputStream.isReadMultiple()));
            String string = StringHelper.trimStart(wSS4JAttachment.getId(), "attachment=");
            Ebms3PartInfo ebms3PartInfo2 = CollectionHelper.findFirst(ebms3UserMessage.getPayloadInfo().getPartInfo(), ebms3PartInfo -> ebms3PartInfo.getHref() != null && ebms3PartInfo.getHref().contains(string));
            if (ebms3PartInfo2 == null || ebms3PartInfo2.getPartProperties() == null || (ebms3Property2 = CollectionHelper.findFirst(ebms3PartInfo2.getPartProperties().getProperty(), ebms3Property -> ebms3Property.getName().equalsIgnoreCase("MimeType"))) == null) continue;
            String string2 = ebms3Property2.getValue();
            if (MimeTypeParser.safeParseMimeType(string2) == null) {
                LOGGER.warn("Value '" + string2 + "' of property '" + "MimeType" + "' is not a valid MIME type");
            }
            wSS4JAttachment.overwriteMimeType(string2);
        }
    }

    @Nonnull
    public static IAS4MessageState processEbmsMessage(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nonnull Locale locale, @Nonnull SOAPHeaderElementProcessorRegistry sOAPHeaderElementProcessorRegistry, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) throws Phase4Exception {
        ValueEnforcer.notNull(httpHeaderMap, "HttpHeaders");
        ValueEnforcer.notNull(document, "SoapDocument");
        ValueEnforcer.notNull(eSoapVersion, "SoapVersion");
        ValueEnforcer.notNull(iCommonsList, "IncomingAttachments");
        ValueEnforcer.notNull(iCommonsList2, "aErrorMessagesTarget");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received the following SOAP " + eSoapVersion.getVersion() + " document:");
            LOGGER.debug(AS4XMLHelper.serializeXML(document));
            if (iCommonsList.isEmpty()) {
                LOGGER.debug("Without any incoming attachments");
            } else {
                LOGGER.debug("Including the following " + iCommonsList.size() + " attachments:");
                LOGGER.debug(iCommonsList.toString());
            }
        }
        AS4MessageState aS4MessageState = new AS4MessageState(eSoapVersion, aS4ResourceHelper, locale);
        AS4IncomingHandler._processSoapHeaderElements(sOAPHeaderElementProcessorRegistry, document, iCommonsList, aS4MessageState, iCommonsList2);
        boolean bl = iCommonsList2.isEmpty();
        aS4MessageState.setSoapHeaderElementProcessingSuccessful(bl);
        if (bl) {
            Object object;
            Object object2;
            Ebms3UserMessage ebms3UserMessage = aS4MessageState.getEbmsUserMessage();
            Ebms3SignalMessage ebms3SignalMessage = aS4MessageState.getEbmsSignalMessage();
            Ebms3Error ebms3Error = aS4MessageState.getEbmsError();
            Ebms3PullRequest ebms3PullRequest = aS4MessageState.getEbmsPullRequest();
            Ebms3Receipt ebms3Receipt = aS4MessageState.getEbmsReceipt();
            String string = ebms3UserMessage != null && ebms3UserMessage.getMessageInfo() != null ? ebms3UserMessage.getMessageInfo().getMessageId() : (ebms3SignalMessage != null && ebms3SignalMessage.getMessageInfo() != null ? ebms3SignalMessage.getMessageInfo().getMessageId() : null);
            aS4MessageState.setMessageID(string);
            int n = (ebms3UserMessage != null ? 1 : 0) + (ebms3PullRequest != null ? 1 : 0) + (ebms3Receipt != null ? 1 : 0) + (ebms3Error != null ? 1 : 0);
            if (n != 1) {
                iCommonsList2.add(EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.getAsEbms3Error(locale, string));
            }
            ICommonsList<WSS4JAttachment> iCommonsList3 = aS4MessageState.hasDecryptedAttachments() ? aS4MessageState.getDecryptedAttachments() : aS4MessageState.getOriginalAttachments();
            IPMode iPMode = aS4MessageState.getPMode();
            PModeLeg pModeLeg = aS4MessageState.getEffectivePModeLeg();
            if (ebms3UserMessage != null) {
                if (iPMode == null) {
                    throw new Phase4Exception("No AS4 P-Mode configuration found for user-message!");
                }
                if (pModeLeg == null) {
                    throw new Phase4Exception("No AS4 P-Mode leg could be determined!");
                }
                String string2 = aS4MessageState.getProfileID();
                if (StringHelper.hasText(string2)) {
                    object2 = MetaAS4Manager.getProfileMgr().getProfileOfID(string2);
                    if (object2 == null) {
                        throw new IllegalStateException("The configured AS4 profile '" + string2 + "' does not exist.");
                    }
                    object = object2.getValidator();
                    if (object != null) {
                        ErrorList errorList = new ErrorList();
                        object.validatePMode(iPMode, errorList);
                        object.validateUserMessage(ebms3UserMessage, errorList);
                        if (errorList.isNotEmpty()) {
                            throw new Phase4Exception("Error validating incoming AS4 message with the profile " + object2.getDisplayName() + "\n Following errors are present: " + errorList.getAllErrors().getAllTexts(locale));
                        }
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("AS4 state contains no AS4 profile ID - therefore no consistency checks are performed");
                }
                AS4IncomingHandler._decompressAttachments(iCommonsList3, ebms3UserMessage, aS4MessageState);
            } else if (ebms3PullRequest != null && iPMode == null) {
                throw new Phase4Exception("No AS4 P-Mode configuration found for pull-request!");
            }
            boolean bl2 = aS4MessageState.hasDecryptedSoapDocument();
            Object object3 = object2 = bl2 ? aS4MessageState.getDecryptedSoapDocument() : document;
            assert (object2 != null);
            object = XMLHelper.getFirstChildElementOfName(object2.getDocumentElement(), eSoapVersion.getNamespaceURI(), eSoapVersion.getBodyElementName());
            if (object == null) {
                throw new Phase4Exception((bl2 ? "Decrypted" : "Original") + " SOAP document is missing a Body element");
            }
            aS4MessageState.setSoapBodyPayloadNode(object.getFirstChild());
            aS4MessageState.setPingMessage(AS4Helper.isPingMessage(iPMode));
        }
        return aS4MessageState;
    }

    @Nullable
    public static Ebms3SignalMessage parseSignalMessage(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IPModeResolver iPModeResolver, @Nonnull IIncomingAttachmentFactory iIncomingAttachmentFactory, @Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper, @Nullable IPMode iPMode, @Nonnull Locale locale, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpResponse httpResponse, @Nonnull byte[] byArray, @Nullable IAS4IncomingDumper iAS4IncomingDumper) throws Phase4Exception {
        Wrapper wrapper = new Wrapper();
        IAS4ParsedMessageCallback iAS4ParsedMessageCallback = (httpHeaderMap, document, eSoapVersion, iCommonsList) -> {
            CommonsArrayList<Ebms3Error> commonsArrayList = new CommonsArrayList<Ebms3Error>();
            SOAPHeaderElementProcessorRegistry sOAPHeaderElementProcessorRegistry = SOAPHeaderElementProcessorRegistry.createDefault(iPModeResolver, iAS4CryptoFactory, iPMode);
            IAS4MessageState iAS4MessageState = AS4IncomingHandler.processEbmsMessage(aS4ResourceHelper, locale, sOAPHeaderElementProcessorRegistry, httpHeaderMap, document, eSoapVersion, iCommonsList, commonsArrayList);
            if (!iAS4MessageState.isSoapHeaderElementProcessingSuccessful()) {
                throw new Phase4Exception("Error processing AS4 signal message", iAS4MessageState.getSoapWSS4JException());
            }
            wrapper.set(iAS4MessageState.getEbmsSignalMessage());
        };
        HttpHeaderMap httpHeaderMap2 = new HttpHeaderMap();
        for (Header header : httpResponse.getAllHeaders()) {
            httpHeaderMap2.addHeader(header.getName(), header.getValue());
        }
        try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray);){
            AS4IncomingHandler.parseAS4Message(iIncomingAttachmentFactory, aS4ResourceHelper, iAS4IncomingMessageMetadata, nonBlockingByteArrayInputStream, httpHeaderMap2, iAS4ParsedMessageCallback, iAS4IncomingDumper);
        }
        catch (Phase4Exception phase4Exception) {
            throw phase4Exception;
        }
        catch (Exception exception) {
            throw new Phase4Exception("Error parsing signal message", exception);
        }
        return (Ebms3SignalMessage)wrapper.get();
    }

    public static interface IAS4ParsedMessageCallback {
        public void handle(@Nonnull HttpHeaderMap var1, @Nonnull Document var2, @Nonnull ESoapVersion var3, @Nonnull ICommonsList<WSS4JAttachment> var4) throws WSSecurityException, MessagingException, Phase4Exception;
    }
}

