/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.phase4.messaging.EAS4IncomingMessageMode;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import com.helger.phase4.mgr.MetaAS4Manager;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;

public class AS4IncomingMessageMetadata
implements IAS4IncomingMessageMetadata {
    private final String m_sIncomingUniqueID;
    private final LocalDateTime m_aIncomingDT;
    private final EAS4IncomingMessageMode m_eMode;
    private String m_sRemoteAddr;
    private String m_sRemoteHost;
    private int m_nRemotePort = -1;
    private String m_sRemoteUser;
    private final ICommonsList<Cookie> m_aCookies = new CommonsArrayList<Cookie>();

    public AS4IncomingMessageMetadata(@Nonnull EAS4IncomingMessageMode eAS4IncomingMessageMode) {
        this(UUID.randomUUID().toString(), MetaAS4Manager.getTimestampMgr().getCurrentDateTime(), eAS4IncomingMessageMode);
    }

    protected AS4IncomingMessageMetadata(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nonnull EAS4IncomingMessageMode eAS4IncomingMessageMode) {
        ValueEnforcer.notEmpty(string, "sIncomingUniqueID");
        ValueEnforcer.notNull(localDateTime, "IncomingDT");
        ValueEnforcer.notNull(eAS4IncomingMessageMode, "Mode");
        this.m_sIncomingUniqueID = string;
        this.m_aIncomingDT = localDateTime;
        this.m_eMode = eAS4IncomingMessageMode;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getIncomingUniqueID() {
        return this.m_sIncomingUniqueID;
    }

    @Override
    @Nonnull
    public final LocalDateTime getIncomingDT() {
        return this.m_aIncomingDT;
    }

    @Override
    @Nonnull
    public final EAS4IncomingMessageMode getMode() {
        return this.m_eMode;
    }

    @Override
    @Nullable
    public String getRemoteAddr() {
        return this.m_sRemoteAddr;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setRemoteAddr(@Nullable String string) {
        this.m_sRemoteAddr = string;
        return this;
    }

    @Override
    @Nullable
    public String getRemoteHost() {
        return this.m_sRemoteHost;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setRemoteHost(@Nullable String string) {
        this.m_sRemoteHost = string;
        return this;
    }

    @Override
    @CheckForSigned
    public int getRemotePort() {
        return this.m_nRemotePort;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setRemotePort(int n) {
        this.m_nRemotePort = n;
        return this;
    }

    @Override
    @Nullable
    public String getRemoteUser() {
        return this.m_sRemoteUser;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setRemoteUser(@Nullable String string) {
        this.m_sRemoteUser = string;
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<Cookie> cookies() {
        return this.m_aCookies;
    }

    @Nonnull
    public AS4IncomingMessageMetadata setCookies(@Nullable Cookie[] cookieArray) {
        this.m_aCookies.setAll((Cookie[])cookieArray);
        return this;
    }

    public String toString() {
        return new ToStringGenerator(this).append("IncomingUniqueID", this.m_sIncomingUniqueID).append("IncomingDT", this.m_aIncomingDT).append("Mode", this.m_eMode).append("RemoteAddr", this.m_sRemoteAddr).append("RemoteHost", this.m_sRemoteHost).append("RemotePort", this.m_nRemotePort).append("RemoteUser", this.m_sRemoteUser).append("Cookies", this.m_aCookies).getToString();
    }
}

