/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.EMimeContentType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.httpclient.response.ResponseHandlerXml;
import com.helger.phase4.attachment.AS4DecompressException;
import com.helger.phase4.attachment.IIncomingAttachmentFactory;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.client.IAS4RetryCallback;
import com.helger.phase4.crypto.AS4CryptParams;
import com.helger.phase4.crypto.AS4SigningParams;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.dump.AS4DumpManager;
import com.helger.phase4.dump.IAS4IncomingDumper;
import com.helger.phase4.dump.IAS4OutgoingDumper;
import com.helger.phase4.ebms3header.Ebms3CollaborationInfo;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.ebms3header.Ebms3MessageProperties;
import com.helger.phase4.ebms3header.Ebms3PartyInfo;
import com.helger.phase4.ebms3header.Ebms3PayloadInfo;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.error.EEbmsError;
import com.helger.phase4.http.AS4HttpDebug;
import com.helger.phase4.http.BasicHttpPoster;
import com.helger.phase4.http.HttpMimeMessageEntity;
import com.helger.phase4.http.HttpXMLEntity;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import com.helger.phase4.messaging.crypto.AS4Encryptor;
import com.helger.phase4.messaging.crypto.AS4Signer;
import com.helger.phase4.messaging.domain.AS4ErrorMessage;
import com.helger.phase4.messaging.domain.AS4ReceiptMessage;
import com.helger.phase4.messaging.domain.AS4UserMessage;
import com.helger.phase4.messaging.domain.EAS4MessageType;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.messaging.mime.AS4MimeMessage;
import com.helger.phase4.messaging.mime.MimeMessageCreator;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.EMEPBinding;
import com.helger.phase4.model.MEPHelper;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.EPModeSendReceiptReplyPattern;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.servlet.AS4IncomingHandler;
import com.helger.phase4.servlet.AS4UnifiedResponse;
import com.helger.phase4.servlet.AS4WorkerPool;
import com.helger.phase4.servlet.IAS4MessageState;
import com.helger.phase4.servlet.IAS4RequestHandlerErrorConsumer;
import com.helger.phase4.servlet.IAS4ResponseAbstraction;
import com.helger.phase4.servlet.mgr.AS4ServletMessageProcessorManager;
import com.helger.phase4.servlet.soap.SOAPHeaderElementProcessorRegistry;
import com.helger.phase4.servlet.spi.AS4MessageProcessorResult;
import com.helger.phase4.servlet.spi.AS4SignalMessageProcessorResult;
import com.helger.phase4.servlet.spi.IAS4ServletMessageProcessorSPI;
import com.helger.phase4.soap.ESoapVersion;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.phase4.util.AS4XMLHelper;
import com.helger.phase4.util.Phase4Exception;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xml.serialize.write.XMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.mail.MessagingException;
import javax.servlet.ServletInputStream;
import org.apache.http.HttpEntity;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AS4RequestHandler
implements AutoCloseable {
    public static final IMimeType MT_MULTIPART_RELATED = EMimeContentType.MULTIPART.buildMimeType("related");
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4RequestHandler.class);
    private final AS4ResourceHelper m_aResHelper;
    private final IAS4CryptoFactory m_aCryptoFactory;
    private final IPModeResolver m_aPModeResolver;
    private final IIncomingAttachmentFactory m_aIAF;
    private final IAS4IncomingMessageMetadata m_aMessageMetadata;
    private Locale m_aLocale = CGlobal.DEFAULT_LOCALE;
    private IAS4IncomingDumper m_aIncomingDumper;
    private IAS4OutgoingDumper m_aOutgoingDumper;
    private IAS4RetryCallback m_aRetryCallback;
    private ISupplier<ICommonsList<IAS4ServletMessageProcessorSPI>> m_aProcessorSupplier = AS4ServletMessageProcessorManager::getAllProcessors;
    private IAS4RequestHandlerErrorConsumer m_aErrorConsumer;

    public AS4RequestHandler(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IPModeResolver iPModeResolver, @Nonnull IIncomingAttachmentFactory iIncomingAttachmentFactory, @Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
        ValueEnforcer.notNull(iAS4CryptoFactory, "CryptoFactory");
        ValueEnforcer.notNull(iPModeResolver, "PModeResolver");
        ValueEnforcer.notNull(iIncomingAttachmentFactory, "IAF");
        ValueEnforcer.notNull(iAS4IncomingMessageMetadata, "MessageMetadata");
        this.m_aResHelper = new AS4ResourceHelper();
        this.m_aCryptoFactory = iAS4CryptoFactory;
        this.m_aPModeResolver = iPModeResolver;
        this.m_aIAF = iIncomingAttachmentFactory;
        this.m_aMessageMetadata = iAS4IncomingMessageMetadata;
    }

    @Override
    public void close() {
        this.m_aResHelper.close();
    }

    @Nonnull
    public final Locale getLocale() {
        return this.m_aLocale;
    }

    @Nonnull
    public final AS4RequestHandler setLocale(@Nonnull Locale locale) {
        ValueEnforcer.notNull(locale, "Locale");
        this.m_aLocale = locale;
        return this;
    }

    @Nullable
    public final IAS4IncomingDumper getIncomingDumper() {
        return this.m_aIncomingDumper;
    }

    @Nonnull
    public final AS4RequestHandler setIncomingDumper(@Nullable IAS4IncomingDumper iAS4IncomingDumper) {
        this.m_aIncomingDumper = iAS4IncomingDumper;
        return this;
    }

    @Nullable
    public final IAS4OutgoingDumper getOutgoingDumper() {
        return this.m_aOutgoingDumper;
    }

    @Nonnull
    public final AS4RequestHandler setOutgoingDumper(@Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
        this.m_aOutgoingDumper = iAS4OutgoingDumper;
        return this;
    }

    @Nullable
    public final IAS4RetryCallback getRetryCallback() {
        return this.m_aRetryCallback;
    }

    @Nonnull
    public final AS4RequestHandler setRetryCallback(@Nullable IAS4RetryCallback iAS4RetryCallback) {
        this.m_aRetryCallback = iAS4RetryCallback;
        return this;
    }

    @Nonnull
    public final ISupplier<ICommonsList<IAS4ServletMessageProcessorSPI>> getProcessorSupplier() {
        return this.m_aProcessorSupplier;
    }

    @Nonnull
    public final AS4RequestHandler setProcessorSupplier(@Nonnull ISupplier<ICommonsList<IAS4ServletMessageProcessorSPI>> iSupplier) {
        ValueEnforcer.notNull(iSupplier, "ProcessorSupplier");
        this.m_aProcessorSupplier = iSupplier;
        return this;
    }

    @Nullable
    public final IAS4RequestHandlerErrorConsumer getErrorConsumer() {
        return this.m_aErrorConsumer;
    }

    @Nonnull
    public final AS4RequestHandler setErrorConsumer(@Nullable IAS4RequestHandlerErrorConsumer iAS4RequestHandlerErrorConsumer) {
        this.m_aErrorConsumer = iAS4RequestHandlerErrorConsumer;
        return this;
    }

    private void _invokeSPIsForIncoming(@Nonnull HttpHeaderMap httpHeaderMap, @Nullable Ebms3UserMessage ebms3UserMessage, @Nullable Ebms3SignalMessage ebms3SignalMessage, @Nullable Node node, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nullable IPMode iPMode, @Nonnull IAS4MessageState iAS4MessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList3, @Nonnull SPIInvocationResult sPIInvocationResult) {
        ValueEnforcer.isTrue(ebms3UserMessage != null || ebms3SignalMessage != null, "User OR Signal Message must be present");
        ValueEnforcer.isFalse(ebms3UserMessage != null && ebms3SignalMessage != null, "Only one of User OR Signal Message may be present");
        boolean bl = ebms3UserMessage != null;
        String string = bl ? ebms3UserMessage.getMessageInfo().getMessageId() : ebms3SignalMessage.getMessageInfo().getMessageId();
        ICommonsList iCommonsList4 = (ICommonsList)this.m_aProcessorSupplier.get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to invoke the following " + iCommonsList4.size() + " SPIs on message ID '" + string + "': " + iCommonsList4);
        }
        for (IAS4ServletMessageProcessorSPI iAS4ServletMessageProcessorSPI : iCommonsList4) {
            if (iAS4ServletMessageProcessorSPI == null) continue;
            try {
                Object object;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Invoking AS4 message processor " + iAS4ServletMessageProcessorSPI + " for incoming message");
                }
                CommonsArrayList<Ebms3Error> commonsArrayList = new CommonsArrayList<Ebms3Error>();
                AS4MessageProcessorResult aS4MessageProcessorResult = bl ? iAS4ServletMessageProcessorSPI.processAS4UserMessage(this.m_aMessageMetadata, httpHeaderMap, ebms3UserMessage, iPMode, node, iCommonsList, iAS4MessageState, commonsArrayList) : iAS4ServletMessageProcessorSPI.processAS4SignalMessage(this.m_aMessageMetadata, httpHeaderMap, ebms3SignalMessage, iPMode, iAS4MessageState, commonsArrayList);
                if (aS4MessageProcessorResult == null) {
                    throw new IllegalStateException("No result object present from AS4 message processor " + iAS4ServletMessageProcessorSPI + " - this is a programming error");
                }
                if (commonsArrayList.isNotEmpty()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Processing errors are present after AS4 message processor " + iAS4ServletMessageProcessorSPI + " - breaking");
                    }
                    if (aS4MessageProcessorResult.isSuccess()) {
                        LOGGER.warn("Processing errors are present but success was returned by AS4 message processor " + iAS4ServletMessageProcessorSPI + " - considering it to be failed");
                    }
                    iCommonsList2.addAll(commonsArrayList);
                    return;
                }
                if (aS4MessageProcessorResult.isFailure()) {
                    object = "Invoked AS4 message processor SPI " + iAS4ServletMessageProcessorSPI + " on '" + string + "' returned a failure: " + aS4MessageProcessorResult.getErrorMessage();
                    LOGGER.warn((String)object);
                    iCommonsList2.add(EEbmsError.EBMS_OTHER.getAsEbms3Error(this.m_aLocale, string, (String)object));
                    return;
                }
                object = aS4MessageProcessorResult.getAsyncResponseURL();
                if (StringHelper.hasText((String)object)) {
                    if (sPIInvocationResult.hasAsyncResponseURL()) {
                        String string2 = "Invoked AS4 message processor SPI " + iAS4ServletMessageProcessorSPI + " on '" + string + "' failed: the previous processor already returned an async response URL; it is not possible to handle two URLs. Please check your SPI implementations.";
                        LOGGER.error(string2);
                        iCommonsList2.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsEbms3Error(this.m_aLocale, string, string2));
                        return;
                    }
                    sPIInvocationResult.setAsyncResponseURL((String)object);
                    LOGGER.info("Using asynchronous response URL '" + (String)object + "' for message ID '" + string + "'");
                }
                if (!bl) {
                    assert (aS4MessageProcessorResult instanceof AS4SignalMessageProcessorResult);
                    if (ebms3SignalMessage.getReceipt() == null) {
                        object = ((AS4SignalMessageProcessorResult)aS4MessageProcessorResult).getPullReturnUserMessage();
                        if (sPIInvocationResult.hasPullReturnUserMsg()) {
                            if (object != null) {
                                String string3 = "Invoked AS4 message processor SPI " + iAS4ServletMessageProcessorSPI + " on '" + string + "' failed: the previous processor already returned a usermessage; it is not possible to return two usermessage. Please check your SPI implementations.";
                                LOGGER.warn(string3);
                                iCommonsList2.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsEbms3Error(this.m_aLocale, string, string3));
                                return;
                            }
                        } else {
                            if (object == null) {
                                String string4 = "Invoked AS4 message processor SPI " + iAS4ServletMessageProcessorSPI + " on '" + string + "' returned a failure: no UserMessage contained in the MPC";
                                LOGGER.warn(string4);
                                iCommonsList2.add(EEbmsError.EBMS_EMPTY_MESSAGE_PARTITION_CHANNEL.getAsEbms3Error(this.m_aLocale, string, string4));
                                return;
                            }
                            sPIInvocationResult.setPullReturnUserMsg((Ebms3UserMessage)object);
                        }
                    }
                }
                aS4MessageProcessorResult.addAllAttachmentsTo(iCommonsList3);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Successfully invoked AS4 message processor " + iAS4ServletMessageProcessorSPI);
            }
            catch (AS4DecompressException aS4DecompressException) {
                iCommonsList2.add(EEbmsError.EBMS_DECOMPRESSION_FAILURE.getAsEbms3Error(this.m_aLocale, string));
                return;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Error processing incoming AS4 message with processor " + iAS4ServletMessageProcessorSPI, exception);
            }
        }
        sPIInvocationResult.setSuccess(true);
    }

    private void _invokeSPIsForResponse(@Nonnull IAS4MessageState iAS4MessageState, @Nullable IAS4ResponseFactory iAS4ResponseFactory, @Nullable HttpEntity httpEntity, @Nonnull IMimeType iMimeType) {
        Serializable serializable;
        Object object;
        boolean bl = iAS4ResponseFactory != null;
        byte[] byArray = null;
        if (iAS4ResponseFactory != null) {
            Object object2 = object = httpEntity != null ? httpEntity : iAS4ResponseFactory.getHttpEntityForSending(iMimeType);
            if (object.isRepeatable()) {
                int n = (int)object.getContentLength();
                if (n < 0) {
                    n = 16384;
                }
                try {
                    serializable = new NonBlockingByteArrayOutputStream(n);
                    Throwable throwable = null;
                    try {
                        object.writeTo((OutputStream)((Object)serializable));
                        byArray = ((NonBlockingByteArrayOutputStream)serializable).getBufferOrCopy();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (serializable != null) {
                            if (throwable != null) {
                                try {
                                    ((NonBlockingByteArrayOutputStream)serializable).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((NonBlockingByteArrayOutputStream)serializable).close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    LOGGER.error("Error dumping response entity", iOException);
                }
            } else {
                LOGGER.warn("Response entity is not repeatable and therefore not read for SPIs");
            }
        } else {
            LOGGER.info("No response factory present");
        }
        object = (ICommonsList)this.m_aProcessorSupplier.get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to invoke the following " + object.size() + " SPIs on message ID '" + iAS4MessageState.getMessageID() + "': " + object);
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            serializable = (IAS4ServletMessageProcessorSPI)iterator.next();
            if (serializable == null) continue;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Invoking AS4 message processor " + serializable + " for response");
                }
                serializable.processAS4ResponseMessage(this.m_aMessageMetadata, iAS4MessageState, byArray, bl);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Finished invoking AS4 message processor " + serializable + " for response");
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Error invoking AS4 message processor " + serializable + " for response", exception);
            }
        }
    }

    @Nonnull
    private static AS4UserMessage _createReversedUserMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList) {
        Ebms3MessageInfo ebms3MessageInfo = MessageHelperMethods.createEbms3MessageInfo(MessageHelperMethods.createRandomMessageID(), ebms3UserMessage.getMessageInfo().getMessageId());
        Ebms3PayloadInfo ebms3PayloadInfo = MessageHelperMethods.createEbms3PayloadInfo(false, iCommonsList);
        Ebms3PartyInfo ebms3PartyInfo = MessageHelperMethods.createEbms3ReversePartyInfo(ebms3UserMessage.getPartyInfo());
        Ebms3CollaborationInfo ebms3CollaborationInfo = ebms3UserMessage.getCollaborationInfo();
        Ebms3MessageProperties ebms3MessageProperties = new Ebms3MessageProperties();
        Serializable serializable = null;
        Ebms3Property ebms3Property = null;
        for (Ebms3Property ebms3Property2 : ebms3UserMessage.getMessageProperties().getProperty()) {
            if (ebms3Property2.getName().equals("originalSender")) {
                ebms3Property = ebms3Property2;
                continue;
            }
            if (!ebms3Property2.getName().equals("finalRecipient")) continue;
            serializable = ebms3Property2;
        }
        if (ebms3Property == null) {
            throw new IllegalStateException("Failed to determine new OriginalSender");
        }
        if (serializable == null) {
            throw new IllegalStateException("Failed to determine new FinalRecipient");
        }
        serializable.setName("originalSender");
        ebms3Property.setName("finalRecipient");
        ebms3MessageProperties.addProperty((Ebms3Property)serializable);
        ebms3MessageProperties.addProperty(ebms3Property);
        serializable = AS4UserMessage.create(ebms3MessageInfo, ebms3PayloadInfo, ebms3CollaborationInfo, ebms3PartyInfo, ebms3MessageProperties, eSoapVersion);
        return serializable;
    }

    private static boolean _isSendErrorAsResponse(@Nullable PModeLeg pModeLeg) {
        if (pModeLeg != null && pModeLeg.hasErrorHandling() && pModeLeg.getErrorHandling().isReportAsResponseDefined()) {
            return pModeLeg.getErrorHandling().isReportAsResponse();
        }
        return true;
    }

    private static boolean _isSendReceiptAsResponse(@Nonnull PModeLeg pModeLeg) {
        if (pModeLeg != null && pModeLeg.hasSecurity()) {
            return EPModeSendReceiptReplyPattern.RESPONSE.equals(pModeLeg.getSecurity().getSendReceiptReplyPattern());
        }
        return true;
    }

    @Nonnull
    private Document _signResponseIfNeeded(@Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4SigningParams aS4SigningParams, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull @Nonempty String string) throws WSSecurityException {
        Document document2 = aS4SigningParams.isSigningEnabled() ? AS4Signer.createSignedMessage(this.m_aCryptoFactory, document, eSoapVersion, string, iCommonsList, this.m_aResHelper, true, aS4SigningParams.getClone()) : document;
        return document2;
    }

    private static boolean _isSendNonRepudiationInformation(@Nonnull PModeLeg pModeLeg) {
        if (pModeLeg.hasSecurity() && pModeLeg.getSecurity().isSendReceiptNonRepudiationDefined()) {
            return pModeLeg.getSecurity().isSendReceiptNonRepudiation();
        }
        return false;
    }

    private IAS4ResponseFactory _createResponseReceiptMessage(@Nullable Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull PModeLeg pModeLeg, @Nullable Ebms3UserMessage ebms3UserMessage, @Nullable ICommonsList<WSS4JAttachment> iCommonsList) throws WSSecurityException {
        String string = MessageHelperMethods.createRandomMessageID();
        AS4ReceiptMessage aS4ReceiptMessage = (AS4ReceiptMessage)AS4ReceiptMessage.create(eSoapVersion, string, ebms3UserMessage, document, AS4RequestHandler._isSendNonRepudiationInformation(pModeLeg)).setMustUnderstand(true);
        Document document2 = aS4ReceiptMessage.getAsSoapDocument();
        AS4SigningParams aS4SigningParams = new AS4SigningParams().setFromPMode(pModeLeg.getSecurity());
        Document document3 = this._signResponseIfNeeded(iCommonsList, aS4SigningParams, document2, pModeLeg.getProtocol().getSoapVersion(), aS4ReceiptMessage.getMessagingID());
        return new AS4ResponseFactoryXML(string, document3, eSoapVersion.getMimeType());
    }

    @Nonnull
    private AS4MimeMessage _createMimeMessageForResponse(@Nonnull Document document, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull ESoapVersion eSoapVersion, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException, MessagingException {
        AS4MimeMessage aS4MimeMessage = aS4CryptParams.isCryptEnabled(LOGGER::warn) ? AS4Encryptor.encryptMimeMessage(eSoapVersion, document, iCommonsList, this.m_aCryptoFactory, true, this.m_aResHelper, aS4CryptParams) : MimeMessageCreator.generateMimeMessage(eSoapVersion, document, iCommonsList);
        if (aS4MimeMessage == null) {
            throw new IllegalStateException("Failed to create MimeMessage!");
        }
        return aS4MimeMessage;
    }

    @Nonnull
    private IAS4ResponseFactory _createResponseUserMessage(@Nonnull ESoapVersion eSoapVersion, @Nonnull AS4UserMessage aS4UserMessage, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4SigningParams aS4SigningParams, @Nonnull AS4CryptParams aS4CryptParams) throws WSSecurityException, MessagingException {
        IAS4ResponseFactory iAS4ResponseFactory;
        String string = aS4UserMessage.getEbms3UserMessage().getMessageInfo().getMessageId();
        Document document = this._signResponseIfNeeded(iCommonsList, aS4SigningParams, aS4UserMessage.getAsSoapDocument(), eSoapVersion, aS4UserMessage.getMessagingID());
        if (iCommonsList.isEmpty()) {
            iAS4ResponseFactory = new AS4ResponseFactoryXML(string, document, eSoapVersion.getMimeType());
        } else {
            AS4MimeMessage aS4MimeMessage = this._createMimeMessageForResponse(document, iCommonsList, eSoapVersion, aS4CryptParams);
            iAS4ResponseFactory = new AS4ResponseFactoryMIME(string, aS4MimeMessage);
        }
        return iAS4ResponseFactory;
    }

    @Nullable
    private IAS4ResponseFactory _handleSoapMessage(@Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Document document, @Nonnull ESoapVersion eSoapVersion, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) throws WSSecurityException, MessagingException, Phase4Exception {
        IAS4ResponseFactory iAS4ResponseFactory;
        boolean bl;
        SOAPHeaderElementProcessorRegistry sOAPHeaderElementProcessorRegistry = SOAPHeaderElementProcessorRegistry.createDefault(this.m_aPModeResolver, this.m_aCryptoFactory, null);
        IAS4MessageState iAS4MessageState = AS4IncomingHandler.processEbmsMessage(this.m_aResHelper, this.m_aLocale, sOAPHeaderElementProcessorRegistry, httpHeaderMap, document, eSoapVersion, iCommonsList, iCommonsList2);
        IPMode iPMode = iAS4MessageState.getPMode();
        PModeLeg pModeLeg = iAS4MessageState.getEffectivePModeLeg();
        String string = iAS4MessageState.getProfileID();
        String string2 = iAS4MessageState.getMessageID();
        ICommonsList<WSS4JAttachment> iCommonsList3 = iAS4MessageState.hasDecryptedAttachments() ? iAS4MessageState.getDecryptedAttachments() : iAS4MessageState.getOriginalAttachments();
        Node node = iAS4MessageState.getSoapBodyPayloadNode();
        Ebms3UserMessage ebms3UserMessage = iAS4MessageState.getEbmsUserMessage();
        Ebms3SignalMessage ebms3SignalMessage = iAS4MessageState.getEbmsSignalMessage();
        if (iAS4MessageState.isSoapHeaderElementProcessingSuccessful()) {
            boolean bl2;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No checking for duplicate message with message ID '" + string2 + "' and profile ID '" + string + "'");
            }
            if (bl2 = MetaAS4Manager.getIncomingDuplicateMgr().registerAndCheck(string2, string, iPMode == null ? null : (String)iPMode.getID()).isBreak()) {
                LOGGER.warn("Not invoking SPIs, because message with Message ID '" + string2 + "' was already handled!");
                iCommonsList2.add(EEbmsError.EBMS_OTHER.getAsEbms3Error(this.m_aLocale, string2, "Another message with the same ID was already received!"));
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Message is not a duplicate");
            }
        }
        SPIInvocationResult sPIInvocationResult = new SPIInvocationResult();
        CommonsArrayList<WSS4JAttachment> commonsArrayList = new CommonsArrayList<WSS4JAttachment>();
        boolean bl3 = bl = iCommonsList2.isEmpty() && !iAS4MessageState.isPingMessage();
        if (bl) {
            if (iPMode == null || iPMode.getMEPBinding().isSynchronous() || iPMode.getMEPBinding().isAsynchronousInitiator() || iAS4MessageState.getEffectivePModeLegNumber() != 1) {
                this._invokeSPIsForIncoming(httpHeaderMap, ebms3UserMessage, ebms3SignalMessage, node, iCommonsList3, iPMode, iAS4MessageState, iCommonsList2, commonsArrayList, sPIInvocationResult);
                if (sPIInvocationResult.isFailure()) {
                    LOGGER.warn("Error invoking synchronous SPIs");
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully invoked synchronous SPIs");
                }
            } else {
                AS4WorkerPool.getInstance().run(() -> {
                    IAS4ResponseFactory iAS4ResponseFactory;
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    CommonsArrayList<Ebms3Error> commonsArrayList = new CommonsArrayList<Ebms3Error>();
                    CommonsArrayList<WSS4JAttachment> commonsArrayList2 = new CommonsArrayList<WSS4JAttachment>();
                    SPIInvocationResult sPIInvocationResult = new SPIInvocationResult();
                    this._invokeSPIsForIncoming(httpHeaderMap, ebms3UserMessage, ebms3SignalMessage, node, iCommonsList3, iPMode, iAS4MessageState, commonsArrayList, commonsArrayList2, sPIInvocationResult);
                    if (sPIInvocationResult.isSuccess()) {
                        assert (commonsArrayList.isEmpty());
                        object4 = AS4RequestHandler._createReversedUserMessage(eSoapVersion, ebms3UserMessage, commonsArrayList2);
                        object3 = new AS4SigningParams().setFromPMode(pModeLeg.getSecurity());
                        object2 = ebms3UserMessage.getPartyInfo().getTo().getPartyIdAtIndex(0).getValue();
                        object = new AS4CryptParams().setFromPMode(pModeLeg.getSecurity()).setAlias((String)object2);
                        iAS4ResponseFactory = this._createResponseUserMessage(pModeLeg.getProtocol().getSoapVersion(), (AS4UserMessage)object4, commonsArrayList, (AS4SigningParams)object3, (AS4CryptParams)object);
                    } else {
                        object4 = AS4ErrorMessage.create(eSoapVersion, iAS4MessageState.getMessageID(), commonsArrayList);
                        if (this.m_aErrorConsumer != null && commonsArrayList.isNotEmpty()) {
                            this.m_aErrorConsumer.onAS4ErrorMessage(iAS4MessageState, commonsArrayList, (AS4ErrorMessage)object4);
                        }
                        object3 = ((AS4ErrorMessage)object4).getEbms3SignalMessage().getMessageInfo().getMessageId();
                        iAS4ResponseFactory = new AS4ResponseFactoryXML((String)object3, object4.getAsSoapDocument(), eSoapVersion.getMimeType());
                    }
                    object4 = sPIInvocationResult.getAsyncResponseURL();
                    if (StringHelper.hasNoText((String)object4)) {
                        throw new IllegalStateException("No asynchronous response URL present - please check your SPI implementation");
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Responding asynchronous to: " + (String)object4);
                    }
                    object3 = iAS4ResponseFactory.getHttpEntityForSending(eSoapVersion.getMimeType());
                    object3 = this.m_aResHelper.createRepeatableHttpEntity((HttpEntity)object3);
                    this._invokeSPIsForResponse(iAS4MessageState, iAS4ResponseFactory, (HttpEntity)object3, eSoapVersion.getMimeType());
                    object2 = new BasicHttpPoster();
                    HttpHeaderMap httpHeaderMap2 = null;
                    boolean bl = true;
                    long l = 12000L;
                    object = ((BasicHttpPoster)object2).sendGenericMessageWithRetries(httpHeaderMap2, (HttpEntity)object3, string2, (String)object4, 1, 12000L, new ResponseHandlerXml(), this.m_aOutgoingDumper, this.m_aRetryCallback);
                    AS4HttpDebug.debug(() -> AS4RequestHandler.lambda$null$0((Document)object));
                });
            }
        }
        if (!iAS4MessageState.isSoapHeaderElementProcessingSuccessful() || iAS4MessageState.getEbmsError() == null) {
            if (iCommonsList2.isNotEmpty()) {
                AS4ErrorMessage aS4ErrorMessage = AS4ErrorMessage.create(eSoapVersion, iAS4MessageState.getMessageID(), iCommonsList2);
                if (this.m_aErrorConsumer != null) {
                    this.m_aErrorConsumer.onAS4ErrorMessage(iAS4MessageState, iCommonsList2, aS4ErrorMessage);
                }
                if (AS4RequestHandler._isSendErrorAsResponse(pModeLeg)) {
                    String string3 = aS4ErrorMessage.getEbms3SignalMessage().getMessageInfo().getMessageId();
                    iAS4ResponseFactory = new AS4ResponseFactoryXML(string3, aS4ErrorMessage.getAsSoapDocument(), eSoapVersion.getMimeType());
                } else {
                    LOGGER.warn("Not sending back the error, because sending error response is prohibited in PMode");
                    iAS4ResponseFactory = null;
                }
            } else if (ebms3SignalMessage == null || ebms3SignalMessage.getReceipt() == null) {
                if (iPMode.getMEP().isOneWay() || iPMode.getMEPBinding().isAsynchronous()) {
                    if (iPMode.getMEPBinding().equals(EMEPBinding.PULL) || iPMode.getMEPBinding().equals(EMEPBinding.PULL_PUSH) && sPIInvocationResult.hasPullReturnUserMsg() || iPMode.getMEPBinding().equals(EMEPBinding.PUSH_PULL) && sPIInvocationResult.hasPullReturnUserMsg()) {
                        AS4UserMessage aS4UserMessage = new AS4UserMessage(eSoapVersion, sPIInvocationResult.getPullReturnUserMsg());
                        String string4 = aS4UserMessage.getEbms3UserMessage().getMessageInfo().getMessageId();
                        iAS4ResponseFactory = new AS4ResponseFactoryXML(string4, aS4UserMessage.getAsSoapDocument(), eSoapVersion.getMimeType());
                    } else if (ebms3UserMessage != null) {
                        boolean bl4 = AS4RequestHandler._isSendReceiptAsResponse(pModeLeg);
                        if (bl4) {
                            iAS4ResponseFactory = this._createResponseReceiptMessage(document, eSoapVersion, pModeLeg, ebms3UserMessage, commonsArrayList);
                        } else {
                            LOGGER.info("Not sending back the receipt response, because sending receipt response is prohibited in PMode");
                            iAS4ResponseFactory = null;
                        }
                    } else {
                        iAS4ResponseFactory = null;
                    }
                } else {
                    PModeLeg pModeLeg2 = iPMode.getLeg2();
                    if (pModeLeg2 == null) {
                        throw new Phase4Exception("PMode has no leg2!");
                    }
                    if (MEPHelper.isValidResponseTypeLeg2(iPMode.getMEP(), iPMode.getMEPBinding(), EAS4MessageType.USER_MESSAGE)) {
                        AS4UserMessage aS4UserMessage = AS4RequestHandler._createReversedUserMessage(eSoapVersion, ebms3UserMessage, commonsArrayList);
                        AS4SigningParams aS4SigningParams = new AS4SigningParams().setFromPMode(pModeLeg2.getSecurity());
                        String string5 = ebms3UserMessage.getPartyInfo().getTo().getPartyIdAtIndex(0).getValue();
                        AS4CryptParams aS4CryptParams = new AS4CryptParams().setFromPMode(pModeLeg2.getSecurity()).setAlias(string5);
                        iAS4ResponseFactory = this._createResponseUserMessage(pModeLeg2.getProtocol().getSoapVersion(), aS4UserMessage, commonsArrayList, aS4SigningParams, aS4CryptParams);
                    } else {
                        iAS4ResponseFactory = null;
                    }
                }
            } else {
                iAS4ResponseFactory = null;
            }
        } else {
            iAS4ResponseFactory = null;
        }
        this._invokeSPIsForResponse(iAS4MessageState, iAS4ResponseFactory, null, eSoapVersion.getMimeType());
        return iAS4ResponseFactory;
    }

    public void handleRequest(@Nonnull @WillClose InputStream inputStream, @Nonnull HttpHeaderMap httpHeaderMap2, @Nonnull IAS4ResponseAbstraction iAS4ResponseAbstraction) throws Phase4Exception, IOException, MessagingException, WSSecurityException {
        AS4IncomingHandler.IAS4ParsedMessageCallback iAS4ParsedMessageCallback = (httpHeaderMap, document, eSoapVersion, iCommonsList) -> {
            CommonsArrayList<Ebms3Error> commonsArrayList = new CommonsArrayList<Ebms3Error>();
            IAS4ResponseFactory iAS4ResponseFactory = this._handleSoapMessage(httpHeaderMap, document, eSoapVersion, iCommonsList, commonsArrayList);
            if (iAS4ResponseFactory != null) {
                IAS4OutgoingDumper iAS4OutgoingDumper = this.m_aOutgoingDumper != null ? this.m_aOutgoingDumper : AS4DumpManager.getOutgoingDumper();
                iAS4ResponseFactory.applyToResponse(iAS4ResponseAbstraction, iAS4OutgoingDumper);
            } else {
                iAS4ResponseAbstraction.setStatus(204);
            }
            AS4HttpDebug.debug(() -> "RECEIVE-END with " + (iAS4ResponseFactory != null ? "EBMS message" : "no content"));
        };
        AS4IncomingHandler.parseAS4Message(this.m_aIAF, this.m_aResHelper, this.m_aMessageMetadata, inputStream, httpHeaderMap2, iAS4ParsedMessageCallback, this.m_aIncomingDumper);
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull AS4UnifiedResponse aS4UnifiedResponse) throws Phase4Exception, IOException, MessagingException, WSSecurityException {
        AS4HttpDebug.debug(() -> "RECEIVE-START at " + iRequestWebScopeWithoutResponse.getFullContextAndServletPath());
        ServletInputStream servletInputStream = iRequestWebScopeWithoutResponse.getRequest().getInputStream();
        HttpHeaderMap httpHeaderMap = iRequestWebScopeWithoutResponse.headers().getClone();
        IAS4ResponseAbstraction iAS4ResponseAbstraction = IAS4ResponseAbstraction.wrap(aS4UnifiedResponse);
        this.handleRequest(servletInputStream, httpHeaderMap, iAS4ResponseAbstraction);
    }

    private static /* synthetic */ String lambda$null$0(Document document) {
        return "SEND-RESPONSE [async sent] received: " + XMLWriter.getNodeAsString(document, AS4HttpDebug.getDebugXMLWriterSettings());
    }

    private static final class SPIInvocationResult
    implements ISuccessIndicator {
        private boolean m_bSuccess = false;
        private Ebms3UserMessage m_aPullReturnUserMsg;
        private String m_sAsyncResponseURL;

        private SPIInvocationResult() {
        }

        @Override
        public boolean isSuccess() {
            return this.m_bSuccess;
        }

        void setSuccess(boolean bl) {
            this.m_bSuccess = bl;
        }

        void setPullReturnUserMsg(@Nonnull Ebms3UserMessage ebms3UserMessage) {
            this.m_aPullReturnUserMsg = ebms3UserMessage;
        }

        @Nullable
        public Ebms3UserMessage getPullReturnUserMsg() {
            return this.m_aPullReturnUserMsg;
        }

        public boolean hasPullReturnUserMsg() {
            return this.m_aPullReturnUserMsg != null;
        }

        void setAsyncResponseURL(@Nonnull String string) {
            this.m_sAsyncResponseURL = string;
        }

        @Nullable
        public String getAsyncResponseURL() {
            return this.m_sAsyncResponseURL;
        }

        public boolean hasAsyncResponseURL() {
            return StringHelper.hasText(this.m_sAsyncResponseURL);
        }
    }

    private static final class AS4ResponseFactoryMIME
    implements IAS4ResponseFactory {
        private final String m_sMessageID;
        private final AS4MimeMessage m_aMimeMsg;
        private final HttpHeaderMap m_aHttpHeaders;

        public AS4ResponseFactoryMIME(@Nonnull @Nonempty String string, @Nonnull AS4MimeMessage aS4MimeMessage) throws MessagingException {
            ValueEnforcer.notEmpty(string, "MessageID");
            ValueEnforcer.notNull(aS4MimeMessage, "MimeMsg");
            this.m_sMessageID = string;
            this.m_aMimeMsg = aS4MimeMessage;
            this.m_aHttpHeaders = MessageHelperMethods.getAndRemoveAllHeaders(this.m_aMimeMsg);
            if (!aS4MimeMessage.isRepeatable()) {
                LOGGER.warn("The response MIME message is not repeatable");
            }
        }

        @Override
        @Nonnull
        public HttpMimeMessageEntity getHttpEntityForSending(@Nonnull IMimeType iMimeType) {
            return new HttpMimeMessageEntity(this.m_aMimeMsg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyToResponse(@Nonnull IAS4ResponseAbstraction iAS4ResponseAbstraction, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
            block6: {
                HasInputStream hasInputStream = HasInputStream.multiple(() -> {
                    try {
                        return this.m_aMimeMsg.getInputStream();
                    }
                    catch (IOException | MessagingException exception) {
                        throw new IllegalStateException("Failed to get MIME input stream", exception);
                    }
                });
                iAS4ResponseAbstraction.setContent(this.m_aHttpHeaders, hasInputStream);
                iAS4ResponseAbstraction.setMimeType(MT_MULTIPART_RELATED);
                if (iAS4OutgoingDumper != null) {
                    try {
                        OutputStream outputStream = iAS4OutgoingDumper.onBeginRequest(this.m_sMessageID, this.m_aHttpHeaders, 0);
                        if (outputStream == null) break block6;
                        try {
                            StreamHelper.copyInputStreamToOutputStream(hasInputStream.getBufferedInputStream(), outputStream);
                        }
                        finally {
                            StreamHelper.close(outputStream);
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.warn("IOException in dumping of outgoing MIME response", iOException);
                    }
                }
            }
        }
    }

    private static final class AS4ResponseFactoryXML
    implements IAS4ResponseFactory {
        private final String m_sMessageID;
        private final Document m_aDoc;
        private final IMimeType m_aMimeType;

        public AS4ResponseFactoryXML(@Nonnull @Nonempty String string, @Nonnull Document document, @Nonnull IMimeType iMimeType) {
            ValueEnforcer.notEmpty(string, "MessageID");
            ValueEnforcer.notNull(document, "Doc");
            ValueEnforcer.notNull(iMimeType, "MimeType");
            this.m_sMessageID = string;
            this.m_aDoc = document;
            this.m_aMimeType = iMimeType;
        }

        @Override
        @Nonnull
        public HttpEntity getHttpEntityForSending(@Nonnull IMimeType iMimeType) {
            return new HttpXMLEntity(this.m_aDoc, this.m_aMimeType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyToResponse(@Nonnull IAS4ResponseAbstraction iAS4ResponseAbstraction, @Nullable IAS4OutgoingDumper iAS4OutgoingDumper) {
            block6: {
                String string = AS4XMLHelper.serializeXML(this.m_aDoc);
                Charset charset = AS4XMLHelper.XWS.getCharset();
                byte[] byArray = string.getBytes(charset);
                iAS4ResponseAbstraction.setContent(byArray, charset);
                iAS4ResponseAbstraction.setMimeType(this.m_aMimeType);
                if (iAS4OutgoingDumper != null) {
                    try {
                        OutputStream outputStream = iAS4OutgoingDumper.onBeginRequest(this.m_sMessageID, null, 0);
                        if (outputStream == null) break block6;
                        try {
                            outputStream.write(byArray);
                        }
                        finally {
                            StreamHelper.close(outputStream);
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.warn("IOException in dumping of outgoing XML response", iOException);
                    }
                }
            }
        }
    }

    private static interface IAS4ResponseFactory {
        @Nonnull
        public HttpEntity getHttpEntityForSending(@Nonnull IMimeType var1);

        public void applyToResponse(@Nonnull IAS4ResponseAbstraction var1, @Nullable IAS4OutgoingDumper var2);
    }
}

