/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.commons.http.EHttpMethod;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.http.EHttpVersion;
import com.helger.servlet.response.UnifiedResponse;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4UnifiedResponse
extends UnifiedResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4UnifiedResponse.class);

    public AS4UnifiedResponse(@Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull HttpServletRequest httpServletRequest) {
        super(eHttpVersion, eHttpMethod, httpServletRequest);
        this.disableCaching();
        this.setAllowContentOnStatusCode(true);
    }

    public void setResponseError(@Nonnegative int n, @Nonnull String string, @Nullable Throwable throwable) {
        LOGGER.error("HTTP " + n + ": " + string, throwable);
        String string2 = string;
        if (throwable != null) {
            string2 = string2 + "\nTechnical details:\n" + StackTraceHelper.getStackAsString(throwable);
        }
        this.setContentAndCharset(string2, StandardCharsets.UTF_8);
        this.setMimeType(CMimeType.TEXT_PLAIN);
        this.setStatus(n);
    }
}

