/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.commons.functional.IThrowingSupplier;
import com.helger.scope.IScope;
import com.helger.scope.singleton.AbstractGlobalSingleton;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4WorkerPool
extends AbstractGlobalSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4WorkerPool.class);
    private final ExecutorService m_aES;

    @Deprecated
    @UsedViaReflection
    public AS4WorkerPool() {
        this(Runtime.getRuntime().availableProcessors() * 2);
    }

    public AS4WorkerPool(@Nonnegative int n) {
        this(Executors.newFixedThreadPool(n, new BasicThreadFactory.Builder().setDaemon(true).setNamingPattern("as4-worker-%d").build()));
    }

    public AS4WorkerPool(@Nonnull ExecutorService executorService) {
        ValueEnforcer.notNull(executorService, "ExecutorService");
        this.m_aES = executorService;
    }

    @Nonnull
    public static AS4WorkerPool getInstance() {
        return AS4WorkerPool.getGlobalSingleton(AS4WorkerPool.class);
    }

    @Override
    protected void onDestroy(@Nonnull IScope iScope) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AS4 worker pool about to be closed");
        }
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished(this.m_aES);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("AS4 worker pool was closed!");
        }
    }

    @Nonnull
    public CompletableFuture<Void> run(@Nonnull IThrowingRunnable<? extends Exception> iThrowingRunnable) {
        return CompletableFuture.runAsync(() -> {
            try {
                iThrowingRunnable.run();
            }
            catch (Exception exception) {
                LOGGER.error("Error running AS4 runner " + iThrowingRunnable, exception);
            }
        }, this.m_aES);
    }

    @Nonnull
    public <T> CompletableFuture<T> supply(@Nonnull IThrowingSupplier<T, ? extends Exception> iThrowingSupplier) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return iThrowingSupplier.get();
            }
            catch (Exception exception) {
                LOGGER.error("Error running AS4 supplier " + iThrowingSupplier, exception);
                return null;
            }
        }, this.m_aES);
    }
}

