/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.lang.GenericReflection;
import com.helger.http.EHttpVersion;
import com.helger.phase4.attachment.IIncomingAttachmentFactory;
import com.helger.phase4.crypto.AS4CryptoFactoryPropertiesFile;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.messaging.EAS4IncomingMessageMode;
import com.helger.phase4.model.pmode.resolve.DefaultPModeResolver;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.servlet.AS4IncomingMessageMetadata;
import com.helger.phase4.servlet.AS4RequestHandler;
import com.helger.phase4.servlet.AS4UnifiedResponse;
import com.helger.phase4.util.Phase4Exception;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import java.io.Serializable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4XServletHandler
implements IXServletSimpleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4XServletHandler.class);
    private Supplier<? extends IAS4CryptoFactory> m_aCryptoFactorySupplier;
    private IPModeResolver m_aPModeResolver;
    private IIncomingAttachmentFactory m_aIAF;
    private IHandlerCustomizer m_aHandlerCustomizer;

    public AS4XServletHandler() {
        this(AS4CryptoFactoryPropertiesFile::getDefaultInstance, DefaultPModeResolver.DEFAULT_PMODE_RESOLVER, IIncomingAttachmentFactory.DEFAULT_INSTANCE);
    }

    public AS4XServletHandler(@Nonnull Supplier<? extends IAS4CryptoFactory> supplier, @Nonnull IPModeResolver iPModeResolver, @Nonnull IIncomingAttachmentFactory iIncomingAttachmentFactory) {
        this.setCryptoFactorySupplier(supplier);
        this.setPModeResolver(iPModeResolver);
        this.setIncomingAttachmentFactory(iIncomingAttachmentFactory);
    }

    @Nonnull
    public final Supplier<? extends IAS4CryptoFactory> getCryptoFactorySupplier() {
        return this.m_aCryptoFactorySupplier;
    }

    @Nonnull
    public final AS4XServletHandler setCryptoFactorySupplier(@Nonnull Supplier<? extends IAS4CryptoFactory> supplier) {
        ValueEnforcer.notNull(supplier, "CryptoFactorySupplier");
        this.m_aCryptoFactorySupplier = supplier;
        return this;
    }

    @Nonnull
    public final IPModeResolver getPModeResolver() {
        return this.m_aPModeResolver;
    }

    @Nonnull
    public final AS4XServletHandler setPModeResolver(@Nonnull IPModeResolver iPModeResolver) {
        ValueEnforcer.notNull(iPModeResolver, "PModeResolver");
        this.m_aPModeResolver = iPModeResolver;
        return this;
    }

    @Nonnull
    public final IIncomingAttachmentFactory getIncomingAttachmentFactory() {
        return this.m_aIAF;
    }

    @Nonnull
    public final AS4XServletHandler setIncomingAttachmentFactory(@Nonnull IIncomingAttachmentFactory iIncomingAttachmentFactory) {
        ValueEnforcer.notNull(iIncomingAttachmentFactory, "IAF");
        this.m_aIAF = iIncomingAttachmentFactory;
        return this;
    }

    @Nullable
    public final IHandlerCustomizer getHandlerCustomizer() {
        return this.m_aHandlerCustomizer;
    }

    @Nonnull
    public final AS4XServletHandler setHandlerCustomizer(@Nullable IHandlerCustomizer iHandlerCustomizer) {
        this.m_aHandlerCustomizer = iHandlerCustomizer;
        return this;
    }

    @Override
    @Nonnull
    public AS4UnifiedResponse createUnifiedResponse(@Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull HttpServletRequest httpServletRequest, @Nonnull IRequestWebScope iRequestWebScope) {
        return new AS4UnifiedResponse(eHttpVersion, eHttpMethod, httpServletRequest);
    }

    @Override
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        AS4UnifiedResponse aS4UnifiedResponse = (AS4UnifiedResponse)GenericReflection.uncheckedCast(unifiedResponse);
        AS4IncomingMessageMetadata aS4IncomingMessageMetadata = new AS4IncomingMessageMetadata(EAS4IncomingMessageMode.REQUEST).setRemoteAddr(iRequestWebScopeWithoutResponse.getRemoteAddr()).setRemoteHost(iRequestWebScopeWithoutResponse.getRemoteHost()).setRemotePort(iRequestWebScopeWithoutResponse.getRemotePort()).setRemoteUser(iRequestWebScopeWithoutResponse.getRemoteUser()).setCookies(iRequestWebScopeWithoutResponse.getCookies());
        IAS4CryptoFactory iAS4CryptoFactory = this.m_aCryptoFactorySupplier.get();
        if (iAS4CryptoFactory == null) {
            throw new IllegalStateException("Failed to get an AS4 CryptoFactory");
        }
        try (AS4RequestHandler aS4RequestHandler = new AS4RequestHandler(iAS4CryptoFactory, this.m_aPModeResolver, this.m_aIAF, aS4IncomingMessageMetadata);){
            if (this.m_aHandlerCustomizer != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Before customizeBeforeHandling");
                }
                this.m_aHandlerCustomizer.customizeBeforeHandling(iRequestWebScopeWithoutResponse, aS4UnifiedResponse, aS4RequestHandler);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("After customizeBeforeHandling");
                }
            }
            aS4RequestHandler.handleRequest(iRequestWebScopeWithoutResponse, aS4UnifiedResponse);
            if (this.m_aHandlerCustomizer != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Before customizeAfterHandling");
                }
                this.m_aHandlerCustomizer.customizeAfterHandling(iRequestWebScopeWithoutResponse, aS4UnifiedResponse, aS4RequestHandler);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("After customizeAfterHandling");
                }
            }
        }
        catch (Phase4Exception phase4Exception) {
            aS4UnifiedResponse.setResponseError(400, "Bad Request: " + phase4Exception.getMessage(), phase4Exception.getCause());
        }
        catch (Exception exception) {
            aS4UnifiedResponse.setResponseError(500, "Internal error processing AS4 request", exception);
        }
    }

    public static interface IHandlerCustomizer
    extends Serializable {
        public void customizeBeforeHandling(@Nonnull IRequestWebScopeWithoutResponse var1, @Nonnull AS4UnifiedResponse var2, @Nonnull AS4RequestHandler var3);

        default public void customizeAfterHandling(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull AS4UnifiedResponse aS4UnifiedResponse, @Nonnull AS4RequestHandler aS4RequestHandler) {
        }
    }
}

