/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.dump;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.file.FileHelper;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.phase4.dump.AbstractAS4IncomingDumperWithHeaders;
import com.helger.phase4.messaging.IAS4IncomingMessageMetadata;
import com.helger.phase4.servlet.mgr.AS4ServerConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4IncomingDumperFileBased
extends AbstractAS4IncomingDumperWithHeaders {
    public static final String DEFAULT_BASE_PATH = "incoming/";
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4IncomingDumperFileBased.class);
    private final IFileProvider m_aFileProvider;

    public AS4IncomingDumperFileBased() {
        this((iAS4IncomingMessageMetadata, httpHeaderMap) -> new File(AS4ServerConfiguration.getDataPath(), DEFAULT_BASE_PATH + IFileProvider.getFilename(iAS4IncomingMessageMetadata)));
    }

    public AS4IncomingDumperFileBased(@Nonnull IFileProvider iFileProvider) {
        ValueEnforcer.notNull(iFileProvider, "FileProvider");
        this.m_aFileProvider = iFileProvider;
    }

    @Override
    @Nullable
    protected OutputStream openOutputStream(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap) throws IOException {
        File file = this.m_aFileProvider.createFile(iAS4IncomingMessageMetadata, httpHeaderMap);
        LOGGER.info("Logging incoming AS4 request to '" + file.getAbsolutePath() + "'");
        return FileHelper.getBufferedOutputStream(file);
    }

    @Nonnull
    public static AS4IncomingDumperFileBased createForDirectory(@Nonnull File file) {
        ValueEnforcer.notNull(file, "BaseDirectory");
        return new AS4IncomingDumperFileBased((iAS4IncomingMessageMetadata, httpHeaderMap) -> new File(file, IFileProvider.getFilename(iAS4IncomingMessageMetadata)));
    }

    @FunctionalInterface
    public static interface IFileProvider {
        @Nonnull
        public File createFile(@Nonnull IAS4IncomingMessageMetadata var1, @Nonnull HttpHeaderMap var2);

        @Nonnull
        public static String getFilename(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata) {
            return PDTIOHelper.getLocalDateTimeForFilename(iAS4IncomingMessageMetadata.getIncomingDT()) + ".as4in";
        }
    }
}

