/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.dump;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.phase4.dump.AbstractAS4OutgoingDumperWithHeaders;
import com.helger.phase4.servlet.mgr.AS4ServerConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4OutgoingDumperFileBased
extends AbstractAS4OutgoingDumperWithHeaders {
    public static final String DEFAULT_BASE_PATH = "outgoing/";
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4OutgoingDumperFileBased.class);
    private final IFileProvider m_aFileProvider;

    public AS4OutgoingDumperFileBased() {
        this((string, n) -> new File(AS4ServerConfiguration.getDataPath(), DEFAULT_BASE_PATH + IFileProvider.getFilename(string, n)));
    }

    public AS4OutgoingDumperFileBased(@Nonnull IFileProvider iFileProvider) {
        ValueEnforcer.notNull(iFileProvider, "FileProvider");
        this.m_aFileProvider = iFileProvider;
    }

    @Override
    protected OutputStream openOutputStream(@Nonnull @Nonempty String string, @Nullable HttpHeaderMap httpHeaderMap, @Nonnegative int n) throws IOException {
        File file = this.m_aFileProvider.getFile(string, n);
        LOGGER.info("Logging outgoing AS4 request to '" + file.getAbsolutePath() + "'");
        return FileHelper.getBufferedOutputStream(file);
    }

    @Nonnull
    public static AS4OutgoingDumperFileBased createForDirectory(@Nonnull File file) {
        ValueEnforcer.notNull(file, "BaseDirectory");
        return new AS4OutgoingDumperFileBased((string, n) -> new File(file, IFileProvider.getFilename(string, n)));
    }

    public static interface IFileProvider {
        @Nonnull
        public File getFile(@Nonnull @Nonempty String var1, @Nonnegative int var2);

        @Nonnull
        public static String getFilename(@Nonnull @Nonempty String string, @Nonnegative int n) {
            return PDTIOHelper.getCurrentLocalDateTimeForFilename() + "-" + FilenameHelper.getAsSecureValidASCIIFilename(string) + "-" + n + ".as4out";
        }
    }
}

