/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.dump;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.datetime.util.PDTIOHelper;
import com.helger.phase4.client.AS4ClientSentMessage;
import com.helger.phase4.client.IAS4RawResponseConsumer;
import com.helger.phase4.servlet.mgr.AS4ServerConfiguration;
import com.helger.phase4.util.Phase4Exception;
import java.io.File;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4RawResponseConsumerWriteToFile
implements IAS4RawResponseConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4RawResponseConsumerWriteToFile.class);
    private final IFileProvider m_aFileProvider;

    public AS4RawResponseConsumerWriteToFile() {
        this(string -> new File(AS4ServerConfiguration.getDataPath(), "outgoing/" + IFileProvider.getFilename(string)));
    }

    public AS4RawResponseConsumerWriteToFile(@Nonnull IFileProvider iFileProvider) {
        ValueEnforcer.notNull(iFileProvider, "FileProvider");
        this.m_aFileProvider = iFileProvider;
    }

    @Override
    public void handleResponse(@Nonnull AS4ClientSentMessage<byte[]> aS4ClientSentMessage) throws Phase4Exception {
        if (aS4ClientSentMessage.hasResponse() && aS4ClientSentMessage.getResponse().length > 0) {
            String string = aS4ClientSentMessage.getMessageID();
            File file = this.m_aFileProvider.createFile(string);
            LOGGER.info("Logging AS4 response to '" + file.getAbsolutePath() + "'");
            if (SimpleFileIO.writeFile(file, aS4ClientSentMessage.getResponse()).isFailure()) {
                LOGGER.error("Error writing AS4 response file to '" + file.getAbsolutePath() + "'");
            }
        }
    }

    @Nonnull
    public static AS4RawResponseConsumerWriteToFile createForDirectory(@Nonnull File file) {
        ValueEnforcer.notNull(file, "BaseDirectory");
        return new AS4RawResponseConsumerWriteToFile(string -> new File(file, IFileProvider.getFilename(string)));
    }

    @FunctionalInterface
    public static interface IFileProvider {
        @Nonnull
        public File createFile(@Nonnull String var1);

        @Nonnull
        public static String getFilename(@Nonnull String string) {
            return PDTIOHelper.getCurrentLocalDateTimeForFilename() + "-" + FilenameHelper.getAsSecureValidASCIIFilename(string) + "-response.xml";
        }
    }
}

