/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.mgr;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.ClassHelper;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.quartz.DisallowConcurrentExecution;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.SimpleScheduleBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.schedule.quartz.GlobalQuartzScheduler;
import com.helger.schedule.quartz.trigger.JDK8TriggerBuilder;
import com.helger.web.scope.util.AbstractScopeAwareJob;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public final class AS4DuplicateCleanupJob
extends AbstractScopeAwareJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4DuplicateCleanupJob.class);
    private static final String KEY_MINUTES = "mins";
    private static final AtomicBoolean s_aScheduled = new AtomicBoolean(false);

    @Override
    protected void onExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) throws JobExecutionException {
        long l = jobDataMap.getAsLong(KEY_MINUTES);
        LocalDateTime localDateTime = MetaAS4Manager.getTimestampMgr().getCurrentDateTime().minusMinutes(l);
        ICommonsList<String> iCommonsList = MetaAS4Manager.getIncomingDuplicateMgr().evictAllItemsBefore(localDateTime);
        if (iCommonsList.isNotEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Evicted " + iCommonsList.size() + " incoming duplicate message IDs before " + localDateTime.toString());
        }
    }

    @Nullable
    public static TriggerKey scheduleMe(long l) {
        TriggerKey triggerKey = null;
        if (l > 0L) {
            if (!s_aScheduled.getAndSet(true)) {
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.putIn(KEY_MINUTES, l);
                triggerKey = GlobalQuartzScheduler.getInstance().scheduleJob(ClassHelper.getClassLocalName(AS4DuplicateCleanupJob.class) + "-" + l, JDK8TriggerBuilder.newTrigger().startNow().withSchedule(SimpleScheduleBuilder.repeatMinutelyForever()), AS4DuplicateCleanupJob.class, jobDataMap);
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("AS4DuplicateCleanupJob is already scheduled");
            }
        } else {
            LOGGER.warn("Incoming duplicate message cleaning is disabled!");
        }
        return triggerKey;
    }
}

