/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.mgr;

import com.helger.settings.ISettings;
import com.helger.settings.Settings;
import com.helger.settings.exchange.configfile.ConfigFile;
import com.helger.settings.exchange.configfile.ConfigFileBuilder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class AS4ServerConfiguration {
    public static final long DEFAULT_RESET_MINUTES = 10L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4ServerConfiguration.class);
    private static final Settings SETTINGS = new Settings("phase4-server");
    private static boolean s_bUnitTestMode = false;

    public static void reinit(boolean bl) {
        s_bUnitTestMode = bl;
        ConfigFileBuilder configFileBuilder = new ConfigFileBuilder();
        if (bl) {
            configFileBuilder.addPathFromSystemProperty("phase4.server.test.configfile").addPathFromEnvVar("PHASE4_SERVER_TEST_CONFIG").addPath("private-test-phase4.properties").addPath("test-phase4.properties");
        } else {
            configFileBuilder.addPathFromSystemProperty("phase4.server.configfile").addPathFromSystemProperty("as4.server.configfile").addPathFromEnvVar("PHASE4_SERVER_CONFIG").addPath("private-phase4.properties").addPath("phase4.properties").addPath("private-as4.properties").addPath("as4.properties");
        }
        ConfigFile configFile = configFileBuilder.build();
        if (!configFile.isRead()) {
            LOGGER.warn("Failed to read phase4 server configuration file! All values will be default values");
        } else {
            LOGGER.info("Successfully read phase4 configuration file from " + configFile.getReadResource().getPath());
        }
        SETTINGS.setAll(configFile.getSettings());
    }

    public static void internalReinitForTestOnly() {
        if (!s_bUnitTestMode) {
            AS4ServerConfiguration.reinit(true);
        }
    }

    private AS4ServerConfiguration() {
    }

    @Nonnull
    public static ISettings getSettings() {
        return SETTINGS;
    }

    @Nonnull
    public static Settings getMutableSettings() {
        return SETTINGS;
    }

    @Nullable
    public static String getAS4ProfileID() {
        return AS4ServerConfiguration.getSettings().getAsString("server.profile");
    }

    public static boolean isGlobalDebug() {
        return AS4ServerConfiguration.getSettings().getAsBoolean("server.debug", false);
    }

    public static boolean isGlobalProduction() {
        return AS4ServerConfiguration.getSettings().getAsBoolean("server.production", false);
    }

    public static boolean isNoStartupInfo() {
        return AS4ServerConfiguration.getSettings().getAsBoolean("server.nostartupinfo", true);
    }

    @Nonnull
    public static String getDataPath() {
        return AS4ServerConfiguration.getSettings().getAsString("server.datapath", "conf");
    }

    public static long getIncomingDuplicateDisposalMinutes() {
        return AS4ServerConfiguration.getSettings().getAsLong("server.incoming.duplicatedisposal.minutes", 10L);
    }

    @Nullable
    public static String getServerAddress() {
        return AS4ServerConfiguration.getSettings().getAsString("server.address");
    }

    static {
        AS4ServerConfiguration.reinit(false);
    }
}

