/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.mgr;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.phase4.servlet.spi.IAS4ServletMessageProcessorSPI;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AS4ServletMessageProcessorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4ServletMessageProcessorManager.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsList<IAS4ServletMessageProcessorSPI> s_aProcessors = new CommonsArrayList<IAS4ServletMessageProcessorSPI>();

    private AS4ServletMessageProcessorManager() {
    }

    public static void reinitProcessors() {
        ICommonsList<IAS4ServletMessageProcessorSPI> iCommonsList = ServiceLoaderHelper.getAllSPIImplementations(IAS4ServletMessageProcessorSPI.class);
        if (iCommonsList.isEmpty()) {
            LOGGER.warn("No AS4 message processor is registered. All incoming messages will be discarded!");
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found " + iCommonsList.size() + " AS4 message processors");
        }
        s_aRWLock.writeLockedGet(() -> s_aProcessors.setAll((Iterable<IAS4ServletMessageProcessorSPI>)iCommonsList));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IAS4ServletMessageProcessorSPI> getAllProcessors() {
        return s_aRWLock.readLockedGet(s_aProcessors::getClone);
    }

    static {
        AS4ServletMessageProcessorManager.reinitProcessors();
    }
}

