/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.mgr;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.phase4.servlet.spi.IAS4ServletPullRequestProcessorSPI;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class AS4ServletPullRequestProcessorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4ServletPullRequestProcessorManager.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static final ICommonsList<IAS4ServletPullRequestProcessorSPI> s_aProcessors = new CommonsArrayList<IAS4ServletPullRequestProcessorSPI>();

    private AS4ServletPullRequestProcessorManager() {
    }

    public static void reinitProcessors() {
        ICommonsList<IAS4ServletPullRequestProcessorSPI> iCommonsList = ServiceLoaderHelper.getAllSPIImplementations(IAS4ServletPullRequestProcessorSPI.class);
        if (iCommonsList.isEmpty()) {
            LOGGER.warn("No AS4 message processor is registered. All incoming pull requests will be discarded!");
        } else {
            LOGGER.info("Found " + iCommonsList.size() + " AS4 pull requests processors");
        }
        s_aRWLock.writeLockedGet(() -> s_aProcessors.setAll((Iterable<IAS4ServletPullRequestProcessorSPI>)iCommonsList));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IAS4ServletPullRequestProcessorSPI> getAllProcessors() {
        return s_aRWLock.readLockedGet(s_aProcessors::getClone);
    }

    static {
        AS4ServletPullRequestProcessorManager.reinitProcessors();
    }
}

