/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.soap;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.jaxb.validation.CollectingValidationEventHandler;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.ebms3header.Ebms3CollaborationInfo;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3Messaging;
import com.helger.phase4.ebms3header.Ebms3PartInfo;
import com.helger.phase4.ebms3header.Ebms3PartyId;
import com.helger.phase4.ebms3header.Ebms3PayloadInfo;
import com.helger.phase4.ebms3header.Ebms3Property;
import com.helger.phase4.ebms3header.Ebms3PullRequest;
import com.helger.phase4.ebms3header.Ebms3Receipt;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.error.EEbmsError;
import com.helger.phase4.marshaller.Ebms3ReaderBuilder;
import com.helger.phase4.messaging.domain.MessageHelperMethods;
import com.helger.phase4.mgr.MetaAS4Manager;
import com.helger.phase4.model.mpc.IMPC;
import com.helger.phase4.model.mpc.IMPCManager;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.model.pmode.resolve.IPModeResolver;
import com.helger.phase4.servlet.AS4MessageState;
import com.helger.phase4.servlet.mgr.AS4ServerConfiguration;
import com.helger.phase4.servlet.mgr.AS4ServletPullRequestProcessorManager;
import com.helger.phase4.servlet.soap.ISOAPHeaderElementProcessor;
import com.helger.phase4.servlet.spi.IAS4ServletPullRequestProcessorSPI;
import com.helger.xml.XMLHelper;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.ext.Attachment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAPHeaderElementProcessorExtractEbms3Messaging
implements ISOAPHeaderElementProcessor {
    public static final QName QNAME_MESSAGING = new QName("http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/", "Messaging");
    private static final Logger LOGGER = LoggerFactory.getLogger(SOAPHeaderElementProcessorExtractEbms3Messaging.class);
    private final IPModeResolver m_aPModeResolver;

    public SOAPHeaderElementProcessorExtractEbms3Messaging(@Nonnull IPModeResolver iPModeResolver) {
        ValueEnforcer.notNull(iPModeResolver, "PModeResolver");
        this.m_aPModeResolver = iPModeResolver;
    }

    private static boolean _isUseLeg1(@Nonnull Ebms3UserMessage ebms3UserMessage) {
        String string = ebms3UserMessage.getMessageInfo().getMessageId();
        String string2 = ebms3UserMessage.getMessageInfo().getRefToMessageId();
        if (StringHelper.hasText(string2) && string.equals(string2)) {
            LOGGER.warn("MessageID and ReferenceToMessageID are the same (" + string + ")!");
        }
        return StringHelper.hasNoText(string2) || string2.equals(string);
    }

    @Nullable
    private static String _getMPCIDOfUserMsg(@Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull PModeLeg pModeLeg) {
        String string = ebms3UserMessage.getMpc();
        if (string == null && pModeLeg.getBusinessInfo() != null) {
            string = pModeLeg.getBusinessInfo().getMPCID();
        }
        return string;
    }

    @Nonnull
    private static ESuccess _checkMPCOfPMode(@Nonnull PModeLeg pModeLeg, @Nonnull IMPCManager iMPCManager, @Nonnull Locale locale, @Nonnull ErrorList errorList) {
        String string;
        if (pModeLeg.getBusinessInfo() != null && (string = pModeLeg.getBusinessInfo().getMPCID()) != null && !iMPCManager.containsWithID(string)) {
            LOGGER.error("Error processing the usermessage, PMode-MPC ID '" + string + "' is invalid!");
            errorList.add(EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.getAsError(locale));
            return ESuccess.FAILURE;
        }
        return ESuccess.SUCCESS;
    }

    private static boolean _checkSOAPBodyHasPayload(@Nonnull PModeLeg pModeLeg, @Nonnull Document document) {
        Element element = XMLHelper.getFirstChildElementOfName(document.getFirstChild(), pModeLeg.getProtocol().getSoapVersion().getBodyElementName());
        return element != null && element.hasChildNodes();
    }

    @Override
    @Nonnull
    public ESuccess processHeaderElement(@Nonnull Document document, @Nonnull Element element, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4MessageState aS4MessageState, @Nonnull ErrorList errorList) {
        IMPCManager iMPCManager = MetaAS4Manager.getMPCMgr();
        IPMode iPMode = null;
        CommonsHashMap<String, EAS4CompressionMode> commonsHashMap = new CommonsHashMap<String, EAS4CompressionMode>();
        IMPC iMPC = null;
        String string = null;
        String string2 = null;
        Locale locale = aS4MessageState.getLocale();
        CollectingValidationEventHandler collectingValidationEventHandler = new CollectingValidationEventHandler();
        Ebms3Messaging ebms3Messaging = (Ebms3Messaging)((Ebms3ReaderBuilder)Ebms3ReaderBuilder.ebms3Messaging().setValidationEventHandler(collectingValidationEventHandler)).read(element);
        if (ebms3Messaging == null) {
            for (IError iError : collectingValidationEventHandler.getErrorList()) {
                errorList.add(((SingleError.SingleErrorBuilder)SingleError.builder(iError).setErrorID(EEbmsError.EBMS_INVALID_HEADER.getErrorCode())).build());
            }
            return ESuccess.FAILURE;
        }
        aS4MessageState.setMessaging(ebms3Messaging);
        int n = ebms3Messaging.getUserMessageCount();
        if (n > 1) {
            LOGGER.error("Too many UserMessage objects (" + n + ") contained.");
            errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
            return ESuccess.FAILURE;
        }
        int n2 = ebms3Messaging.getSignalMessageCount();
        if (n2 > 1) {
            LOGGER.error("Too many SignalMessage objects (" + n2 + ") contained.");
            errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
            return ESuccess.FAILURE;
        }
        if (n + n2 == 0) {
            LOGGER.error("Neither UserMessage nor SignalMessage object contained.");
            errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
            return ESuccess.FAILURE;
        }
        Ebms3UserMessage ebms3UserMessage = CollectionHelper.getAtIndex(ebms3Messaging.getUserMessage(), 0);
        if (ebms3UserMessage != null) {
            Object object;
            Object object2;
            List<Ebms3PartyId> list = ebms3UserMessage.getPartyInfo().getFrom().getPartyId();
            List<Ebms3PartyId> list2 = ebms3UserMessage.getPartyInfo().getTo().getPartyId();
            if (list.size() > 1 || list2.size() > 1) {
                LOGGER.error("More than one partyId is containted in From or To Recipient please check the message.");
                errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                return ESuccess.FAILURE;
            }
            string = list.get(0).getValue();
            string2 = list2.get(0).getValue();
            Ebms3CollaborationInfo ebms3CollaborationInfo = ebms3UserMessage.getCollaborationInfo();
            if (ebms3CollaborationInfo != null) {
                object2 = null;
                if (ebms3CollaborationInfo.getAgreementRef() != null) {
                    object2 = ebms3CollaborationInfo.getAgreementRef().getPmode();
                }
                object = AS4ServerConfiguration.getServerAddress();
                iPMode = this.m_aPModeResolver.getPModeOfID((String)object2, ebms3CollaborationInfo.getService().getValue(), ebms3CollaborationInfo.getAction(), string, string2, (String)object);
                if (iPMode == null) {
                    LOGGER.error("Failed to resolve PMode '" + (String)object2 + "' using resolver " + this.m_aPModeResolver);
                    errorList.add(EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            }
            object2 = null;
            object = null;
            boolean bl = false;
            if (iPMode != null) {
                int n3;
                object2 = iPMode.getLeg1();
                object = iPMode.getLeg2();
                if (iPMode.getMEPBinding().getRequiredLegs() == 2 && object == null) {
                    LOGGER.error("Error processing the UserMessage, PMode does not contain leg 2.");
                    errorList.add(EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                boolean bl2 = SOAPHeaderElementProcessorExtractEbms3Messaging._isUseLeg1(ebms3UserMessage);
                Object object3 = bl2 ? object2 : object;
                int n4 = n3 = bl2 ? 1 : 2;
                if (object3 == null) {
                    LOGGER.error("Error processing the UserMessage, PMode does not contain effective leg " + n3 + ".");
                    errorList.add(EEbmsError.EBMS_PROCESSING_MODE_MISMATCH.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                aS4MessageState.setEffectivePModeLeg(n3, (PModeLeg)object3);
                if (SOAPHeaderElementProcessorExtractEbms3Messaging._checkMPCOfPMode((PModeLeg)object3, iMPCManager, locale, errorList).isFailure()) {
                    return ESuccess.FAILURE;
                }
                bl = SOAPHeaderElementProcessorExtractEbms3Messaging._checkSOAPBodyHasPayload((PModeLeg)object3, document);
                String object4 = SOAPHeaderElementProcessorExtractEbms3Messaging._getMPCIDOfUserMsg(ebms3UserMessage, (PModeLeg)object3);
                iMPC = iMPCManager.getMPCOrDefaultOfID(object4);
                if (iMPC == null) {
                    LOGGER.error("Error processing the UserMessage, effective MPC ID '" + object4 + "' is unknown!");
                    errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            }
            aS4MessageState.setSoapBodyPayloadPresent(bl);
            Ebms3PayloadInfo ebms3PayloadInfo = ebms3UserMessage.getPayloadInfo();
            if (ebms3PayloadInfo == null || ebms3PayloadInfo.getPartInfo().isEmpty()) {
                if (bl) {
                    LOGGER.error("No PartInfo is specified, so no SOAP body payload is allowed.");
                    errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                if (iCommonsList.isNotEmpty()) {
                    LOGGER.error("No PartInfo is specified, so no attachments are allowed.");
                    errorList.add(EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            } else {
                if (iCommonsList.size() > ebms3PayloadInfo.getPartInfoCount()) {
                    LOGGER.error("Error processing the UserMessage, the amount of specified attachments does not correlate with the actual attachments in the UserMessage. Expected " + ebms3PayloadInfo.getPartInfoCount() + " but having " + iCommonsList.size() + " attachments.");
                    errorList.add(EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                int n5 = 0;
                for (Ebms3PartInfo ebms3PartInfo : ebms3PayloadInfo.getPartInfo()) {
                    if (StringHelper.hasNoText(ebms3PartInfo.getHref())) {
                        if (bl) continue;
                        LOGGER.error("Error processing the UserMessage, Expected a BodyPayload but there is none present. ");
                        errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                        return ESuccess.FAILURE;
                    }
                    ++n5;
                    String string3 = StringHelper.trimStart(ebms3PartInfo.getHref(), MessageHelperMethods.PREFIX_CID);
                    WSS4JAttachment wSS4JAttachment2 = iCommonsList.findFirst(wSS4JAttachment -> EqualsHelper.equals(wSS4JAttachment.getId(), string3));
                    if (wSS4JAttachment2 == null) {
                        LOGGER.warn("Failed to resolve MIME attachment '" + string3 + "' in list of " + iCommonsList.getAllMapped(Attachment::getId));
                    }
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (ebms3PartInfo.getPartProperties() != null) {
                        for (Ebms3Property ebms3Property : ebms3PartInfo.getPartProperties().getProperty()) {
                            Object object3;
                            String string4 = ebms3Property.getName();
                            String string5 = ebms3Property.getValue();
                            if (string4.equalsIgnoreCase("MimeType")) {
                                bl2 = StringHelper.hasText(string5);
                                continue;
                            }
                            if (string4.equalsIgnoreCase("CompressionType")) {
                                object3 = EAS4CompressionMode.getFromMimeTypeStringOrNull(string5);
                                if (object3 == null) {
                                    LOGGER.error("Error processing the UserMessage, CompressionType '" + string5 + "' of attachment '" + string3 + "' is not supported.");
                                    errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                                    return ESuccess.FAILURE;
                                }
                                commonsHashMap.put(string3, object3);
                                bl3 = true;
                                continue;
                            }
                            if (!string4.equalsIgnoreCase("CharacterSet") || !StringHelper.hasText(string5)) continue;
                            object3 = CharsetHelper.getCharsetFromNameOrNull(string5);
                            if (object3 == null) {
                                LOGGER.error("Value '" + string5 + "' of property '" + "CharacterSet" + "' of attachment '" + string3 + "' is not supported");
                                errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                                return ESuccess.FAILURE;
                            }
                            if (wSS4JAttachment2 == null) continue;
                            wSS4JAttachment2.setCharset((Charset)object3);
                        }
                    }
                    if (!bl3 || bl2) continue;
                    LOGGER.error("Error processing the UserMessage, MimeType for a compressed attachment ('" + string3 + "') is not present.");
                    errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                if (n5 != iCommonsList.size()) {
                    LOGGER.error("Error processing the UserMessage, the amount of specified attachments does not correlate with the actual attachments in the UserMessage. Expected " + ebms3PayloadInfo.getPartInfoCount() + " but having " + iCommonsList.size() + " attachments.");
                    errorList.add(EEbmsError.EBMS_EXTERNAL_PAYLOAD_ERROR.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            }
        } else {
            Ebms3SignalMessage ebms3SignalMessage = ebms3Messaging.getSignalMessageAtIndex(0);
            Ebms3PullRequest ebms3PullRequest = ebms3SignalMessage.getPullRequest();
            Ebms3Receipt ebms3Receipt = ebms3SignalMessage.getReceipt();
            if (ebms3PullRequest != null) {
                IMPC iMPC2 = iMPCManager.getMPCOfID(ebms3PullRequest.getMpc());
                if (iMPC2 == null) {
                    errorList.add(EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                for (IAS4ServletPullRequestProcessorSPI iAS4ServletPullRequestProcessorSPI : AS4ServletPullRequestProcessorManager.getAllProcessors()) {
                    iPMode = iAS4ServletPullRequestProcessorSPI.processAS4UserMessage(ebms3SignalMessage);
                    if (iPMode == null) continue;
                    LOGGER.info("Found P-Mode '" + (String)iPMode.getID() + "' for signal message " + ebms3SignalMessage);
                    break;
                }
                if (iPMode == null) {
                    errorList.add(EEbmsError.EBMS_VALUE_NOT_RECOGNIZED.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            } else if (ebms3Receipt != null) {
                if (StringHelper.hasNoText(ebms3SignalMessage.getMessageInfo().getRefToMessageId())) {
                    errorList.add(EEbmsError.EBMS_INVALID_RECEIPT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            } else if (!ebms3SignalMessage.getError().isEmpty()) {
                for (Ebms3Error ebms3Error : ebms3SignalMessage.getError()) {
                }
            }
        }
        aS4MessageState.setPMode(iPMode);
        aS4MessageState.setOriginalSoapDocument(document);
        aS4MessageState.setOriginalAttachments(iCommonsList);
        aS4MessageState.setCompressedAttachmentIDs(commonsHashMap);
        aS4MessageState.setMPC(iMPC);
        aS4MessageState.setInitiatorID(string);
        aS4MessageState.setResponderID(string2);
        return ESuccess.SUCCESS;
    }
}

