/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.servlet.soap;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.attachment.WSS4JAttachmentCallbackHandler;
import com.helger.phase4.crypto.ECryptoAlgorithmSign;
import com.helger.phase4.crypto.ECryptoAlgorithmSignDigest;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.error.EEbmsError;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.leg.PModeLeg;
import com.helger.phase4.servlet.AS4MessageState;
import com.helger.phase4.servlet.soap.ISOAPHeaderElementProcessor;
import com.helger.phase4.servlet.soap.KeyStoreCallbackHandler;
import com.helger.xml.XMLHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAPHeaderElementProcessorWSS4J
implements ISOAPHeaderElementProcessor {
    public static final QName QNAME_SECURITY = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private static final Logger LOGGER = LoggerFactory.getLogger(SOAPHeaderElementProcessorWSS4J.class);
    private final IAS4CryptoFactory m_aCryptoFactory;
    private final IPMode m_aFallbackPMode;

    public SOAPHeaderElementProcessorWSS4J(@Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nullable IPMode iPMode) {
        ValueEnforcer.notNull(iAS4CryptoFactory, "aCryptoFactory");
        this.m_aCryptoFactory = iAS4CryptoFactory;
        this.m_aFallbackPMode = iPMode;
    }

    @Override
    @Nonnull
    public ESuccess processHeaderElement(@Nonnull Document document, @Nonnull Element element, @Nonnull ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull AS4MessageState aS4MessageState, @Nonnull ErrorList errorList) {
        IPMode iPMode = aS4MessageState.getPMode();
        if (iPMode == null) {
            iPMode = this.m_aFallbackPMode;
        }
        if (iPMode == null) {
            throw new IllegalStateException("No PMode contained in AS4 state - seems like Ebms3 Messaging header is missing!");
        }
        Locale locale = aS4MessageState.getLocale();
        PModeLeg pModeLeg = iPMode.getLeg1();
        Ebms3UserMessage ebms3UserMessage = aS4MessageState.getEbmsUserMessage();
        if (ebms3UserMessage != null && StringHelper.hasText(ebms3UserMessage.getMessageInfo().getRefToMessageId())) {
            pModeLeg = iPMode.getLeg2();
        }
        if (pModeLeg.getSecurity() != null) {
            Object object;
            Object object2;
            Object object3;
            Element element2 = XMLHelper.getFirstChildElementOfName(element, "http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (element2 != null) {
                object3 = XMLHelper.getFirstChildElementOfName(element2 = XMLHelper.getFirstChildElementOfName(element2, "http://www.w3.org/2000/09/xmldsig#", "SignedInfo"), "http://www.w3.org/2000/09/xmldsig#", "SignatureMethod");
                String string = object3 == null ? null : object3.getAttribute("Algorithm");
                object2 = ECryptoAlgorithmSign.getFromURIOrNull(string);
                if (object2 == null) {
                    LOGGER.error("Error processing the Security Header, your signing algorithm '" + string + "' is incorrect. Expected one of the following '" + Arrays.asList(ECryptoAlgorithmSign.values()) + "' algorithms");
                    errorList.add(EEbmsError.EBMS_FAILED_AUTHENTICATION.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using signature algorithm " + object2);
                }
                element2 = XMLHelper.getFirstChildElementOfName(element2, "http://www.w3.org/2000/09/xmldsig#", "Reference");
                string = (element2 = XMLHelper.getFirstChildElementOfName(element2, "http://www.w3.org/2000/09/xmldsig#", "DigestMethod")) == null ? null : element2.getAttribute("Algorithm");
                object = ECryptoAlgorithmSignDigest.getFromURIOrNull(string);
                if (object == null) {
                    LOGGER.error("Error processing the Security Header, your signing digest algorithm is incorrect. Expected one of the following'" + Arrays.toString(ECryptoAlgorithmSignDigest.values()) + "' algorithms");
                    errorList.add(EEbmsError.EBMS_FAILED_AUTHENTICATION.getAsError(locale));
                    return ESuccess.FAILURE;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using signature digest algorithm " + object);
                }
            }
            if (ebms3UserMessage != null) {
                boolean bl = aS4MessageState.isSoapBodyPayloadPresent();
                for (int i = 0; i < iCommonsList.size(); ++i) {
                    object2 = ((WSS4JAttachment)iCommonsList.get(i)).getHeaders().get("Content-ID");
                    if (StringHelper.hasNoText((String)object2)) {
                        LOGGER.error("The provided attachment ID in the 'Content-ID' header may not be empty.");
                        errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                        return ESuccess.FAILURE;
                    }
                    if (!((String)object2).startsWith("<attachment=")) {
                        LOGGER.error("The provided attachment ID '" + (String)object2 + "' in the 'Content-ID' header does not start with the required prefix '" + "<attachment=" + "'");
                        errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                        return ESuccess.FAILURE;
                    }
                    if (!((String)object2).endsWith(">")) {
                        LOGGER.error("The provided attachment ID '" + (String)object2 + "' in the 'Content-ID' header does not end with the required suffix '" + ">" + "'");
                        errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                        return ESuccess.FAILURE;
                    }
                    object2 = ((String)object2).substring("<attachment=".length(), ((String)object2).length() - ">".length());
                    object = ebms3UserMessage.getPayloadInfo().getPartInfoAtIndex((bl ? 1 : 0) + i).getHref();
                    if (((String)object).contains((CharSequence)object2)) continue;
                    LOGGER.error("The usermessage part information '" + (String)object + "' does not reference the respective attachment ID '" + (String)object2 + "'");
                    errorList.add(EEbmsError.EBMS_VALUE_INCONSISTENT.getAsError(locale));
                    return ESuccess.FAILURE;
                }
            }
            try {
                Object object4;
                Serializable serializable;
                object3 = new KeyStoreCallbackHandler(this.m_aCryptoFactory);
                WSS4JAttachmentCallbackHandler wSS4JAttachmentCallbackHandler = new WSS4JAttachmentCallbackHandler(iCommonsList, aS4MessageState.getResourceHelper());
                object2 = new RequestData();
                ((RequestData)object2).setCallbackHandler((CallbackHandler)object3);
                if (iCommonsList.isNotEmpty()) {
                    ((RequestData)object2).setAttachmentCallbackHandler(wSS4JAttachmentCallbackHandler);
                }
                ((RequestData)object2).setSigVerCrypto(this.m_aCryptoFactory.getCrypto());
                ((RequestData)object2).setDecCrypto(this.m_aCryptoFactory.getCrypto());
                ((RequestData)object2).setWssConfig(this.m_aCryptoFactory.createWSSConfig());
                object = new WSSecurityEngine();
                WSHandlerResult wSHandlerResult = ((WSSecurityEngine)object).processSecurityHeader(document, (RequestData)object2);
                List<WSSecurityEngineResult> list = wSHandlerResult.getResults();
                CommonsHashSet commonsHashSet = new CommonsHashSet();
                Serializable serializable3 = null;
                int n = 0;
                for (WSSecurityEngineResult serializable22 : list) {
                    Object object5;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("WSSecurityEngineResult: " + serializable22);
                    }
                    int wSS4JAttachment = (object5 = (Integer)serializable22.get("action")) != null ? (Integer)object5 : 0;
                    n |= wSS4JAttachment;
                    serializable = (X509Certificate)serializable22.get("x509-certificate");
                    if (serializable == null) continue;
                    commonsHashSet.add(serializable);
                    if (wSS4JAttachment != 4096 || serializable3 != null) continue;
                    serializable3 = serializable;
                }
                aS4MessageState.setSoapWSS4JSecurityActions(n);
                if (commonsHashSet.size() > 1) {
                    if (serializable3 == null) {
                        LOGGER.warn("Found " + commonsHashSet.size() + " different certificates in message. Using the first one.");
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("All gathered certificates: " + commonsHashSet);
                        }
                        object4 = (X509Certificate)commonsHashSet.getAtIndex(0);
                    } else {
                        object4 = serializable3;
                    }
                } else {
                    object4 = commonsHashSet.size() == 1 ? (X509Certificate)commonsHashSet.getAtIndex(0) : null;
                }
                aS4MessageState.setUsedCertificate((X509Certificate)object4);
                aS4MessageState.setDecryptedSoapDocument(document);
                ICommonsList<WSS4JAttachment> iCommonsList2 = wSS4JAttachmentCallbackHandler.getAllResponseAttachments();
                for (WSS4JAttachment wSS4JAttachment : iCommonsList2) {
                    serializable = aS4MessageState.getResourceHelper().createTempFile();
                    StreamHelper.copyInputStreamToOutputStreamAndCloseOS(wSS4JAttachment.getSourceStream(), FileHelper.getBufferedOutputStream((File)serializable));
                    wSS4JAttachment.setSourceStreamProvider(HasInputStream.multiple(() -> SOAPHeaderElementProcessorWSS4J.lambda$processHeaderElement$ac00e27d$1((File)serializable)));
                }
                aS4MessageState.setDecryptedAttachments(iCommonsList2);
            }
            catch (WSSecurityException wSSecurityException) {
                LOGGER.error("Error processing the WSSSecurity Header", wSSecurityException);
                errorList.add(EEbmsError.EBMS_FAILED_DECRYPTION.getAsError(locale));
                aS4MessageState.setSoapWSS4JException(wSSecurityException);
                return ESuccess.FAILURE;
            }
            catch (IOException iOException) {
                LOGGER.error("IO error processing the WSSSecurity Header", iOException);
                errorList.add(EEbmsError.EBMS_OTHER.getAsError(locale));
                aS4MessageState.setSoapWSS4JException(iOException);
                return ESuccess.FAILURE;
            }
        }
        return ESuccess.SUCCESS;
    }

    private static /* synthetic */ InputStream lambda$processHeaderElement$ac00e27d$1(File file) {
        return FileHelper.getBufferedInputStream(file);
    }
}

