/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.phase4.util.AS4IOHelper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.FileEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS4ResourceHelper
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS4ResourceHelper.class);
    private static File s_aTempDir;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final AtomicBoolean m_aInClose = new AtomicBoolean(false);
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<File> m_aTempFiles = new CommonsArrayList<File>();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<Closeable> m_aCloseables = new CommonsArrayList<Closeable>();

    @Nullable
    public static File getTempDir() {
        return s_aTempDir;
    }

    public static void setTempDir(@Nullable File file) {
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Temporary directory '" + file.getAbsolutePath() + "' is not a directory");
        }
        s_aTempDir = file;
    }

    @Nonnull
    public File createTempFile() throws IOException {
        if (this.m_aInClose.get()) {
            throw new IllegalStateException("ResourceManager is already closing/closed!");
        }
        File file = File.createTempFile("phase4-res-", ".tmp", s_aTempDir);
        this.m_aRWLock.writeLockedBoolean(() -> this.m_aTempFiles.add(file));
        return file;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<File> getAllTempFiles() {
        return this.m_aRWLock.readLockedGet(this.m_aTempFiles::getClone);
    }

    public void addCloseable(@Nonnull Closeable closeable) {
        ValueEnforcer.notNull(closeable, "Closeable");
        if (this.m_aInClose.get()) {
            throw new IllegalStateException("AS4ResourceHelper is already closing/closed!");
        }
        this.m_aCloseables.add(closeable);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Closeable> getAllCloseables() {
        return this.m_aRWLock.readLockedGet(this.m_aCloseables::getClone);
    }

    @Override
    public void close() {
        if (!this.m_aInClose.getAndSet(true)) {
            Object object;
            Object object2;
            ICommonsList iCommonsList = this.m_aRWLock.writeLockedGet(() -> {
                ICommonsList iCommonsList = (ICommonsList)this.m_aCloseables.getClone();
                this.m_aCloseables.clear();
                return iCommonsList;
            });
            if (iCommonsList.isNotEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Closing " + iCommonsList.size() + " " + "phase4" + " stream handles");
                }
                object2 = iCommonsList.iterator();
                while (object2.hasNext()) {
                    object = (Closeable)object2.next();
                    StreamHelper.close((AutoCloseable)object);
                }
            }
            if ((object2 = this.m_aRWLock.writeLockedGet(() -> {
                ICommonsList iCommonsList = (ICommonsList)this.m_aTempFiles.getClone();
                this.m_aTempFiles.clear();
                return iCommonsList;
            })).isNotEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Deleting " + object2.size() + " temporary " + "phase4" + " files");
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    FileIOError fileIOError;
                    File file = (File)object.next();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Deleting temporary file '" + file.getAbsolutePath() + "'");
                    }
                    if (!(fileIOError = AS4IOHelper.getFileOperationManager().deleteFileIfExisting(file)).isFailure()) continue;
                    LOGGER.warn("  Failed to delete temporary phase4 file " + file.getAbsolutePath() + ": " + fileIOError.toString());
                }
            }
        }
    }

    @Nonnull
    public HttpEntity createRepeatableHttpEntity(@Nonnull HttpEntity httpEntity) throws IOException {
        ValueEnforcer.notNull(httpEntity, "SrcEntity");
        if (httpEntity.isRepeatable()) {
            return httpEntity;
        }
        File file = this.createTempFile();
        LOGGER.info("Converting " + httpEntity + " to a repeatable HTTP entity using file " + file.getAbsolutePath());
        try (Object object = FileHelper.getBufferedOutputStream(file);){
            httpEntity.writeTo((OutputStream)object);
        }
        object = new FileEntity(file);
        ((AbstractHttpEntity)object).setContentType(httpEntity.getContentType());
        ((AbstractHttpEntity)object).setContentEncoding(httpEntity.getContentEncoding());
        ((AbstractHttpEntity)object).setChunked(httpEntity.isChunked());
        return object;
    }
}

