/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.ajax;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.timing.StopWatch;
import com.helger.photon.ajax.AjaxSettings;
import com.helger.photon.ajax.IAjaxInvoker;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class AjaxInvoker
implements IAjaxInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AjaxInvoker.class);
    private static final IMutableStatisticsHandlerCounter s_aStatsGlobalInvoke = StatisticsManager.getCounterHandler(AjaxInvoker.class.getName() + "$invocations");
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsFunctionInvoke = StatisticsManager.getKeyedCounterHandler(AjaxInvoker.class.getName() + "$func");
    private static final IMutableStatisticsHandlerKeyedTimer s_aStatsFunctionTimer = StatisticsManager.getKeyedTimerHandler(AjaxInvoker.class.getName() + "$timer");

    @Override
    public void invokeFunction(@Nonnull String string, @Nonnull IAjaxExecutor iAjaxExecutor, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull PhotonUnifiedResponse photonUnifiedResponse) throws Exception {
        ValueEnforcer.notNull(string, "FunctionName");
        ValueEnforcer.notNull(iAjaxExecutor, "AjaxExecutor");
        ValueEnforcer.notNull(iRequestWebScopeWithoutResponse, "RequestScope");
        ValueEnforcer.notNull(photonUnifiedResponse, "AjaxResponse");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invoking Ajax function '" + string + "'");
        }
        try {
            StopWatch stopWatch = StopWatch.createdStarted();
            s_aStatsGlobalInvoke.increment();
            AjaxSettings.beforeExecutionCallbacks().forEach(iAjaxBeforeExecutionCallback -> iAjaxBeforeExecutionCallback.onBeforeExecution(this, string, iRequestWebScopeWithoutResponse, iAjaxExecutor));
            iAjaxExecutor.registerExternalResources();
            iAjaxExecutor.handleRequest(iRequestWebScopeWithoutResponse, photonUnifiedResponse);
            AjaxSettings.afterExecutionCallbacks().forEach(iAjaxAfterExecutionCallback -> iAjaxAfterExecutionCallback.onAfterExecution(this, string, iRequestWebScopeWithoutResponse, iAjaxExecutor, photonUnifiedResponse));
            s_aStatsFunctionInvoke.increment(string);
            long l = stopWatch.stopAndGetMillis();
            s_aStatsFunctionTimer.addTime(string, l);
            long l2 = AjaxSettings.getLongRunningExecutionLimitTime();
            if (l2 > 0L && l > l2) {
                AjaxSettings.longRunningExecutionCallbacks().forEach(iAjaxLongRunningExecutionCallback -> iAjaxLongRunningExecutionCallback.onLongRunningExecution(this, string, iRequestWebScopeWithoutResponse, iAjaxExecutor, l));
            }
        }
        catch (Exception exception) {
            AjaxSettings.exceptionCallbacks().forEach(iAjaxExceptionCallback -> iAjaxExceptionCallback.onAjaxExecutionException(this, string, iAjaxExecutor, iRequestWebScopeWithoutResponse, exception));
            throw exception;
        }
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

