/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.ajax;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.ajax.AjaxInvoker;
import com.helger.photon.ajax.AjaxRegistry;
import com.helger.photon.ajax.IAjaxInvoker;
import com.helger.photon.ajax.IAjaxRegistry;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class GlobalAjaxInvoker
extends AbstractGlobalWebSingleton {
    private IAjaxRegistry m_aRegistry = new AjaxRegistry();
    private IAjaxInvoker m_aInvoker = new AjaxInvoker();

    @Deprecated
    @UsedViaReflection
    public GlobalAjaxInvoker() {
    }

    @Nonnull
    public static GlobalAjaxInvoker getInstance() {
        return GlobalAjaxInvoker.getGlobalSingleton(GlobalAjaxInvoker.class);
    }

    public void resetToDefault() {
        this.m_aRegistry = new AjaxRegistry();
        this.m_aInvoker = new AjaxInvoker();
    }

    @Nonnull
    public IAjaxRegistry getRegistry() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aRegistry);
    }

    @Nonnull
    public void setRegistry(@Nonnull IAjaxRegistry iAjaxRegistry) {
        ValueEnforcer.notNull(iAjaxRegistry, "Registry");
        if (this.m_aRWLock.readLockedBoolean(() -> this.m_aRegistry.getAllRegisteredFunctions().isNotEmpty())) {
            throw new IllegalStateException("Cannot change the registry after a function was already registered!");
        }
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_aRegistry = iAjaxRegistry;
            return this.m_aRegistry;
        });
    }

    @Nonnull
    public IAjaxInvoker getInvoker() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aInvoker);
    }

    @Nonnull
    public void setInvoker(@Nonnull IAjaxInvoker iAjaxInvoker) {
        ValueEnforcer.notNull(iAjaxInvoker, "Invoker");
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_aInvoker = iAjaxInvoker;
            return this.m_aInvoker;
        });
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Registry", this.m_aRegistry).append("Invoker", this.m_aInvoker).getToString();
    }
}

