/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.ajax.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.factory.FactoryNewInstance;
import com.helger.commons.functional.IPredicate;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.ajax.AjaxRegistry;
import com.helger.photon.ajax.decl.IAjaxFunctionDeclaration;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AjaxFunctionDeclaration
implements IAjaxFunctionDeclaration {
    private final String m_sFunctionName;
    private final ISupplier<? extends IAjaxExecutor> m_aExecutorFactory;
    private final IPredicate<? super IRequestWebScopeWithoutResponse> m_aExecutionFilter;
    private final String m_sServletPath;
    private static final AtomicInteger s_aFunCounter = new AtomicInteger(0);

    public AjaxFunctionDeclaration(@Nonnull @Nonempty String string, @Nonnull ISupplier<? extends IAjaxExecutor> iSupplier, @Nullable IPredicate<? super IRequestWebScopeWithoutResponse> iPredicate, @Nonnull @Nonempty String string2) {
        ValueEnforcer.isTrue(AjaxRegistry.isValidFunctionName(string), "Invalid Ajax functionName provided");
        ValueEnforcer.notNull(iSupplier, "ExecutorFactory");
        ValueEnforcer.notEmpty(string2, "ServletPath");
        ValueEnforcer.isTrue(string2.startsWith("/"), "Servlet path must start with /");
        ValueEnforcer.isTrue(string2.endsWith("/"), "Servlet path must end with /");
        this.m_sFunctionName = string;
        this.m_aExecutorFactory = iSupplier;
        this.m_aExecutionFilter = iPredicate;
        this.m_sServletPath = string2;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sFunctionName;
    }

    @Override
    @Nonnull
    public final ISupplier<? extends IAjaxExecutor> getExecutorFactory() {
        return this.m_aExecutorFactory;
    }

    @Override
    @Nullable
    public final IPredicate<? super IRequestWebScopeWithoutResponse> getExecutionFilter() {
        return this.m_aExecutionFilter;
    }

    @Override
    public boolean canExecute(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        if (this.m_aExecutionFilter == null) {
            return true;
        }
        return this.m_aExecutionFilter.test(iRequestWebScopeWithoutResponse);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAjaxServletPath() {
        return this.m_sServletPath;
    }

    public String toString() {
        return new ToStringGenerator(this).append("FunctionName", this.m_sFunctionName).append("ExecutorFactory", this.m_aExecutorFactory).appendIfNotNull("ExecutorFilter", this.m_aExecutionFilter).appendIfNotNull("ServletPath", this.m_sServletPath).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return AjaxFunctionDeclaration.builder(null);
    }

    public static int getUniqueFunctionID() {
        return s_aFunCounter.incrementAndGet();
    }

    @Nonnull
    public static Builder builder(@Nullable String string) {
        String string2 = StringHelper.hasText(string) ? string : "fun" + AjaxFunctionDeclaration.getUniqueFunctionID();
        return new Builder(string2);
    }

    public static class Builder {
        private final String m_sFunctionName;
        private ISupplier<? extends IAjaxExecutor> m_aExecutorFactory;
        private IPredicate<? super IRequestWebScopeWithoutResponse> m_aExecutionFilter;
        private String m_sServletPath = "/ajax/";

        public Builder(@Nonnull @Nonempty String string) {
            ValueEnforcer.notEmpty(string, "FunctionName");
            this.m_sFunctionName = string;
        }

        @Nonnull
        public final Builder withExecutor(@Nonnull IAjaxExecutor iAjaxExecutor) {
            ValueEnforcer.notNull(iAjaxExecutor, "AjaxExecutor");
            return this.withExecutor(() -> iAjaxExecutor);
        }

        @Nonnull
        public final Builder withExecutor(@Nonnull Class<? extends IAjaxExecutor> clazz) {
            return this.withExecutor(FactoryNewInstance.create(clazz));
        }

        @Nonnull
        public final Builder withExecutor(@Nonnull ISupplier<? extends IAjaxExecutor> iSupplier) {
            ValueEnforcer.notNull(iSupplier, "Supplier");
            this.m_aExecutorFactory = iSupplier;
            return this;
        }

        @Nonnull
        public final Builder withFilter(@Nonnull IPredicate<? super IRequestWebScopeWithoutResponse> iPredicate) {
            ValueEnforcer.notNull(iPredicate, "Filter");
            this.m_aExecutionFilter = iPredicate;
            return this;
        }

        @Nonnull
        public final Builder withServletPath(@Nonnull @Nonempty String string) {
            ValueEnforcer.notEmpty(string, "ServletPath");
            ValueEnforcer.isTrue(string.startsWith("/"), "Servlet path must start with /");
            ValueEnforcer.isTrue(string.endsWith("/"), "Servlet path must end with /");
            this.m_sServletPath = string;
            return this;
        }

        @Nonnull
        public AjaxFunctionDeclaration build() {
            return new AjaxFunctionDeclaration(this.m_sFunctionName, this.m_aExecutorFactory, this.m_aExecutionFilter, this.m_sServletPath);
        }
    }
}

