/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.ajax.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.commons.wrapper.Wrapper;
import com.helger.http.EHttpVersion;
import com.helger.photon.ajax.GlobalAjaxInvoker;
import com.helger.photon.ajax.IAjaxInvoker;
import com.helger.photon.ajax.IAjaxRegistry;
import com.helger.photon.ajax.decl.IAjaxFunctionDeclaration;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AjaxXServletHandler
implements IXServletSimpleHandler {
    public static final String REQUEST_PARAM_JQUERY_NO_CACHE = "_";
    private static final Logger LOGGER = LoggerFactory.getLogger(AjaxXServletHandler.class);
    private static final String SCOPE_ATTR_NAME = "$ph-ajaxservlet.name";
    private static final String SCOPE_ATTR_INVOKER = "$ph-ajaxservlet.invoker";
    private static final String SCOPE_ATTR_EXECUTOR = "$ph-ajaxservlet.executor";
    private final ISupplier<? extends IAjaxRegistry> m_aRegistryFactory;
    private final ISupplier<? extends IAjaxInvoker> m_aInvokerFactory;

    public AjaxXServletHandler() {
        this(() -> GlobalAjaxInvoker.getInstance().getRegistry(), () -> GlobalAjaxInvoker.getInstance().getInvoker());
    }

    public AjaxXServletHandler(@Nonnull ISupplier<? extends IAjaxRegistry> iSupplier, @Nonnull ISupplier<? extends IAjaxInvoker> iSupplier2) {
        this.m_aRegistryFactory = ValueEnforcer.notNull(iSupplier, "aRegistryFactory");
        this.m_aInvokerFactory = ValueEnforcer.notNull(iSupplier2, "InvokerFactory");
    }

    @Override
    @Nonnull
    public PhotonUnifiedResponse createUnifiedResponse(@Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull HttpServletRequest httpServletRequest, @Nonnull IRequestWebScope iRequestWebScope) {
        return new PhotonUnifiedResponse(eHttpVersion, eHttpMethod, httpServletRequest, iRequestWebScope);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    @OverrideOnDemand
    public EContinue initRequestState(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) {
        String string = iRequestWebScopeWithoutResponse.getPathWithinServlet();
        if (StringHelper.startsWith((CharSequence)string, '/')) {
            string = string.substring(1);
        }
        IAjaxRegistry iAjaxRegistry = (IAjaxRegistry)this.m_aRegistryFactory.get();
        IAjaxInvoker iAjaxInvoker = (IAjaxInvoker)this.m_aInvokerFactory.get();
        IAjaxFunctionDeclaration iAjaxFunctionDeclaration = iAjaxRegistry.getRegisteredFunction(string);
        if (iAjaxFunctionDeclaration == null) {
            LOGGER.warn("Unknown Ajax function '" + string + "' provided!");
            unifiedResponse.setStatus(404);
            return EContinue.BREAK;
        }
        if (!iAjaxFunctionDeclaration.canExecute(iRequestWebScopeWithoutResponse)) {
            LOGGER.warn("Ajax function '" + string + "' self-declined the execution for the current request.");
            unifiedResponse.setStatus(401);
            return EContinue.BREAK;
        }
        IAjaxExecutor iAjaxExecutor = iAjaxFunctionDeclaration.getExecutor();
        if (iAjaxExecutor == null) {
            LOGGER.warn("No AjaxExecutor created for declaration " + iAjaxFunctionDeclaration);
            unifiedResponse.setStatus(500);
            return EContinue.BREAK;
        }
        iAjaxExecutor.initExecution(iRequestWebScopeWithoutResponse);
        iRequestWebScopeWithoutResponse.params().remove(REQUEST_PARAM_JQUERY_NO_CACHE);
        iRequestWebScopeWithoutResponse.attrs().putIn(SCOPE_ATTR_NAME, string);
        iRequestWebScopeWithoutResponse.attrs().putIn(SCOPE_ATTR_INVOKER, new Wrapper<IAjaxInvoker>(iAjaxInvoker));
        iRequestWebScopeWithoutResponse.attrs().putIn(SCOPE_ATTR_EXECUTOR, iAjaxExecutor);
        return EContinue.CONTINUE;
    }

    @Override
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws ServletException, IOException {
        String string = iRequestWebScopeWithoutResponse.attrs().getAsString(SCOPE_ATTR_NAME);
        IAjaxInvoker iAjaxInvoker = (IAjaxInvoker)iRequestWebScopeWithoutResponse.attrs().getCastedValue(SCOPE_ATTR_INVOKER, Wrapper.class).get();
        IAjaxExecutor iAjaxExecutor = iRequestWebScopeWithoutResponse.attrs().getCastedValue(SCOPE_ATTR_EXECUTOR, IAjaxExecutor.class);
        unifiedResponse.disableCaching();
        try {
            iAjaxInvoker.invokeFunction(string, iAjaxExecutor, iRequestWebScopeWithoutResponse, (PhotonUnifiedResponse)GenericReflection.uncheckedCast(unifiedResponse));
            if (unifiedResponse.isStatusCodeDefined() || unifiedResponse.isRedirectDefined()) {
                unifiedResponse.removeCaching();
            }
        }
        catch (IOException | ServletException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ServletException("Error invoking AJAX function '" + string + "'", throwable);
        }
    }
}

