/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.timing.StopWatch;
import com.helger.photon.api.APISettings;
import com.helger.photon.api.IAPIExceptionMapper;
import com.helger.photon.api.IAPIInvoker;
import com.helger.photon.api.InvokableAPIDescriptor;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class APIInvoker
implements IAPIInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIInvoker.class);
    private static final IMutableStatisticsHandlerCounter s_aStatsGlobalInvoke = StatisticsManager.getCounterHandler(APIInvoker.class.getName() + "$invocations");
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsFunctionInvoke = StatisticsManager.getKeyedCounterHandler(APIInvoker.class.getName() + "$func");
    private static final IMutableStatisticsHandlerKeyedTimer s_aStatsFunctionTimer = StatisticsManager.getKeyedTimerHandler(APIInvoker.class.getName() + "$timer");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(@Nonnull InvokableAPIDescriptor invokableAPIDescriptor, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        ValueEnforcer.notNull(invokableAPIDescriptor, "InvokableDescriptor");
        ValueEnforcer.notNull(iRequestWebScopeWithoutResponse, "RequestScope");
        ValueEnforcer.notNull(unifiedResponse, "UnifiedResponse");
        String string = invokableAPIDescriptor.getPath();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invoking API '" + string + "'");
        }
        StopWatch stopWatch = StopWatch.createdStarted();
        try {
            s_aStatsGlobalInvoke.increment();
            APISettings.beforeExecutionCallbacks().forEach(iAPIBeforeExecutionCallback -> iAPIBeforeExecutionCallback.onBeforeExecution(this, invokableAPIDescriptor, iRequestWebScopeWithoutResponse));
            invokableAPIDescriptor.invokeAPI(iRequestWebScopeWithoutResponse, unifiedResponse);
            APISettings.afterExecutionCallbacks().forEach(iAPIAfterExecutionCallback -> iAPIAfterExecutionCallback.onAfterExecution(this, invokableAPIDescriptor, iRequestWebScopeWithoutResponse));
            s_aStatsFunctionInvoke.increment(string);
        }
        catch (Throwable throwable) {
            boolean bl = false;
            IAPIExceptionMapper iAPIExceptionMapper = invokableAPIDescriptor.getAPIDescriptor().getExceptionMapper();
            if (iAPIExceptionMapper != null) {
                bl = iAPIExceptionMapper.applyExceptionOnResponse(invokableAPIDescriptor, iRequestWebScopeWithoutResponse, unifiedResponse, throwable).isHandled();
            }
            if (!bl) {
                APISettings.exceptionCallbacks().forEach(iAPIExceptionCallback -> iAPIExceptionCallback.onAPIExecutionException(this, invokableAPIDescriptor, iRequestWebScopeWithoutResponse, throwable));
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new Exception(throwable);
            }
        }
        finally {
            long l = stopWatch.stopAndGetMillis();
            s_aStatsFunctionTimer.addTime(string, l);
            long l2 = APISettings.getLongRunningExecutionLimitTime();
            if (l2 > 0L && l > l2) {
                APISettings.longRunningExecutionCallbacks().forEach(iAPILongRunningExecutionCallback -> iAPILongRunningExecutionCallback.onLongRunningExecution(this, invokableAPIDescriptor, iRequestWebScopeWithoutResponse, l));
            }
        }
    }

    public String toString() {
        return new ToStringGenerator(super.toString()).getToString();
    }
}

