/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.SimpleURL;
import com.helger.servlet.request.RequestHelper;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public class APIPath
implements Serializable {
    private final EHttpMethod m_eHttpMethod;
    private final String m_sPath;

    public APIPath(@Nonnull EHttpMethod eHttpMethod, @Nonnull @Nonempty String string) {
        this.m_eHttpMethod = ValueEnforcer.notNull(eHttpMethod, "HttpMethod");
        this.m_sPath = ValueEnforcer.notEmpty(string, "Path");
    }

    @Deprecated
    @Nonnull
    public EHttpMethod getHTTPMethod() {
        return this.getHttpMethod();
    }

    @Nonnull
    public EHttpMethod getHttpMethod() {
        return this.m_eHttpMethod;
    }

    @Nonnull
    @Nonempty
    public String getPath() {
        return this.m_sPath;
    }

    @Nonnull
    public SimpleURL getInvocationURL(@Nonnull String string) {
        ValueEnforcer.notNull(string, "BasePath");
        return new SimpleURL(string + this.m_sPath);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        APIPath aPIPath = (APIPath)object;
        return this.m_eHttpMethod.equals(aPIPath.m_eHttpMethod) && this.m_sPath.equals(aPIPath.m_sPath);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eHttpMethod)).append(this.m_sPath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("HTTPMethod", this.m_eHttpMethod).append("Path", this.m_sPath).getToString();
    }

    @Nonnull
    public static APIPath get(@Nonnull @Nonempty String string) {
        return new APIPath(EHttpMethod.GET, string);
    }

    @Nonnull
    public static APIPath post(@Nonnull @Nonempty String string) {
        return new APIPath(EHttpMethod.POST, string);
    }

    @Nonnull
    public static APIPath put(@Nonnull @Nonempty String string) {
        return new APIPath(EHttpMethod.PUT, string);
    }

    @Nonnull
    public static APIPath delete(@Nonnull @Nonempty String string) {
        return new APIPath(EHttpMethod.DELETE, string);
    }

    @Nonnull
    public static APIPath createForFilter(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        String string = RequestHelper.getPathWithinServletContext(iRequestWebScopeWithoutResponse.getRequest(), true);
        if (string != null && !FilenameHelper.startsWithPathSeparatorChar(string)) {
            string = '/' + string;
        }
        return new APIPath(iRequestWebScopeWithoutResponse.getHttpMethod(), string);
    }

    @Nonnull
    public static APIPath createForServlet(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        String string = RequestHelper.getPathWithinServlet(iRequestWebScopeWithoutResponse.getRequest(), true);
        if (string != null && !FilenameHelper.startsWithPathSeparatorChar(string)) {
            string = '/' + string;
        }
        return new APIPath(iRequestWebScopeWithoutResponse.getHttpMethod(), string);
    }
}

