/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.api.APIDescriptor;
import com.helger.photon.api.APIDescriptorList;
import com.helger.photon.api.APIPath;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.photon.api.IAPIPathAmbiguityResolver;
import com.helger.photon.api.IAPIRegistry;
import com.helger.photon.api.InvokableAPIDescriptor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class APIRegistry
implements IAPIRegistry {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final APIDescriptorList m_aApiDecls = new APIDescriptorList();

    @Override
    public void registerAPI(@Nonnull APIDescriptor aPIDescriptor) {
        this.m_aRWLock.writeLocked(() -> this.m_aApiDecls.addDescriptor(aPIDescriptor));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IAPIDescriptor> getAllAPIDescriptors() {
        return this.m_aRWLock.readLockedGet(this.m_aApiDecls::getAllDescriptors);
    }

    @Override
    @Nullable
    public InvokableAPIDescriptor getAPIByPath(@Nonnull APIPath aPIPath, @Nonnull IAPIPathAmbiguityResolver iAPIPathAmbiguityResolver) {
        return this.m_aRWLock.readLockedGet(() -> this.m_aApiDecls.getMatching(aPIPath, iAPIPathAmbiguityResolver));
    }

    public String toString() {
        return new ToStringGenerator(this).append("APIDeclarations", this.m_aApiDecls).getToString();
    }
}

