/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.photon.api.IAPIAfterExecutionCallback;
import com.helger.photon.api.IAPIBeforeExecutionCallback;
import com.helger.photon.api.IAPIExceptionCallback;
import com.helger.photon.api.IAPILongRunningExecutionCallback;
import com.helger.photon.api.callback.LoggingAPIExceptionCallback;
import com.helger.photon.api.callback.LoggingAPILongRunningExecutionCallback;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class APISettings {
    public static final long DEFAULT_LONG_RUNNING_EXECUTION_LIMIT_MS = 1000L;
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static final CallbackList<IAPIExceptionCallback> s_aExceptionCallbacks = new CallbackList();
    private static final CallbackList<IAPIBeforeExecutionCallback> s_aBeforeExecutionCallbacks = new CallbackList();
    private static final CallbackList<IAPIAfterExecutionCallback> s_aAfterExecutionCallbacks = new CallbackList();
    @GuardedBy(value="s_aRWLock")
    private static long s_nLongRunningExecutionLimitTime = 1000L;
    private static final CallbackList<IAPILongRunningExecutionCallback> s_aLongRunningExecutionCallbacks = new CallbackList();

    private APISettings() {
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public static CallbackList<IAPIExceptionCallback> exceptionCallbacks() {
        return s_aExceptionCallbacks;
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public static CallbackList<IAPIBeforeExecutionCallback> beforeExecutionCallbacks() {
        return s_aBeforeExecutionCallbacks;
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IAPIAfterExecutionCallback> afterExecutionCallbacks() {
        return s_aAfterExecutionCallbacks;
    }

    @CheckForSigned
    public static long getLongRunningExecutionLimitTime() {
        return s_aRWLock.readLockedLong(() -> s_nLongRunningExecutionLimitTime);
    }

    public static void setLongRunningExecutionLimitTime(long l) {
        s_aRWLock.writeLockedLong(() -> {
            s_nLongRunningExecutionLimitTime = l;
            return s_nLongRunningExecutionLimitTime;
        });
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IAPILongRunningExecutionCallback> longRunningExecutionCallbacks() {
        return s_aLongRunningExecutionCallbacks;
    }

    static {
        APISettings.exceptionCallbacks().add(new LoggingAPIExceptionCallback());
        APISettings.longRunningExecutionCallbacks().add(new LoggingAPILongRunningExecutionCallback());
    }
}

