/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.api.APIInvoker;
import com.helger.photon.api.APIRegistry;
import com.helger.photon.api.IAPIInvoker;
import com.helger.photon.api.IAPIRegistry;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GlobalAPIInvoker
extends AbstractGlobalWebSingleton {
    private IAPIRegistry m_aRegistry = new APIRegistry();
    private IAPIInvoker m_aInvoker = new APIInvoker();

    @Deprecated
    @UsedViaReflection
    public GlobalAPIInvoker() {
    }

    @Nonnull
    public static GlobalAPIInvoker getInstance() {
        return GlobalAPIInvoker.getGlobalSingleton(GlobalAPIInvoker.class);
    }

    public void resetToDefault() {
        this.m_aRegistry = new APIRegistry();
        this.m_aInvoker = new APIInvoker();
    }

    @Nonnull
    public IAPIRegistry getRegistry() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aRegistry);
    }

    @Nonnull
    public void setRegistry(@Nonnull IAPIRegistry iAPIRegistry) {
        ValueEnforcer.notNull(iAPIRegistry, "Registry");
        if (this.m_aRWLock.readLockedBoolean(() -> this.m_aRegistry.getAllAPIDescriptors().isNotEmpty())) {
            throw new IllegalStateException("Cannot change the registry after an API was registered!");
        }
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_aRegistry = iAPIRegistry;
            return this.m_aRegistry;
        });
    }

    @Nonnull
    public IAPIInvoker getInvoker() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aInvoker);
    }

    @Nonnull
    public void setInvoker(@Nonnull IAPIInvoker iAPIInvoker) {
        ValueEnforcer.notNull(iAPIInvoker, "Invoker");
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_aInvoker = iAPIInvoker;
            return this.m_aInvoker;
        });
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Registry", this.m_aRegistry).append("Invoker", this.m_aInvoker).getToString();
    }
}

