/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.http.EHttpMethod;
import com.helger.photon.api.APIPath;
import com.helger.photon.api.IAPIExceptionMapper;
import com.helger.photon.api.IAPIExecutionFilter;
import com.helger.photon.api.IAPIExecutor;
import com.helger.photon.api.pathdescriptor.PathDescriptor;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAPIDescriptor
extends Serializable {
    @Nonnull
    public APIPath getAPIPath();

    @Deprecated
    @Nonnull
    default public EHttpMethod getHTTPMethod() {
        return this.getHttpMethod();
    }

    @Nonnull
    default public EHttpMethod getHttpMethod() {
        return this.getAPIPath().getHttpMethod();
    }

    @Nonnull
    public PathDescriptor getPathDescriptor();

    @Nonnull
    public ISupplier<? extends IAPIExecutor> getExecutorFactory();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedSet<String> requiredHeaders();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedSet<String> requiredParams();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsOrderedSet<String> allowedMimeTypes();

    @Nullable
    public IAPIExecutionFilter getExecutionFilter();

    default public boolean hasExecutionFilter() {
        return this.getExecutionFilter() != null;
    }

    @Nullable
    public IAPIExceptionMapper getExceptionMapper();

    default public boolean hasExceptionMapper() {
        return this.getExceptionMapper() != null;
    }
}

