/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api;

import com.helger.commons.CGlobal;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.mutable.MutableInt;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.api.IAPIDescriptor;
import com.helger.photon.api.IAPIExecutor;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InvokableAPIDescriptor
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokableAPIDescriptor.class);
    private final IAPIDescriptor m_aDescriptor;
    private final String m_sPath;
    private final ICommonsOrderedMap<String, String> m_aPathVariables;

    public InvokableAPIDescriptor(@Nonnull IAPIDescriptor iAPIDescriptor, @Nonnull @Nonempty String string, @Nonnull ICommonsOrderedMap<String, String> iCommonsOrderedMap) {
        ValueEnforcer.notNull(iAPIDescriptor, "Descriptor");
        ValueEnforcer.notEmpty(string, "Path");
        ValueEnforcer.notNull(iCommonsOrderedMap, "PathVariables");
        this.m_aDescriptor = iAPIDescriptor;
        this.m_sPath = string;
        this.m_aPathVariables = iCommonsOrderedMap.getClone();
    }

    @Nonnull
    public final IAPIDescriptor getAPIDescriptor() {
        return this.m_aDescriptor;
    }

    @Nonnull
    @Nonempty
    public final String getPath() {
        return this.m_sPath;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<String, String> getAllPathVariables() {
        return this.m_aPathVariables.getClone();
    }

    public boolean canExecute(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull MutableInt mutableInt) {
        if (iRequestWebScopeWithoutResponse == null) {
            return false;
        }
        for (String object2 : this.m_aDescriptor.requiredHeaders()) {
            if (iRequestWebScopeWithoutResponse.headers().getFirstHeaderValue(object2) != null) continue;
            LOGGER.warn("Request '" + this.m_sPath + "' is missing required HTTP header '" + object2 + "'");
            return false;
        }
        for (String string : this.m_aDescriptor.requiredParams()) {
            if (iRequestWebScopeWithoutResponse.params().containsKey(string)) continue;
            LOGGER.warn("Request '" + this.m_sPath + "' is missing required HTTP parameter '" + string + "'");
            return false;
        }
        if (this.m_aDescriptor.hasExecutionFilter() && !this.m_aDescriptor.getExecutionFilter().canExecute(iRequestWebScopeWithoutResponse)) {
            LOGGER.warn("Request '" + this.m_sPath + "' cannot be executed because of ExecutionFilter");
            return false;
        }
        if (this.m_aDescriptor.allowedMimeTypes().isNotEmpty()) {
            String string;
            String string2 = iRequestWebScopeWithoutResponse.getContentType();
            MimeType mimeType = MimeTypeParser.safeParseMimeType(string2);
            String string3 = string = mimeType == null ? string2 : mimeType.getAsStringWithoutParameters();
            if (!this.m_aDescriptor.allowedMimeTypes().contains(string) && !this.m_aDescriptor.allowedMimeTypes().contains(string.toLowerCase(CGlobal.DEFAULT_LOCALE))) {
                LOGGER.warn("Request '" + this.m_sPath + "' contains the Content-Type '" + (String)string2 + "' which is not in the allowed list of " + this.m_aDescriptor.allowedMimeTypes());
                mutableInt.set(415);
                return false;
            }
        }
        return true;
    }

    public void invokeAPI(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        IAPIExecutor iAPIExecutor = (IAPIExecutor)this.m_aDescriptor.getExecutorFactory().get();
        if (iAPIExecutor == null) {
            throw new IllegalStateException("Failed to created API executor for: " + this.toString());
        }
        iAPIExecutor.invokeAPI(this.m_aDescriptor, this.m_sPath, this.m_aPathVariables, iRequestWebScopeWithoutResponse, unifiedResponse);
    }

    public String toString() {
        return new ToStringGenerator(this).append("APIDescriptor", this.m_aDescriptor).append("Path", this.m_sPath).append("PathVariables", this.m_aPathVariables).getToString();
    }
}

