/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api.callback;

import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.photon.api.IAPIExceptionCallback;
import com.helger.photon.api.IAPIInvoker;
import com.helger.photon.api.InvokableAPIDescriptor;
import com.helger.servlet.request.RequestLogger;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAPIExceptionCallback
implements IAPIExceptionCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingAPIExceptionCallback.class);

    @Override
    public void onAPIExecutionException(@Nonnull IAPIInvoker iAPIInvoker, @Nonnull InvokableAPIDescriptor invokableAPIDescriptor, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull Throwable throwable) {
        if (throwable instanceof IOException) {
            if (!StreamHelper.isKnownEOFException(throwable)) {
                LOGGER.error("Error writing result of API '" + invokableAPIDescriptor.getPath() + "' with " + invokableAPIDescriptor, throwable);
            }
        } else {
            LOGGER.error("Error invoking API '" + invokableAPIDescriptor.getPath() + "' on " + invokableAPIDescriptor, throwable);
            if (GlobalDebug.isDebugMode()) {
                RequestLogger.logRequestComplete(iRequestWebScopeWithoutResponse.getRequest());
            }
        }
    }
}

