/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api.pathdescriptor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.api.pathdescriptor.EPathDescriptorVariableConstraintType;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PathDescriptorVariableConstraint
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathDescriptorVariableConstraint.class);
    private final EPathDescriptorVariableConstraintType m_eConstraintType;
    private final String m_sConstraintValue;

    private PathDescriptorVariableConstraint(@Nonnull EPathDescriptorVariableConstraintType ePathDescriptorVariableConstraintType, @Nullable String string) {
        this.m_eConstraintType = ValueEnforcer.notNull(ePathDescriptorVariableConstraintType, "ConstraintType");
        this.m_sConstraintValue = string;
    }

    @Nonnull
    public EPathDescriptorVariableConstraintType getConstraintType() {
        return this.m_eConstraintType;
    }

    @Nullable
    public String getConstraintValue() {
        return this.m_sConstraintValue;
    }

    public boolean matches(String string) {
        switch (this.m_eConstraintType) {
            case REGEX: {
                return RegExHelper.stringMatchesPattern(this.m_sConstraintValue, string);
            }
        }
        throw new IllegalStateException("Constraint type " + this.m_eConstraintType + " is not implemented yet!");
    }

    @Nonnull
    @Nonempty
    public String getAsURLString() {
        if (this.m_eConstraintType.isRequiresValue()) {
            return this.m_eConstraintType.getID() + '=' + this.m_sConstraintValue;
        }
        return this.m_eConstraintType.getID();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PathDescriptorVariableConstraint pathDescriptorVariableConstraint = (PathDescriptorVariableConstraint)object;
        return this.m_eConstraintType.equals(pathDescriptorVariableConstraint.m_eConstraintType) && EqualsHelper.equals(this.m_sConstraintValue, pathDescriptorVariableConstraint.m_sConstraintValue);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eConstraintType)).append(this.m_sConstraintValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("ConstraintType", this.m_eConstraintType).appendIfNotNull("ConstraintValue", this.m_sConstraintValue).getToString();
    }

    @Nullable
    public static PathDescriptorVariableConstraint createOrNull(@Nonnull String string) {
        String string2 = StringHelper.trim(string);
        if (StringHelper.hasNoText(string2)) {
            LOGGER.warn("Empty path descriptor variable constraint is ignored!");
            return null;
        }
        ICommonsList<String> iCommonsList = StringHelper.getExploded('=', string, 2);
        String string3 = (String)iCommonsList.getAtIndex(0);
        EPathDescriptorVariableConstraintType ePathDescriptorVariableConstraintType = EPathDescriptorVariableConstraintType.getFromIDOrNull(string3);
        if (ePathDescriptorVariableConstraintType == null) {
            LOGGER.error("Unsupported variable constraint type '" + string3 + "' used!");
            return null;
        }
        String string4 = (String)iCommonsList.getAtIndex(1);
        if (ePathDescriptorVariableConstraintType.isRequiresValue() && StringHelper.hasNoText(string4)) {
            LOGGER.error("Variable constraint type '" + string3 + "' requires a value but no value provided! Separate type and value with a '=' character.");
            return null;
        }
        return new PathDescriptorVariableConstraint(ePathDescriptorVariableConstraintType, string4);
    }
}

