/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api.pathdescriptor;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;

public final class PathMatchingResult
implements Serializable {
    public static final PathMatchingResult NO_MATCH = new PathMatchingResult();
    private final boolean m_bMatch;
    private final ICommonsOrderedMap<String, String> m_aVariableValues;

    private PathMatchingResult() {
        this.m_bMatch = false;
        this.m_aVariableValues = null;
    }

    public PathMatchingResult(@Nonnull ICommonsOrderedMap<String, String> iCommonsOrderedMap) {
        ValueEnforcer.notNull(iCommonsOrderedMap, "VariableValues");
        this.m_bMatch = true;
        this.m_aVariableValues = iCommonsOrderedMap;
    }

    public boolean isMatch() {
        return this.m_bMatch;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllVariableValues() {
        return new CommonsLinkedHashMap<String, String>((Map<String, String>)this.m_aVariableValues);
    }

    public String toString() {
        return new ToStringGenerator(null).append("Match", this.m_bMatch).appendIfNotNull("VariableValues", this.m_aVariableValues).getToString();
    }

    @Nonnull
    public static PathMatchingResult createSuccess(@Nonnull ICommonsOrderedMap<String, String> iCommonsOrderedMap) {
        return new PathMatchingResult(iCommonsOrderedMap);
    }
}

