/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.api.servlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.functional.ISupplier;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.mutable.MutableInt;
import com.helger.http.EHttpVersion;
import com.helger.photon.api.APIPath;
import com.helger.photon.api.GlobalAPIInvoker;
import com.helger.photon.api.IAPIInvoker;
import com.helger.photon.api.IAPIRegistry;
import com.helger.photon.api.InvokableAPIDescriptor;
import com.helger.photon.app.PhotonUnifiedResponse;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIXServletHandler
implements IXServletSimpleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIXServletHandler.class);
    private final ISupplier<? extends IAPIRegistry> m_aRegistryFactory;
    private final ISupplier<? extends IAPIInvoker> m_aInvokerFactory;

    public APIXServletHandler() {
        this(() -> GlobalAPIInvoker.getInstance().getRegistry(), () -> GlobalAPIInvoker.getInstance().getInvoker());
    }

    public APIXServletHandler(@Nonnull ISupplier<? extends IAPIRegistry> iSupplier, @Nonnull ISupplier<? extends IAPIInvoker> iSupplier2) {
        this.m_aRegistryFactory = ValueEnforcer.notNull(iSupplier, "RegistryFactory");
        this.m_aInvokerFactory = ValueEnforcer.notNull(iSupplier2, "InvokerFactory");
    }

    @Override
    @Nonnull
    public PhotonUnifiedResponse createUnifiedResponse(@Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull HttpServletRequest httpServletRequest, @Nonnull IRequestWebScope iRequestWebScope) {
        return new PhotonUnifiedResponse(eHttpVersion, eHttpMethod, httpServletRequest, iRequestWebScope);
    }

    @Override
    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        EHttpMethod eHttpMethod = iRequestWebScopeWithoutResponse.getHttpMethod();
        if (eHttpMethod == null) {
            LOGGER.error("Missing HTTP method in request: " + iRequestWebScopeWithoutResponse.getRequest());
            unifiedResponse.setStatus(501);
            return;
        }
        APIPath aPIPath = APIPath.createForServlet(iRequestWebScopeWithoutResponse);
        IAPIRegistry iAPIRegistry = (IAPIRegistry)this.m_aRegistryFactory.get();
        IAPIInvoker iAPIInvoker = (IAPIInvoker)this.m_aInvokerFactory.get();
        InvokableAPIDescriptor invokableAPIDescriptor = iAPIRegistry.getAPIByPath(aPIPath);
        if (invokableAPIDescriptor == null) {
            LOGGER.warn("Unknown API " + eHttpMethod + " '" + aPIPath.getPath() + "' requested!");
            unifiedResponse.setStatus(404);
        } else {
            MutableInt mutableInt = new MutableInt(400);
            if (!invokableAPIDescriptor.canExecute(iRequestWebScopeWithoutResponse, mutableInt)) {
                int n = mutableInt.intValue();
                LOGGER.warn("API " + eHttpMethod + " '" + aPIPath.getPath() + "' cannot be executed for the current request. Returning HTTP " + n);
                unifiedResponse.setStatus(n);
            } else {
                unifiedResponse.disableCaching();
                try {
                    iAPIInvoker.invoke(invokableAPIDescriptor, iRequestWebScopeWithoutResponse, (UnifiedResponse)GenericReflection.uncheckedCast(unifiedResponse));
                    if (unifiedResponse.isStatusCodeDefined() || unifiedResponse.isRedirectDefined()) {
                        unifiedResponse.removeCaching();
                    } else if (!(unifiedResponse.isStatusCodeDefined() || unifiedResponse.isRedirectDefined() || unifiedResponse.hasContent())) {
                        unifiedResponse.setStatus(204);
                    }
                }
                catch (IOException | ServletException exception) {
                    throw exception;
                }
                catch (Throwable throwable) {
                    throw new ServletException("Error invoking API " + eHttpMethod + " '" + aPIPath.getPath() + "'", throwable);
                }
            }
        }
    }
}

