/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.url.ISimpleURL;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.url.IWebURIToURLConverter;
import com.helger.photon.app.url.StreamOrLocalURIToURLConverter;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PhotonAppSettings {
    public static final String DEFAULT_RESOURCE_BUNDLE_SERVLET_NAME = "resbundle";
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonAppSettings.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IWebURIToURLConverter s_aURIToURLConverter = new StreamOrLocalURIToURLConverter();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bMergeCSSResources = GlobalDebug.isProductionMode();
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bMergeJSResources = GlobalDebug.isProductionMode();
    @GuardedBy(value="s_aRWLock")
    private static String s_sResourceBundleServletName = "resbundle";

    private PhotonAppSettings() {
    }

    @Nonnull
    public static IWebURIToURLConverter getURIToURLConverter() {
        return s_aRWLock.readLockedGet(() -> s_aURIToURLConverter);
    }

    public static void setURIToURLConverter(@Nonnull IWebURIToURLConverter iWebURIToURLConverter) {
        ValueEnforcer.notNull(iWebURIToURLConverter, "URIToURLConverter");
        s_aRWLock.writeLockedGet(() -> {
            s_aURIToURLConverter = iWebURIToURLConverter;
            return s_aURIToURLConverter;
        });
    }

    @Nonnull
    public static ISimpleURL getCSSPath(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull ICSSPathProvider iCSSPathProvider, boolean bl) {
        String string = iCSSPathProvider.getCSSItemPath(bl);
        return PhotonAppSettings.getURIToURLConverter().getAsURL(iRequestWebScopeWithoutResponse, string);
    }

    @Nonnull
    public static ISimpleURL getJSPath(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IJSPathProvider iJSPathProvider, boolean bl) {
        String string = iJSPathProvider.getJSItemPath(bl);
        return PhotonAppSettings.getURIToURLConverter().getAsURL(iRequestWebScopeWithoutResponse, string);
    }

    public static boolean isMergeCSSResources() {
        return s_aRWLock.readLockedBoolean(() -> s_bMergeCSSResources);
    }

    public static void setMergeCSSResources(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bMergeCSSResources = bl;
            return s_bMergeCSSResources;
        });
        if (!HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info(bl ? "Merging CSS resources" : "Using separate CSS resources");
        }
    }

    public static boolean isMergeJSResources() {
        return s_aRWLock.readLockedBoolean(() -> s_bMergeJSResources);
    }

    public static void setMergeJSResources(boolean bl) {
        s_aRWLock.writeLockedBoolean(() -> {
            s_bMergeJSResources = bl;
            return s_bMergeJSResources;
        });
        if (!HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info(bl ? "Merging JS resources" : "Using separate JS resources");
        }
    }

    @Nonnull
    @Nonempty
    public static String getResourceBundleServletName() {
        return s_aRWLock.readLockedGet(() -> s_sResourceBundleServletName);
    }

    public static void setResourceBundleServletName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "ResourceBundleServletName");
        s_aRWLock.writeLockedGet(() -> {
            s_sResourceBundleServletName = string;
            return s_sResourceBundleServletName;
        });
        if (!HCSettings.isSilentMode() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Using ResourceBundleServlet name '" + string + "'");
        }
    }
}

