/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hierarchy.IHasChildrenSorted;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.serialize.SerializationHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.css.media.ICSSMediaList;
import com.helger.html.hc.IHCHasChildrenMutable;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.IHCNodeList;
import com.helger.html.hc.config.HCConversionSettings;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.config.IHCOnDocumentReadyProvider;
import com.helger.html.hc.html.root.HCHtml;
import com.helger.html.hc.impl.HCNodeList;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.hc.special.HCSpecialNodeHandler;
import com.helger.html.hc.special.HCSpecialNodes;
import com.helger.html.hc.special.IHCSpecialNodes;
import com.helger.html.resource.css.ICSSCodeProvider;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.http.EHttpVersion;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.json.serialize.IJsonWriterSettings;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.photon.app.PhotonAppManager;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.html.PhotonCSS;
import com.helger.photon.app.html.PhotonHTMLHelper;
import com.helger.photon.app.html.PhotonJS;
import com.helger.servlet.mock.MockHttpServletRequest;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.response.EContentDispositionType;
import com.helger.servlet.response.ERedirectMode;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Node;

public class PhotonUnifiedResponse
extends UnifiedResponse {
    private final IRequestWebScopeWithoutResponse m_aRequestScope;
    private IXMLWriterSettings m_aXWS = XMLWriterSettings.DEFAULT_XML_SETTINGS;
    private IJsonWriterSettings m_aJWS = JsonWriterSettings.DEFAULT_SETTINGS;

    public PhotonUnifiedResponse(@Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, @Nonnull HttpServletRequest httpServletRequest, @Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        super(eHttpVersion, eHttpMethod, httpServletRequest);
        this.m_aRequestScope = iRequestWebScopeWithoutResponse;
    }

    protected final IRequestWebScopeWithoutResponse getRequestScope() {
        return this.m_aRequestScope;
    }

    @Nonnull
    public final IXMLWriterSettings getXMLWriterSettings() {
        return this.m_aXWS;
    }

    public final void setXMLWriterSettings(@Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull(iXMLWriterSettings, "XWS");
        this.m_aXWS = iXMLWriterSettings;
    }

    @Nonnull
    public final IJsonWriterSettings getJsonWriterSettings() {
        return this.m_aJWS;
    }

    public final void setJsonWriterSettings(@Nonnull IJsonWriterSettings iJsonWriterSettings) {
        ValueEnforcer.notNull(iJsonWriterSettings, "JWS");
        this.m_aJWS = iJsonWriterSettings;
    }

    @Nonnull
    public PhotonUnifiedResponse jsonEmpty() {
        return this.json(null);
    }

    @Nonnull
    public PhotonUnifiedResponse json(@Nullable IJson iJson) {
        String string = iJson != null ? iJson.getAsJsonString(this.m_aJWS) : "{}";
        Charset charset = StandardCharsets.UTF_8;
        this.setContentAndCharset(string, charset);
        this.setMimeType(new MimeType(CMimeType.APPLICATION_JSON).addParameter("charset", charset.name()));
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse xml(@Nullable String string, @Nonnull Charset charset) {
        this.setContentAndCharset(StringHelper.getNotNull(string), charset);
        this.setMimeType(new MimeType(CMimeType.APPLICATION_XML).addParameter("charset", charset.name()));
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse xml(@Nullable IMicroNode iMicroNode) {
        return this.xml(iMicroNode, this.m_aXWS);
    }

    @Nonnull
    public PhotonUnifiedResponse xml(@Nullable IMicroNode iMicroNode, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        return this.xml(iMicroNode == null ? null : MicroWriter.getNodeAsString(iMicroNode, iXMLWriterSettings), iXMLWriterSettings.getCharset());
    }

    @Nonnull
    public PhotonUnifiedResponse xml(@Nullable Node node) {
        return this.xml(node, this.m_aXWS);
    }

    @Nonnull
    public PhotonUnifiedResponse xml(@Nullable Node node, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        return this.xml(node == null ? null : XMLWriter.getNodeAsString(node, iXMLWriterSettings), iXMLWriterSettings.getCharset());
    }

    @Nonnull
    public PhotonUnifiedResponse text(@Nullable String string) {
        this.setContentAndCharset(StringHelper.getNotNull(string), StandardCharsets.UTF_8);
        this.setMimeType(CMimeType.TEXT_PLAIN);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse html(@Nullable IHCNode iHCNode) {
        return this.html(iHCNode == null ? null : (iHCNode instanceof IHCHasChildrenMutable ? (IHCHasChildrenMutable)iHCNode : new HCNodeList().addChild(iHCNode)), null, null);
    }

    @Nonnull
    public PhotonUnifiedResponse html(@Nullable IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable, @Nullable IHCOnDocumentReadyProvider iHCOnDocumentReadyProvider, @Nullable IJsonObject iJsonObject) {
        HCSpecialNodes hCSpecialNodes = new HCSpecialNodes();
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("html", HtmlHelper.getHTMLString(this.m_aRequestScope, iHCHasChildrenMutable, hCSpecialNodes, iHCOnDocumentReadyProvider));
        HtmlHelper.addCSSAndJS(this.m_aRequestScope, hCSpecialNodes);
        jsonObject.addAll(iJsonObject);
        IJsonObject iJsonObject2 = HtmlHelper.getResponseAsJSON(jsonObject, hCSpecialNodes);
        return this.json(iJsonObject2);
    }

    @Nonnull
    public PhotonUnifiedResponse htmlSimple(@Nullable IHCNode iHCNode) {
        if (iHCNode == null) {
            this.setContentAndCharset("", HCSettings.getHTMLCharset());
        } else {
            this.setContentAndCharset(HCRenderer.getAsHTMLStringWithoutNamespaces(iHCNode), HCSettings.getHTMLCharset());
        }
        this.setMimeType(PhotonHTMLHelper.getMimeType(this.m_aRequestScope));
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse createOk() {
        this.setStatus(200);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse createAccepted() {
        this.setStatus(202);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse createNoContent() {
        this.setStatus(204);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse createSeeOther(@Nonnull ISimpleURL iSimpleURL) {
        ValueEnforcer.notNull(iSimpleURL, "Location");
        this.setRedirect(iSimpleURL, ERedirectMode.POST_REDIRECT_GET);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse createBadRequest() {
        this.setStatus(400);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse createNotFound() {
        this.setStatus(404);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse createConflict() {
        this.setStatus(409);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse createPreconditionFailed() {
        this.setStatus(412);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse createInternalServerError() {
        this.setStatus(500);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse setContent(@Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
        this.setContent(nonBlockingByteArrayOutputStream.directGetBuffer(), 0, nonBlockingByteArrayOutputStream.size());
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse serialized(@Nonnull Serializable serializable) {
        this.setContent(SerializationHelper.getSerializedByteArray(serializable));
        this.setMimeType(CMimeType.APPLICATION_OCTET_STREAM);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse pdf(@Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
        this.setContent(nonBlockingByteArrayOutputStream);
        this.setMimeType(CMimeType.APPLICATION_PDF);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse pdf(@Nonnull byte[] byArray, @Nonnull @Nonempty String string) {
        this.setContent(byArray);
        this.setMimeType(CMimeType.APPLICATION_PDF);
        this.setContentDispositionFilename(string);
        this.setContentDispositionType(EContentDispositionType.INLINE);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse pdf(@Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream, @Nonnull @Nonempty String string) {
        this.pdf(nonBlockingByteArrayOutputStream);
        this.setContentDispositionFilename(string);
        this.setContentDispositionType(EContentDispositionType.INLINE);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse attachment(@Nonnull @Nonempty String string) {
        this.setContentDispositionFilename(string);
        this.setContentDispositionType(EContentDispositionType.ATTACHMENT);
        return this;
    }

    @Nonnull
    public PhotonUnifiedResponse binary(@Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream, @Nonnull IMimeType iMimeType, @Nonnull @Nonempty String string) {
        this.setContent(nonBlockingByteArrayOutputStream);
        this.setMimeType(iMimeType);
        return this.attachment(string);
    }

    @Nonnull
    public static PhotonUnifiedResponse createSimple(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        HttpServletRequest httpServletRequest = iRequestWebScopeWithoutResponse.getRequest();
        if (httpServletRequest instanceof MockHttpServletRequest) {
            return new PhotonUnifiedResponse(EHttpVersion.HTTP_11, EHttpMethod.GET, httpServletRequest, iRequestWebScopeWithoutResponse);
        }
        return new PhotonUnifiedResponse(RequestHelper.getHttpVersion(httpServletRequest), RequestHelper.getHttpMethod(httpServletRequest), httpServletRequest, iRequestWebScopeWithoutResponse);
    }

    public static final class HtmlHelper {
        public static final String PROPERTY_VALUE = "value";
        public static final String PROPERTY_EXTERNAL_CSS = "externalcss";
        public static final String PROPERTY_INLINE_CSS_BEFORE_EXTERNAL = "inlinecssBeforeExternal";
        public static final String PROPERTY_INLINE_CSS_AFTER_EXTERNAL = "inlinecssAfterExternal";
        public static final String SUBPROPERTY_CSS_MEDIA = "media";
        public static final String SUBPROPERTY_CSS_HREF = "href";
        public static final String SUBPROPERTY_CSS_CONTENT = "content";
        public static final String PROPERTY_EXTERNAL_JS = "externaljs";
        public static final String PROPERTY_INLINE_JS_BEFORE_EXTERNAL = "inlinejsBeforeExternal";
        public static final String PROPERTY_INLINE_JS_AFTER_EXTERNAL = "inlinejsAfterExternal";
        public static final String PROPERTY_HTML = "html";

        private HtmlHelper() {
        }

        @Nonnull
        public static String getHTMLString(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nullable IHCHasChildrenMutable<?, ? super IHCNode> iHCHasChildrenMutable, @Nonnull HCSpecialNodes hCSpecialNodes, @Nullable IHCOnDocumentReadyProvider iHCOnDocumentReadyProvider) {
            Object object;
            IHasChildrenSorted<IMicroNode> iHasChildrenSorted;
            ValueEnforcer.notNull(iRequestWebScopeWithoutResponse, "RequestScope");
            ValueEnforcer.notNull(hCSpecialNodes, "SpecialNodes");
            if (iHCHasChildrenMutable == null) {
                return "";
            }
            HCConversionSettings hCConversionSettings = HCSettings.getConversionSettingsWithoutNamespaces();
            IHasChildrenSorted<IHCNode> iHasChildrenSorted2 = iHCHasChildrenMutable;
            if (iHCHasChildrenMutable instanceof IHCNodeList && ((IHCNodeList)iHCHasChildrenMutable).getChildCount() == 1 && ((IHCNodeList)iHCHasChildrenMutable).getFirstChild() instanceof HCHtml) {
                iHasChildrenSorted = (HCHtml)((IHCNodeList)iHCHasChildrenMutable).getFirstChild();
                iHasChildrenSorted2 = iHasChildrenSorted;
                HCRenderer.prepareForConversion(iHasChildrenSorted, ((HCHtml)iHasChildrenSorted).body(), hCConversionSettings);
                if (hCConversionSettings.isExtractOutOfBandNodes()) {
                    object = ((HCHtml)iHasChildrenSorted).getAllOutOfBandNodesWithMergedInlineNodes();
                    ((HCHtml)iHasChildrenSorted).addAllOutOfBandNodesToHead((List<IHCNode>)object);
                }
                PhotonHTMLHelper.mergeExternalCSSAndJSNodes(iRequestWebScopeWithoutResponse, ((HCHtml)iHasChildrenSorted).head(), PhotonAppSettings.isMergeCSSResources(), PhotonAppSettings.isMergeJSResources(), PhotonAppManager.getWebSiteResourceBundleMgr());
                if (HCSettings.isScriptsInBody()) {
                    ((HCHtml)iHasChildrenSorted).moveScriptElementsToBody();
                }
            } else {
                HCRenderer.prepareForConversion(iHCHasChildrenMutable, iHCHasChildrenMutable, hCConversionSettings);
                if (hCConversionSettings.isExtractOutOfBandNodes()) {
                    HCSpecialNodeHandler.extractSpecialContent(iHCHasChildrenMutable, hCSpecialNodes, iHCOnDocumentReadyProvider);
                }
            }
            iHasChildrenSorted = iHasChildrenSorted2.convertToMicroNode(hCConversionSettings);
            object = iHasChildrenSorted == null ? "" : MicroWriter.getNodeAsString((IMicroNode)iHasChildrenSorted, hCConversionSettings.getXMLWriterSettings());
            return object;
        }

        public static void addCSSAndJS(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull HCSpecialNodes hCSpecialNodes) {
            ValueEnforcer.notNull(iRequestWebScopeWithoutResponse, "RequestScope");
            boolean bl = HCSettings.isUseRegularResources();
            for (ICSSPathProvider iHTMLResourceProvider : PhotonCSS.getAllRegisteredCSSIncludesForThisRequest()) {
                hCSpecialNodes.addExternalCSS(iHTMLResourceProvider.getMediaList(), PhotonAppSettings.getCSSPath(iRequestWebScopeWithoutResponse, iHTMLResourceProvider, bl).getAsStringWithEncodedParameters());
            }
            for (IJSPathProvider iJSPathProvider : PhotonJS.getAllRegisteredJSIncludesForThisRequest()) {
                hCSpecialNodes.addExternalJS(PhotonAppSettings.getJSPath(iRequestWebScopeWithoutResponse, iJSPathProvider, bl).getAsStringWithEncodedParameters());
            }
        }

        @Nonnull
        public static IJsonObject getResponseAsJSON(@Nullable IJsonObject iJsonObject, @Nonnull IHCSpecialNodes iHCSpecialNodes) {
            JsonArray jsonArray;
            JsonObject jsonObject = new JsonObject();
            if (iJsonObject != null) {
                jsonObject.addJson(PROPERTY_VALUE, iJsonObject);
            }
            if (iHCSpecialNodes.hasExternalCSSs()) {
                jsonArray = new JsonArray();
                for (Map.Entry object : iHCSpecialNodes.getAllExternalCSSs().entrySet()) {
                    for (String string : (ICommonsList)object.getValue()) {
                        jsonArray.add(new JsonObject().add(SUBPROPERTY_CSS_MEDIA, ((ICSSMediaList)object.getKey()).getMediaString()).add(SUBPROPERTY_CSS_HREF, string));
                    }
                }
                jsonObject.addJson(PROPERTY_EXTERNAL_CSS, jsonArray);
            }
            if (iHCSpecialNodes.hasInlineCSSBeforeExternal()) {
                jsonArray = new JsonArray();
                for (ICSSCodeProvider iCSSCodeProvider : iHCSpecialNodes.getAllInlineCSSBeforeExternal()) {
                    jsonArray.add(new JsonObject().add(SUBPROPERTY_CSS_MEDIA, iCSSCodeProvider.getMediaList().getMediaString()).add(SUBPROPERTY_CSS_CONTENT, iCSSCodeProvider.getCSSCode()));
                }
                jsonObject.addJson(PROPERTY_INLINE_CSS_BEFORE_EXTERNAL, jsonArray);
            }
            if (iHCSpecialNodes.hasInlineCSSAfterExternal()) {
                jsonArray = new JsonArray();
                for (ICSSCodeProvider iCSSCodeProvider : iHCSpecialNodes.getAllInlineCSSAfterExternal()) {
                    jsonArray.add(new JsonObject().add(SUBPROPERTY_CSS_MEDIA, iCSSCodeProvider.getMediaList().getMediaString()).add(SUBPROPERTY_CSS_CONTENT, iCSSCodeProvider.getCSSCode()));
                }
                jsonObject.addJson(PROPERTY_INLINE_CSS_AFTER_EXTERNAL, jsonArray);
            }
            if (iHCSpecialNodes.hasExternalJSs()) {
                jsonObject.add(PROPERTY_EXTERNAL_JS, iHCSpecialNodes.getAllExternalJSs());
            }
            if (iHCSpecialNodes.hasInlineJSBeforeExternal()) {
                jsonObject.add(PROPERTY_INLINE_JS_BEFORE_EXTERNAL, iHCSpecialNodes.getInlineJSBeforeExternal().getJSCode());
            }
            if (iHCSpecialNodes.hasInlineJSAfterExternal()) {
                jsonObject.add(PROPERTY_INLINE_JS_AFTER_EXTERNAL, iHCSpecialNodes.getInlineJSAfterExternal().getJSCode());
            }
            return jsonObject;
        }
    }
}

