/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.photon.app.html.IWebResourceSet;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CSSResourceSet
implements IWebResourceSet<ICSSPathProvider> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSResourceSet.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<ICSSPathProvider> m_aList = new CommonsArrayList<ICSSPathProvider>();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<ICSSPathProvider> m_aSet = new CommonsHashSet<ICSSPathProvider>();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bIsCollected = false;

    public CSSResourceSet() {
    }

    public CSSResourceSet(@Nonnull CSSResourceSet cSSResourceSet) {
        ValueEnforcer.notNull(cSSResourceSet, "Other");
        for (ICSSPathProvider iCSSPathProvider : cSSResourceSet) {
            this.addItem(iCSSPathProvider);
        }
    }

    public CSSResourceSet(@Nonnull Collection<? extends ICSSPathProvider> collection) {
        ValueEnforcer.notEmptyNoNullValue(collection, "Other");
        for (ICSSPathProvider iCSSPathProvider : collection) {
            this.addItem(iCSSPathProvider);
        }
    }

    public CSSResourceSet(ICSSPathProvider ... iCSSPathProviderArray) {
        ValueEnforcer.notEmptyNoNullValue(iCSSPathProviderArray, "Other");
        for (ICSSPathProvider iCSSPathProvider : iCSSPathProviderArray) {
            this.addItem(iCSSPathProvider);
        }
    }

    private static void _collectWarn(@Nonnull String string) {
        LOGGER.warn(string);
    }

    @Override
    @Nonnull
    public EChange addItem(@Nonnull ICSSPathProvider iCSSPathProvider) {
        return this.addItem(-1, iCSSPathProvider);
    }

    @Override
    @Nonnull
    public EChange addItem(int n, @Nonnull ICSSPathProvider iCSSPathProvider) {
        ValueEnforcer.notNull(iCSSPathProvider, "CSSPathProvider");
        return this.m_aRWLock.writeLockedGet(() -> {
            if (!this.m_aSet.add(iCSSPathProvider)) {
                return EChange.UNCHANGED;
            }
            if (n >= 0) {
                this.m_aList.add(n, iCSSPathProvider);
            } else {
                this.m_aList.add(iCSSPathProvider);
            }
            if (this.m_bIsCollected) {
                CSSResourceSet._collectWarn("Adding item " + iCSSPathProvider + " after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    public EChange addItems(@Nonnull IWebResourceSet<? extends ICSSPathProvider> iWebResourceSet) {
        ValueEnforcer.notNull(iWebResourceSet, "Items");
        EChange eChange = EChange.UNCHANGED;
        for (ICSSPathProvider iCSSPathProvider : iWebResourceSet) {
            eChange = eChange.or(this.addItem(iCSSPathProvider));
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange addItems(int n, @Nonnull IWebResourceSet<? extends ICSSPathProvider> iWebResourceSet) {
        ValueEnforcer.notNull(iWebResourceSet, "Items");
        if (n < 0) {
            return this.addItems(iWebResourceSet);
        }
        EChange eChange = EChange.UNCHANGED;
        int n2 = n;
        for (ICSSPathProvider iCSSPathProvider : iWebResourceSet) {
            if (!this.addItem(n2, iCSSPathProvider).isChanged()) continue;
            eChange = EChange.CHANGED;
            ++n2;
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange removeItem(@Nonnull ICSSPathProvider iCSSPathProvider) {
        ValueEnforcer.notNull(iCSSPathProvider, "CSSPathProvider");
        return this.m_aRWLock.writeLockedGet(() -> {
            if (!this.m_aSet.remove(iCSSPathProvider)) {
                return EChange.UNCHANGED;
            }
            this.m_aList.remove(iCSSPathProvider);
            if (this.m_bIsCollected) {
                CSSResourceSet._collectWarn("Removed item " + iCSSPathProvider + " after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    public EChange removeAll() {
        return this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aSet.isEmpty()) {
                return EChange.UNCHANGED;
            }
            this.m_aSet.clear();
            this.m_aList.clear();
            if (this.m_bIsCollected) {
                CSSResourceSet._collectWarn("Removed all items after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<ICSSPathProvider> getAllItems() {
        return this.m_aRWLock.readLockedGet(() -> new CommonsLinkedHashSet<ICommonsList<ICSSPathProvider>>(this.m_aList));
    }

    @Override
    public void getAllItems(@Nonnull Collection<? super ICSSPathProvider> collection) {
        ValueEnforcer.notNull(collection, "Target");
        this.m_aRWLock.readLockedBoolean(() -> collection.addAll(this.m_aList));
    }

    @Override
    public boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(this.m_aList::isEmpty);
    }

    @Override
    public boolean isNotEmpty() {
        return this.m_aRWLock.readLockedBoolean(this.m_aList::isNotEmpty);
    }

    @Override
    @Nonnegative
    public int getCount() {
        return this.m_aRWLock.readLockedInt(this.m_aList::size);
    }

    @Override
    @Nonnull
    public Iterator<ICSSPathProvider> iterator() {
        return this.m_aRWLock.readLockedGet(this.m_aList::iterator);
    }

    @Override
    public void markAsCollected() {
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_bIsCollected) {
                CSSResourceSet._collectWarn("Resource set was already collected before!");
            }
            this.m_bIsCollected = true;
        });
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSResourceSet cSSResourceSet = (CSSResourceSet)object;
        return this.m_aList.equals(cSSResourceSet.m_aList);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aList)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("list", this.m_aList).getToString();
    }
}

