/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.html.IWebResourceSet;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class JSResourceSet
implements IWebResourceSet<IJSPathProvider> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSResourceSet.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<IJSPathProvider> m_aList = new CommonsArrayList<IJSPathProvider>();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<IJSPathProvider> m_aItems = new CommonsLinkedHashSet<IJSPathProvider>();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bIsCollected = false;

    public JSResourceSet() {
    }

    public JSResourceSet(@Nonnull JSResourceSet jSResourceSet) {
        ValueEnforcer.notNull(jSResourceSet, "Other");
        for (IJSPathProvider iJSPathProvider : jSResourceSet) {
            this.addItem(iJSPathProvider);
        }
    }

    public JSResourceSet(@Nonnull Collection<? extends IJSPathProvider> collection) {
        ValueEnforcer.notEmptyNoNullValue(collection, "Other");
        for (IJSPathProvider iJSPathProvider : collection) {
            this.addItem(iJSPathProvider);
        }
    }

    public JSResourceSet(IJSPathProvider ... iJSPathProviderArray) {
        ValueEnforcer.notEmptyNoNullValue(iJSPathProviderArray, "Other");
        for (IJSPathProvider iJSPathProvider : iJSPathProviderArray) {
            this.addItem(iJSPathProvider);
        }
    }

    private static void _collectWarn(@Nonnull String string) {
        LOGGER.warn(string);
    }

    @Override
    @Nonnull
    public EChange addItem(@Nonnull IJSPathProvider iJSPathProvider) {
        return this.addItem(-1, iJSPathProvider);
    }

    @Override
    @Nonnull
    public EChange addItem(int n, @Nonnull IJSPathProvider iJSPathProvider) {
        ValueEnforcer.notNull(iJSPathProvider, "JSPathProvider");
        return this.m_aRWLock.writeLockedGet(() -> {
            if (!this.m_aItems.add(iJSPathProvider)) {
                return EChange.UNCHANGED;
            }
            if (n >= 0) {
                this.m_aList.add(n, iJSPathProvider);
            } else {
                this.m_aList.add(iJSPathProvider);
            }
            if (this.m_bIsCollected) {
                JSResourceSet._collectWarn("Adding item " + iJSPathProvider + " after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    public EChange addItems(@Nonnull IWebResourceSet<? extends IJSPathProvider> iWebResourceSet) {
        ValueEnforcer.notNull(iWebResourceSet, "Items");
        EChange eChange = EChange.UNCHANGED;
        for (IJSPathProvider iJSPathProvider : iWebResourceSet) {
            eChange = eChange.or(this.addItem(iJSPathProvider));
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange addItems(int n, @Nonnull IWebResourceSet<? extends IJSPathProvider> iWebResourceSet) {
        ValueEnforcer.notNull(iWebResourceSet, "Items");
        if (n < 0) {
            return this.addItems(iWebResourceSet);
        }
        EChange eChange = EChange.UNCHANGED;
        int n2 = n;
        for (IJSPathProvider iJSPathProvider : iWebResourceSet) {
            if (!this.addItem(n2, iJSPathProvider).isChanged()) continue;
            eChange = EChange.CHANGED;
            ++n2;
        }
        return eChange;
    }

    @Override
    @Nonnull
    public EChange removeItem(@Nonnull IJSPathProvider iJSPathProvider) {
        ValueEnforcer.notNull(iJSPathProvider, "JSPathProvider");
        return this.m_aRWLock.writeLockedGet(() -> {
            if (!this.m_aItems.remove(iJSPathProvider)) {
                return EChange.UNCHANGED;
            }
            this.m_aList.remove(iJSPathProvider);
            if (this.m_bIsCollected) {
                JSResourceSet._collectWarn("Removed item " + iJSPathProvider + " after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    public EChange removeAll() {
        return this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aItems.isEmpty()) {
                return EChange.UNCHANGED;
            }
            this.m_aItems.clear();
            this.m_aList.clear();
            if (this.m_bIsCollected) {
                JSResourceSet._collectWarn("Removed all items after collection!");
            }
            return EChange.CHANGED;
        });
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IJSPathProvider> getAllItems() {
        return this.m_aRWLock.readLockedGet(() -> new CommonsLinkedHashSet<ICommonsList<IJSPathProvider>>(this.m_aList));
    }

    @Override
    public void getAllItems(@Nonnull Collection<? super IJSPathProvider> collection) {
        ValueEnforcer.notNull(collection, "Target");
        this.m_aRWLock.readLockedBoolean(() -> collection.addAll(this.m_aList));
    }

    @Override
    public boolean isEmpty() {
        return this.m_aRWLock.readLockedBoolean(this.m_aList::isEmpty);
    }

    @Override
    public boolean isNotEmpty() {
        return this.m_aRWLock.readLockedBoolean(this.m_aList::isNotEmpty);
    }

    @Override
    @Nonnegative
    public int getCount() {
        return this.m_aRWLock.readLockedInt(this.m_aList::size);
    }

    @Override
    @Nonnull
    public Iterator<IJSPathProvider> iterator() {
        return this.m_aRWLock.readLockedGet(this.m_aList::iterator);
    }

    @Override
    public void markAsCollected() {
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_bIsCollected) {
                JSResourceSet._collectWarn("Resource set was already collected before!");
            }
            this.m_bIsCollected = true;
        });
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JSResourceSet jSResourceSet = (JSResourceSet)object;
        return this.m_aList.equals(jSResourceSet.m_aList);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aList)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("list", this.m_aList).getToString();
    }
}

