/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.concurrent.SimpleLock;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.css.CSSFilenameHelper;
import com.helger.css.media.CSSMediaList;
import com.helger.css.media.ECSSMedium;
import com.helger.html.resource.css.ConstantCSSPathProvider;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.html.CSSResourceSet;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PhotonCSS {
    public static final String DEFAULT_FILENAME = "html/css.xml";
    private static final String REQUEST_ATTR_CSSRESOURCES = PhotonCSS.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonCSS.class);
    private static final CSSResourceSet s_aGlobal = new CSSResourceSet();
    private static final SimpleLock s_aLock = new SimpleLock();

    private PhotonCSS() {
    }

    public static void _readCSSIncludes(@Nonnull IReadableResource iReadableResource, @Nonnull CSSResourceSet cSSResourceSet) {
        IMicroDocument iMicroDocument;
        ValueEnforcer.notNull(iReadableResource, "Res");
        ValueEnforcer.notNull(cSSResourceSet, "Target");
        IMicroDocument iMicroDocument2 = iMicroDocument = iReadableResource.exists() ? MicroReader.readMicroXML(iReadableResource) : null;
        if (iMicroDocument != null) {
            for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("css")) {
                String string = iMicroElement.getAttributeValue("path");
                if (StringHelper.hasNoText(string)) {
                    LOGGER.error("Found CSS item without a path in " + iReadableResource.getPath());
                    continue;
                }
                IReadableResource iReadableResource2 = PhotonAppSettings.getURIToURLConverter().getAsResource(string);
                if (!iReadableResource2.exists()) {
                    throw new IllegalStateException("The provided global CSS resource '" + string + "' resolved to '" + iReadableResource2 + "' does NOT exist!");
                }
                String string2 = iMicroElement.getAttributeValue("condcomment");
                String string3 = iMicroElement.getAttributeValue("media");
                CSSMediaList cSSMediaList = new CSSMediaList();
                if (string3 != null) {
                    for (String string4 : RegExHelper.getSplitToArray(string3, ",\\s*")) {
                        ECSSMedium eCSSMedium = ECSSMedium.getFromNameOrNull(string4);
                        if (eCSSMedium == null) {
                            LOGGER.warn("CSS item '" + string + "' in " + iReadableResource.getPath() + " has an invalid medium '" + string4 + "' - ignoring");
                            continue;
                        }
                        cSSMediaList.addMedium(eCSSMedium);
                    }
                }
                cSSResourceSet.addItem(new ConstantCSSPathProvider(string, CSSFilenameHelper.getMinifiedCSSFilename(string), string2, cSSMediaList, true));
            }
        }
    }

    public static void readCSSIncludesForGlobal(@Nonnull IReadableResource iReadableResource) {
        PhotonCSS._readCSSIncludes(iReadableResource, s_aGlobal);
    }

    public static void registerCSSIncludeForGlobal(@Nonnull ICSSPathProvider iCSSPathProvider) {
        s_aGlobal.addItem(iCSSPathProvider);
    }

    public static void registerCSSIncludeForGlobal(int n, @Nonnull ICSSPathProvider iCSSPathProvider) {
        s_aGlobal.addItem(n, iCSSPathProvider);
    }

    public static void unregisterCSSIncludeForGlobal(@Nonnull ICSSPathProvider iCSSPathProvider) {
        s_aGlobal.removeItem(iCSSPathProvider);
    }

    public static void unregisterAllCSSIncludesFromGlobal() {
        s_aGlobal.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<ICSSPathProvider> getAllRegisteredCSSIncludesForGlobal() {
        return s_aGlobal.getAllItems();
    }

    public static void getAllRegisteredCSSIncludesForGlobal(@Nonnull Collection<? super ICSSPathProvider> collection) {
        s_aGlobal.getAllItems(collection);
    }

    public static boolean hasRegisteredCSSIncludesForGlobal() {
        return s_aGlobal.isNotEmpty();
    }

    @Nullable
    private static CSSResourceSet _getPerRequestSet(boolean bl) {
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScope();
        return s_aLock.lockedGet(() -> {
            CSSResourceSet cSSResourceSet = (CSSResourceSet)iRequestWebScope.attrs().getCastedValue(REQUEST_ATTR_CSSRESOURCES);
            if (cSSResourceSet == null && bl) {
                cSSResourceSet = new CSSResourceSet();
                iRequestWebScope.attrs().putIn(REQUEST_ATTR_CSSRESOURCES, cSSResourceSet);
            }
            return cSSResourceSet;
        });
    }

    public static void registerCSSIncludeForThisRequest(@Nonnull ICSSPathProvider iCSSPathProvider) {
        PhotonCSS._getPerRequestSet(true).addItem(iCSSPathProvider);
    }

    public static void unregisterCSSIncludeFromThisRequest(@Nonnull ICSSPathProvider iCSSPathProvider) {
        CSSResourceSet cSSResourceSet = PhotonCSS._getPerRequestSet(false);
        if (cSSResourceSet != null) {
            cSSResourceSet.removeItem(iCSSPathProvider);
        }
    }

    public static void unregisterAllCSSIncludesFromThisRequest() {
        CSSResourceSet cSSResourceSet = PhotonCSS._getPerRequestSet(false);
        if (cSSResourceSet != null) {
            cSSResourceSet.removeAll();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<ICSSPathProvider> getAllRegisteredCSSIncludesForThisRequest() {
        CSSResourceSet cSSResourceSet = PhotonCSS._getPerRequestSet(false);
        if (cSSResourceSet == null) {
            return new CommonsLinkedHashSet<ICSSPathProvider>();
        }
        cSSResourceSet.markAsCollected();
        return cSSResourceSet.getAllItems();
    }

    public static void getAllRegisteredCSSIncludesForThisRequest(@Nonnull Collection<? super ICSSPathProvider> collection) {
        CSSResourceSet cSSResourceSet = PhotonCSS._getPerRequestSet(false);
        if (cSSResourceSet != null) {
            cSSResourceSet.markAsCollected();
            cSSResourceSet.getAllItems(collection);
        }
    }

    public static boolean hasRegisteredCSSIncludesForThisRequest() {
        CSSResourceSet cSSResourceSet = PhotonCSS._getPerRequestSet(false);
        return cSSResourceSet != null && cSSResourceSet.isNotEmpty();
    }
}

