/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.io.stream.HasInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.string.StringHelper;
import com.helger.html.hc.IHCConversionSettings;
import com.helger.html.hc.IHCNode;
import com.helger.html.hc.config.HCSettings;
import com.helger.html.hc.ext.HCConditionalCommentNode;
import com.helger.html.hc.html.metadata.HCCSSNodeDetector;
import com.helger.html.hc.html.metadata.HCHead;
import com.helger.html.hc.html.metadata.HCLink;
import com.helger.html.hc.html.metadata.HCMeta;
import com.helger.html.hc.html.root.HCHtml;
import com.helger.html.hc.html.script.HCJSNodeDetector;
import com.helger.html.hc.html.script.HCScriptFile;
import com.helger.html.hc.render.HCRenderer;
import com.helger.html.meta.EStandardMetaElement;
import com.helger.html.resource.css.ICSSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.html.IHTMLProvider;
import com.helger.photon.app.resource.IWebSiteResourceBundleProvider;
import com.helger.photon.app.resource.WebSiteResourceBundleSerialized;
import com.helger.photon.app.resource.WebSiteResourceWithCondition;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class PhotonHTMLHelper {
    private PhotonHTMLHelper() {
    }

    @Nonnull
    public static IMimeType getMimeType(@Nullable IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        return new MimeType(CMimeType.TEXT_HTML).addParameter("charset", HCSettings.getHTMLCharset().name());
    }

    @Nonnull
    public static IHCNode getCSSNode(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull ICSSPathProvider iCSSPathProvider, boolean bl) {
        HCLink hCLink = HCLink.createCSSLink(PhotonAppSettings.getCSSPath(iRequestWebScopeWithoutResponse, iCSSPathProvider, bl)).setMedia(iCSSPathProvider.getMediaList()).setPathProvider(iCSSPathProvider);
        String string = iCSSPathProvider.getConditionalComment();
        if (StringHelper.hasText(string)) {
            return new HCConditionalCommentNode(string, hCLink);
        }
        return hCLink;
    }

    @Nonnull
    public static IHCNode getJSNode(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull IJSPathProvider iJSPathProvider, boolean bl) {
        HCScriptFile hCScriptFile = new HCScriptFile().setSrc(PhotonAppSettings.getJSPath(iRequestWebScopeWithoutResponse, iJSPathProvider, bl)).setPathProvider(iJSPathProvider);
        String string = iJSPathProvider.getConditionalComment();
        if (StringHelper.hasText(string)) {
            return new HCConditionalCommentNode(string, hCScriptFile);
        }
        return hCScriptFile;
    }

    public static void createHTMLResponse(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse, @Nonnull IHTMLProvider iHTMLProvider) {
        HCHtml hCHtml = iHTMLProvider.createHTML(iRequestWebScopeWithoutResponse);
        hCHtml.head().metaElements().add(new HCMeta().setName(EStandardMetaElement.GENERATOR.getName()).setContent("https://github.com/phax/ph-oton // phax // ASL 2.0"));
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(51200);){
            IMimeType iMimeType = PhotonHTMLHelper.getMimeType(iRequestWebScopeWithoutResponse);
            IHCConversionSettings iHCConversionSettings = HCSettings.getConversionSettings();
            HCRenderer.writeHtmlTo(hCHtml, iHCConversionSettings, nonBlockingByteArrayOutputStream);
            unifiedResponse.setMimeType(iMimeType).setCharset(iHCConversionSettings.getCharset()).setContent(HasInputStream.multiple(nonBlockingByteArrayOutputStream::getAsInputStream)).disableCaching();
        }
    }

    public static void mergeExternalCSSAndJSNodes(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull HCHead hCHead, boolean bl, boolean bl2, @Nonnull IWebSiteResourceBundleProvider iWebSiteResourceBundleProvider) {
        WebSiteResourceBundleSerialized webSiteResourceBundleSerialized;
        Iterator iterator;
        boolean bl3;
        CommonsArrayList<WebSiteResourceWithCondition> commonsArrayList;
        CommonsArrayList<IHCNode> commonsArrayList2;
        if (!bl && !bl2) {
            return;
        }
        boolean bl4 = HCSettings.isUseRegularResources();
        if (bl) {
            commonsArrayList2 = new CommonsArrayList<IHCNode>();
            hCHead.getAllAndRemoveAllCSSNodes(commonsArrayList2);
            commonsArrayList = new CommonsArrayList<WebSiteResourceWithCondition>();
            for (IHCNode object : commonsArrayList2) {
                bl3 = true;
                if (HCCSSNodeDetector.isDirectCSSFileNode(object) && (iterator = ((HCLink)object).getPathProvider()) != null) {
                    commonsArrayList.add(WebSiteResourceWithCondition.createForCSS((ICSSPathProvider)((Object)iterator), bl4));
                    bl3 = false;
                }
                if (!bl3) continue;
                if (!commonsArrayList.isEmpty()) {
                    iterator = iWebSiteResourceBundleProvider.getResourceBundles(commonsArrayList, bl4).iterator();
                    while (iterator.hasNext()) {
                        webSiteResourceBundleSerialized = (WebSiteResourceBundleSerialized)iterator.next();
                        hCHead.addCSS(webSiteResourceBundleSerialized.createNode(iRequestWebScopeWithoutResponse));
                    }
                    commonsArrayList.clear();
                }
                hCHead.addCSS(object);
            }
            if (!commonsArrayList.isEmpty()) {
                for (WebSiteResourceBundleSerialized webSiteResourceBundleSerialized2 : iWebSiteResourceBundleProvider.getResourceBundles(commonsArrayList, bl4)) {
                    hCHead.addCSS(webSiteResourceBundleSerialized2.createNode(iRequestWebScopeWithoutResponse));
                }
            }
        }
        if (bl2) {
            commonsArrayList2 = new CommonsArrayList();
            hCHead.getAllAndRemoveAllJSNodes(commonsArrayList2);
            commonsArrayList = new CommonsArrayList();
            for (IHCNode iHCNode : commonsArrayList2) {
                bl3 = true;
                if (HCJSNodeDetector.isDirectJSFileNode(iHCNode) && (iterator = ((HCScriptFile)iHCNode).getPathProvider()) != null) {
                    commonsArrayList.add(WebSiteResourceWithCondition.createForJS((IJSPathProvider)((Object)iterator), bl4));
                    bl3 = false;
                }
                if (!bl3) continue;
                if (!commonsArrayList.isEmpty()) {
                    iterator = iWebSiteResourceBundleProvider.getResourceBundles(commonsArrayList, bl4).iterator();
                    while (iterator.hasNext()) {
                        webSiteResourceBundleSerialized = (WebSiteResourceBundleSerialized)iterator.next();
                        hCHead.addJS(webSiteResourceBundleSerialized.createNode(iRequestWebScopeWithoutResponse));
                    }
                    commonsArrayList.clear();
                }
                hCHead.addJS(iHCNode);
            }
            if (!commonsArrayList.isEmpty()) {
                for (WebSiteResourceBundleSerialized webSiteResourceBundleSerialized3 : iWebSiteResourceBundleProvider.getResourceBundles(commonsArrayList, bl4)) {
                    hCHead.addJS(webSiteResourceBundleSerialized3.createNode(iRequestWebScopeWithoutResponse));
                }
            }
        }
    }
}

