/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.app.html;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.concurrent.SimpleLock;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.html.js.JSFilenameHelper;
import com.helger.html.resource.js.ConstantJSPathProvider;
import com.helger.html.resource.js.IJSPathProvider;
import com.helger.photon.app.PhotonAppSettings;
import com.helger.photon.app.html.JSResourceSet;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class PhotonJS {
    public static final String DEFAULT_FILENAME = "html/js.xml";
    private static final String REQUEST_ATTR_JSRESOURCES = PhotonJS.class.getName();
    private static final Logger LOGGER = LoggerFactory.getLogger(PhotonJS.class);
    private static final JSResourceSet s_aGlobal = new JSResourceSet();
    private static final SimpleLock s_aLock = new SimpleLock();

    private PhotonJS() {
    }

    public static void _readJSIncludes(@Nonnull IReadableResource iReadableResource, @Nonnull JSResourceSet jSResourceSet) {
        IMicroDocument iMicroDocument;
        ValueEnforcer.notNull(iReadableResource, "Res");
        ValueEnforcer.notNull(jSResourceSet, "Target");
        IMicroDocument iMicroDocument2 = iMicroDocument = iReadableResource.exists() ? MicroReader.readMicroXML(iReadableResource) : null;
        if (iMicroDocument != null) {
            for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("js")) {
                String string = iMicroElement.getAttributeValue("path");
                if (StringHelper.hasNoText(string)) {
                    LOGGER.error("Found JS item without a path in " + iReadableResource.getPath());
                    continue;
                }
                IReadableResource iReadableResource2 = PhotonAppSettings.getURIToURLConverter().getAsResource(string);
                if (!iReadableResource2.exists()) {
                    throw new IllegalStateException("The provided global JS resource '" + string + "' resolved to '" + iReadableResource2 + "' does NOT exist!");
                }
                String string2 = iMicroElement.getAttributeValue("condcomment");
                jSResourceSet.addItem(new ConstantJSPathProvider(string, JSFilenameHelper.getMinifiedJSFilename(string), string2, true));
            }
        }
    }

    public static void readJSIncludesForGlobal(@Nonnull IReadableResource iReadableResource) {
        PhotonJS._readJSIncludes(iReadableResource, s_aGlobal);
    }

    public static void registerJSIncludeForGlobal(@Nonnull IJSPathProvider iJSPathProvider) {
        s_aGlobal.addItem(iJSPathProvider);
    }

    public static void registerJSIncludeForGlobal(int n, @Nonnull IJSPathProvider iJSPathProvider) {
        s_aGlobal.addItem(n, iJSPathProvider);
    }

    public static void unregisterJSIncludeForGlobal(@Nonnull IJSPathProvider iJSPathProvider) {
        s_aGlobal.removeItem(iJSPathProvider);
    }

    public static void unregisterAllJSIncludesFromGlobal() {
        s_aGlobal.removeAll();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IJSPathProvider> getAllRegisteredJSIncludesForGlobal() {
        return s_aGlobal.getAllItems();
    }

    public static void getAllRegisteredJSIncludesForGlobal(@Nonnull Collection<? super IJSPathProvider> collection) {
        s_aGlobal.getAllItems(collection);
    }

    public static boolean hasRegisteredJSIncludesForGlobal() {
        return s_aGlobal.isNotEmpty();
    }

    @Nullable
    private static JSResourceSet _getPerRequestSet(boolean bl) {
        IRequestWebScope iRequestWebScope = WebScopeManager.getRequestScope();
        return s_aLock.lockedGet(() -> {
            JSResourceSet jSResourceSet = (JSResourceSet)iRequestWebScope.attrs().getCastedValue(REQUEST_ATTR_JSRESOURCES);
            if (jSResourceSet == null && bl) {
                jSResourceSet = new JSResourceSet();
                iRequestWebScope.attrs().putIn(REQUEST_ATTR_JSRESOURCES, jSResourceSet);
            }
            return jSResourceSet;
        });
    }

    public static void registerJSIncludeForThisRequest(@Nonnull IJSPathProvider iJSPathProvider) {
        PhotonJS._getPerRequestSet(true).addItem(iJSPathProvider);
    }

    public static void unregisterJSIncludeFromThisRequest(@Nonnull IJSPathProvider iJSPathProvider) {
        JSResourceSet jSResourceSet = PhotonJS._getPerRequestSet(false);
        if (jSResourceSet != null) {
            jSResourceSet.removeItem(iJSPathProvider);
        }
    }

    public static void unregisterAllJSIncludesFromThisRequest() {
        JSResourceSet jSResourceSet = PhotonJS._getPerRequestSet(false);
        if (jSResourceSet != null) {
            jSResourceSet.removeAll();
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedSet<IJSPathProvider> getAllRegisteredJSIncludesForThisRequest() {
        JSResourceSet jSResourceSet = PhotonJS._getPerRequestSet(false);
        if (jSResourceSet == null) {
            return new CommonsLinkedHashSet<IJSPathProvider>();
        }
        jSResourceSet.markAsCollected();
        return jSResourceSet.getAllItems();
    }

    public static void getAllRegisteredJSIncludesForThisRequest(@Nonnull Collection<? super IJSPathProvider> collection) {
        JSResourceSet jSResourceSet = PhotonJS._getPerRequestSet(false);
        if (jSResourceSet != null) {
            jSResourceSet.markAsCollected();
            jSResourceSet.getAllItems(collection);
        }
    }

    public static boolean hasRegisteredJSIncludesForThisRequest() {
        JSResourceSet jSResourceSet = PhotonJS._getPerRequestSet(false);
        return jSResourceSet != null && jSResourceSet.isNotEmpty();
    }
}

